/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.block.IDisguisableBlock;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import flaxbeard.steamcraft.client.render.BlockSteamPipeRenderer;
import flaxbeard.steamcraft.misc.FluidHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityBoiler
extends SteamTransporterTileEntity
implements IFluidHandler,
ISidedInventory,
ISteamTransporter,
IWrenchable,
IDisguisableBlock {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{0, 1};
    private static final int[] slotsSides = new int[]{0, 1};
    public FluidTank myTank = new FluidTank(new FluidStack(FluidRegistry.WATER, 1), 10000);
    public int furnaceCookTime;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public Block disguiseBlock = null;
    public int disguiseMeta = 0;
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    private String field_145958_o;
    private boolean wasBurning;
    private boolean lastWrench = false;

    public TileEntityBoiler(int capacity) {
        super(capacity, new ForgeDirection[]{ForgeDirection.UP});
        this.addSideToGaugeBlacklist(ForgeDirection.UP);
        this.setPressureResistance(0.5f);
    }

    public TileEntityBoiler() {
        this(50000);
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74768_a("water", this.myTank.getFluidAmount());
        access.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        access.func_74777_a("CookTime", (short)this.furnaceCookTime);
        access.func_74777_a("cIBT", (short)this.currentItemBurnTime);
        access.func_74768_a("disguiseBlock", Block.func_149682_b((Block)this.disguiseBlock));
        access.func_74768_a("disguiseMeta", this.disguiseMeta);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.myTank.setFluid(new FluidStack(FluidRegistry.WATER, access.func_74762_e("water")));
        this.furnaceBurnTime = access.func_74765_d("BurnTime");
        this.currentItemBurnTime = access.func_74765_d("cIBT");
        this.furnaceCookTime = access.func_74765_d("CookTime");
        this.disguiseBlock = Block.func_149729_e((int)access.func_74762_e("disguiseBlock"));
        this.disguiseMeta = access.func_74762_e("disguiseMeta");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = (NBTTagList)par1NBTTagCompound.func_74781_a("Items");
        this.furnaceItemStacks = new ItemStack[2];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.currentItemBurnTime = par1NBTTagCompound.func_74765_d("cIBT");
        if (par1NBTTagCompound.func_74764_b("CustomName")) {
            this.field_145958_o = par1NBTTagCompound.func_74779_i("CustomName");
        }
        if (par1NBTTagCompound.func_74764_b("water")) {
            this.myTank.setFluid(new FluidStack(FluidRegistry.WATER, (int)par1NBTTagCompound.func_74765_d("water")));
        }
        this.disguiseBlock = Block.func_149729_e((int)par1NBTTagCompound.func_74762_e("disguiseBlock"));
        this.disguiseMeta = par1NBTTagCompound.func_74762_e("disguiseMeta");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        par1NBTTagCompound.func_74777_a("water", (short)this.myTank.getFluidAmount());
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        par1NBTTagCompound.func_74777_a("cIBT", (short)this.currentItemBurnTime);
        par1NBTTagCompound.func_74768_a("disguiseBlock", Block.func_149682_b((Block)this.disguiseBlock));
        par1NBTTagCompound.func_74768_a("disguiseMeta", this.disguiseMeta);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            par1NBTTagCompound.func_74778_a("CustomName", this.field_145958_o);
        }
    }

    public void superUpdateOnly() {
        super.func_145845_h();
    }

    @Override
    public void func_145845_h() {
        ItemStack stackInInput;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            boolean hasWrench = BlockSteamPipeRenderer.updateWrenchStatus();
            if (hasWrench != this.lastWrench && this.disguiseBlock != null && this.disguiseBlock != Blocks.field_150350_a) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.lastWrench = hasWrench;
        }
        if (FluidHelper.itemStackIsWaterContainer(stackInInput = this.func_70301_a(1))) {
            ItemStack drainedItemStack = FluidHelper.fillTankFromItem(stackInInput, (IFluidTank)this.myTank);
            this.func_70299_a(1, drainedItemStack);
        }
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        int maxThisTick = 10;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityBoiler.getItemBurnTime(this.furnaceItemStacks[0]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.furnaceItemStacks[0] != null) {
                        --this.furnaceItemStacks[0].field_77994_a;
                        if (this.furnaceItemStacks[0].field_77994_a == 0) {
                            this.furnaceItemStacks[0] = this.furnaceItemStacks[0].func_77973_b().getContainerItem(this.furnaceItemStacks[0]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt() && this.getNetwork() != null) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime > 0) {
                    this.getNetwork().addSteam(10);
                    this.myTank.drain(2, true);
                    this.furnaceCookTime = 0;
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.wasBurning != this.isBurning()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.wasBurning = this.isBurning();
        }
    }

    private boolean canSmelt() {
        return this.myTank.getFluidAmount() > 9;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canDrainItem(ItemStack stack) {
        return stack.field_77994_a == 1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.myTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.myTank)};
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.furnaceItemStacks[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack itemstack = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.field_145958_o : "container.furnace";
    }

    public boolean func_145818_k_() {
        return this.field_145958_o != null && this.field_145958_o.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public int getPressureAsInt() {
        return (int)Math.floor((double)this.getPressure() * 1000.0);
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 ? TileEntityBoiler.getItemBurnTime(stack) > 0 : FluidHelper.itemStackIsWaterContainer(stack);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par2ItemStack.func_77973_b() == Items.field_151133_ar;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int p_145953_1_) {
        return this.furnaceCookTime * p_145953_1_ / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * p_145955_1_ / this.currentItemBurnTime;
    }

    public FluidTank getTank() {
        return this.myTank;
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        if (player.func_70093_af()) {
            if (this.disguiseBlock != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(this.disguiseBlock, 1, this.disguiseMeta));
                    world.func_72838_d((Entity)entityItem);
                }
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.disguiseBlock.field_149762_H.func_150495_a(), (this.disguiseBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.disguiseBlock.field_149762_H.func_150494_d() * 0.8f);
                this.disguiseBlock = null;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public Block getDisguiseBlock() {
        return this.disguiseBlock;
    }

    @Override
    public void setDisguiseBlock(Block block) {
        this.disguiseBlock = block;
    }

    @Override
    public int getDisguiseMeta() {
        return this.disguiseMeta;
    }

    @Override
    public void setDisguiseMeta(int meta) {
        this.disguiseMeta = meta;
    }
}

