/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.library.tools.ToolCore;

public class TileEntitySteamCharger
extends SteamTransporterTileEntity
implements ISteamTransporter,
IInventory {
    public int randomDegrees;
    private boolean isCharging = false;
    private boolean hadItem = false;
    private float prevPercent = 0.0f;
    private ItemStack[] inventory = new ItemStack[1];

    public TileEntitySteamCharger() {
        super(new ForgeDirection[]{ForgeDirection.DOWN});
        this.addSidesToGaugeBlacklist(new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN});
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.randomDegrees = (int)(Math.random() * 360.0);
        if (par1NBTTagCompound.func_74764_b("inventory")) {
            this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)par1NBTTagCompound.func_74775_l("inventory"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        if (this.inventory[0] != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.inventory[0].func_77955_b(nbttagcompound1);
            par1NBTTagCompound.func_74782_a("inventory", (NBTBase)nbttagcompound1);
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        if (this.inventory[0] != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.inventory[0].func_77955_b(nbttagcompound1);
            access.func_74782_a("inventory", (NBTBase)nbttagcompound1);
        }
        access.func_74757_a("isCharging", this.isCharging);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.inventory[0] = access.func_74764_b("inventory") ? ItemStack.func_77949_a((NBTTagCompound)access.func_74775_l("inventory")) : null;
        this.isCharging = access.func_74767_n("isCharging");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.func_70301_a(0) != null && this.isCharging) {
                this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), (Math.random() - 0.5) / 12.0, 0.0, (Math.random() - 0.5) / 12.0);
            }
        } else if (this.func_70301_a(0) != null) {
            if (this.func_70301_a(0).func_77973_b() == SteamcraftItems.steamcellEmpty && this.getSteamShare() > Config.steamCellCapacity) {
                this.inventory[0] = null;
                this.dropItem(new ItemStack(SteamcraftItems.steamcellFull));
                this.decrSteam(Config.steamCellCapacity);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!this.hadItem) {
                this.hadItem = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.func_70301_a(0).func_77973_b() instanceof ISteamChargable) {
                ISteamChargable item = (ISteamChargable)this.func_70301_a(0).func_77973_b();
                ItemStack stack = this.func_70301_a(0).func_77946_l();
                if (!(item instanceof ItemExosuitArmor)) {
                    if (this.getSteamShare() > 0 && stack.func_77960_j() > 0) {
                        if (!this.isCharging) {
                            this.isCharging = true;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (this.isCharging) {
                        this.isCharging = false;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.getSteamShare() > item.steamPerDurability() && stack.func_77960_j() > 0) {
                        for (int i = 0; i < 4 && this.getSteamShare() > item.steamPerDurability() && stack.func_77960_j() > 0; ++i) {
                            this.decrSteam(item.steamPerDurability());
                            stack.func_77964_b(stack.func_77960_j() - 1);
                            this.func_70299_a(0, stack);
                        }
                        float currentPerc = this.getChargingPercent(stack);
                        if (this.prevPercent != currentPerc && (double)Math.abs(this.prevPercent - currentPerc) > 0.01) {
                            this.prevPercent = currentPerc;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                } else {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    if (!stack.field_77990_d.func_74764_b("steamFill")) {
                        stack.field_77990_d.func_74768_a("steamFill", 0);
                    }
                    if (!stack.field_77990_d.func_74764_b("maxFill")) {
                        stack.field_77990_d.func_74768_a("maxFill", 0);
                    }
                    if (this.getSteamShare() > 0 && stack.field_77990_d.func_74762_e("steamFill") < stack.field_77990_d.func_74762_e("maxFill")) {
                        if (!this.isCharging) {
                            this.isCharging = true;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (this.isCharging) {
                        this.isCharging = false;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.getSteamShare() > item.steamPerDurability() && stack.field_77990_d.func_74762_e("steamFill") < stack.field_77990_d.func_74762_e("maxFill")) {
                        for (int i = 0; i < 19 && this.getSteamShare() > item.steamPerDurability() && stack.field_77990_d.func_74762_e("steamFill") < stack.field_77990_d.func_74762_e("maxFill"); ++i) {
                            this.decrSteam(item.steamPerDurability());
                            stack.field_77990_d.func_74768_a("steamFill", stack.field_77990_d.func_74762_e("steamFill") + 1);
                            this.func_70299_a(0, stack);
                        }
                        float currentPerc = this.getChargingPercent(stack);
                        if (this.prevPercent != currentPerc && (double)Math.abs(this.prevPercent - currentPerc) > 0.01) {
                            this.prevPercent = currentPerc;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else if (CrossMod.TINKERS_CONSTRUCT && this.func_70301_a(0).func_77973_b() instanceof ToolCore) {
                ToolCore item = (ToolCore)this.func_70301_a(0).func_77973_b();
                ItemStack stack = this.func_70301_a(0).func_77946_l();
                NBTTagCompound tags = stack.func_77978_p();
                int damage = tags.func_74775_l("InfiTool").func_74762_e("Damage");
                if (!tags.func_74775_l("InfiTool").func_74767_n("Broken")) {
                    if (this.getSteamShare() > 0 && tags.func_74775_l("InfiTool").func_74762_e("Damage") > 0) {
                        if (!this.isCharging) {
                            this.isCharging = true;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else if (this.isCharging) {
                        this.isCharging = false;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.getSteamShare() > 8 && tags.func_74775_l("InfiTool").func_74762_e("Damage") > 0) {
                        for (int i = 0; i < 4 && this.getSteamShare() > 8 && tags.func_74775_l("InfiTool").func_74762_e("Damage") > 0; ++i) {
                            this.decrSteam(8);
                            tags.func_74775_l("InfiTool").func_74768_a("Damage", --damage);
                            this.func_70299_a(0, stack);
                        }
                        float currentPerc = (float)(tags.func_74775_l("InfiTool").func_74762_e("TotalDurability") - tags.func_74775_l("InfiTool").func_74762_e("Damage")) / (float)tags.func_74775_l("InfiTool").func_74762_e("TotalDurability");
                        if (this.prevPercent != currentPerc && (double)Math.abs(this.prevPercent - currentPerc) > 0.01) {
                            this.prevPercent = currentPerc;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else if (this.hadItem) {
                this.hadItem = false;
                this.prevPercent = 0.0f;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public void dropItem(ItemStack item) {
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.25f), (double)((float)this.field_145849_e + 0.5f), item);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.inventory[var1] != null) {
            if (this.inventory[var1].field_77994_a <= var2) {
                ItemStack itemstack = this.inventory[var1];
                this.inventory[var1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[var1].func_77979_a(var2);
            if (this.inventory[var1].field_77994_a == 0) {
                this.inventory[var1] = null;
            }
            return itemstack;
        }
        return null;
    }

    private float getChargingPercent(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemExosuitArmor) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.field_77990_d.func_74764_b("steamFill")) {
                stack.field_77990_d.func_74768_a("steamFill", 0);
            }
            if (!stack.field_77990_d.func_74764_b("maxFill")) {
                stack.field_77990_d.func_74768_a("maxFill", 0);
            }
            int maxFill = stack.field_77990_d.func_74762_e("maxFill");
            int steamFill = stack.field_77990_d.func_74762_e("steamFill");
            return (float)steamFill / (float)maxFill;
        }
        return 1.0f - (float)stack.func_77960_j() / (float)stack.func_77958_k();
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory[var1];
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory[var1] = var2;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var2.func_77973_b() instanceof ISteamChargable || var2.func_77973_b() == SteamcraftItems.steamcellEmpty;
    }

    public float getSteamInItem() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null) {
            return this.getChargingPercent(stack);
        }
        return 0.0f;
    }
}

