/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamHammer
extends SteamTransporterTileEntity
implements IInventory,
ISteamTransporter {
    public int hammerTicks = 0;
    public String itemName = "";
    public int cost = 0;
    public int progress = 0;
    private boolean isInitialized = false;
    private boolean isWorking = false;
    private boolean hadItem = false;
    private ItemStack[] inventory = new ItemStack[3];
    private int steamConsumption = Config.hammerConsumption;

    public TileEntitySteamHammer() {
        super(ForgeDirection.VALID_DIRECTIONS);
        this.addSidesToGaugeBlacklist(ForgeDirection.VALID_DIRECTIONS);
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = this.myDir();
        if (!this.isInitialized) {
            ForgeDirection[] dirs = new ForgeDirection[]{dir.getOpposite()};
            this.setDistributionDirections(dirs);
            this.isInitialized = true;
        }
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                if (this.cost > 0 && this.progress < this.cost && this.hammerTicks == 355) {
                    ++this.progress;
                }
                this.hammerTicks = (this.hammerTicks + 5) % 360;
                if (this.hammerTicks == 20) {
                    for (int i = 0; i < 5; ++i) {
                        Steamcraft.proxy.spawnBreakParticles(this.field_145850_b, (float)this.field_145851_c + 0.5f + 0.25f * (float)dir.offsetX, this.field_145848_d, (float)this.field_145849_e + 0.5f + 0.25f * (float)dir.offsetZ, Blocks.field_150467_bQ, (float)(Math.random() - 0.5) / 12.0f, 0.0f, (float)(Math.random() - 0.5) / 12.0f);
                    }
                }
            } else {
                this.hammerTicks = 0;
                this.progress = 0;
            }
        } else {
            if (this.func_70301_a(0) != null) {
                if (!this.hadItem) {
                    this.hadItem = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.hadItem) {
                this.hadItem = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.cost > 0 && this.progress < this.cost && this.hammerTicks == 355) {
                ++this.progress;
            }
            if (this.cost > 0 && this.progress < this.cost && this.func_70301_a(2) != null) {
                if (this.hammerTicks == 0) {
                    if (this.getSteamShare() >= this.steamConsumption) {
                        this.decrSteam(this.steamConsumption);
                        if (!this.isWorking) {
                            this.isWorking = true;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    } else {
                        if (this.isWorking) {
                            this.isWorking = false;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                }
                this.hammerTicks = (this.hammerTicks + 5) % 360;
                switch (this.hammerTicks) {
                    case 15: 
                    case 40: {
                        this.playHammerSound("random.anvil_land", Block.field_149788_p.func_150497_c(), (float)(0.75 + Math.random() * (double)0.1f));
                        break;
                    }
                    case 170: {
                        this.playHammerSound("steamcraft:hiss", Block.field_149788_p.func_150497_c(), 0.9f);
                        break;
                    }
                }
            } else {
                if (this.isWorking) {
                    this.isWorking = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.hammerTicks > 0) {
                    this.hammerTicks = 0;
                }
            }
        }
    }

    private void playHammerSound(String sound, float volume, float par3) {
        this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), sound, 0.2f, (float)(0.75 + Math.random() * (double)0.1f));
    }

    private ForgeDirection myDir() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        if (meta == 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (meta == 1) {
            dir = ForgeDirection.WEST;
        }
        if (meta == 2) {
            dir = ForgeDirection.NORTH;
        }
        if (meta == 3) {
            dir = ForgeDirection.EAST;
        }
        return dir;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.inventory[par1];
                this.inventory[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[par1].func_77979_a(par2);
            if (this.inventory[par1].field_77994_a == 0) {
                this.inventory[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74768_a("cost", this.cost);
        access.func_74768_a("progress", this.progress);
        access.func_74768_a("hammerTicks", this.hammerTicks);
        access.func_74757_a("isWorking", this.isWorking);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        this.cost = access.func_74762_e("cost");
        this.isWorking = access.func_74767_n("isWorking");
        this.progress = access.func_74762_e("progress");
        this.hammerTicks = access.func_74762_e("hammerTicks");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = (NBTTagList)par1NBTTagCompound.func_74781_a("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.cost = par1NBTTagCompound.func_74762_e("cost");
        this.progress = par1NBTTagCompound.func_74762_e("progress");
        this.hammerTicks = par1NBTTagCompound.func_74762_e("hammerTicks");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("cost", this.cost);
        par1NBTTagCompound.func_74768_a("progress", this.progress);
        par1NBTTagCompound.func_74768_a("hammerTicks", this.hammerTicks);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }
}

