/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.steamnet.SteamNetworkRegistry;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityValvePipe
extends TileEntitySteamPipe {
    public boolean open = true;
    public int turnTicks = 0;
    private boolean turning;
    private boolean wasTurning = false;
    private boolean redstoneState;
    private boolean waitingOpen = false;

    public TileEntityValvePipe() {
        super(0);
    }

    public void updateRedstoneState(boolean flag) {
        if (Config.enableRedstoneValvePipe && !this.isTurning()) {
            this.setOpen(flag);
        }
        this.redstoneState = flag;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound access = super.getDescriptionTag();
        access.func_74757_a("turning", this.turning);
        access.func_74757_a("open", this.open);
        access.func_74757_a("leaking", this.isLeaking);
        access.func_74768_a("turnTicks", this.turnTicks);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, access);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound access = pkt.func_148857_g();
        if (this.turnTicks == 0) {
            this.turnTicks = access.func_74762_e("turnTicks");
        }
        this.turning = access.func_74767_n("turning");
        this.isLeaking = access.func_74767_n("leaking");
        this.open = access.func_74767_n("open");
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.open = par1NBTTagCompound.func_74767_n("open");
        this.redstoneState = par1NBTTagCompound.func_74767_n("redstoneState");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("open", this.open);
        par1NBTTagCompound.func_74757_a("redstoneState", this.redstoneState);
    }

    public ForgeDirection dir() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return ForgeDirection.getOrientation((int)meta);
    }

    @Override
    public boolean doesConnect(ForgeDirection face) {
        return face != this.dir() && super.doesConnect(face);
    }

    @Override
    public void func_145845_h() {
        super.superUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.turning && this.turnTicks < 10) {
                ++this.turnTicks;
            }
            if (this.turnTicks >= 10) {
                this.turning = false;
                this.setOpen(!this.open);
                this.turnTicks = 0;
            }
            if (!this.turning) {
                this.turnTicks = 0;
            }
            if (this.isLeaking) {
                ForgeDirection myDir = this.dir();
                ForgeDirection[] directions = new ForgeDirection[6];
                int i = 0;
                for (ForgeDirection direction : ForgeDirection.values()) {
                    if (direction == myDir) continue;
                    directions[i] = direction;
                    ++i;
                }
                ArrayList<ForgeDirection> myDirections = new ArrayList<ForgeDirection>();
                for (ForgeDirection direction : directions) {
                    ISteamTransporter target;
                    if (this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) == null) continue;
                    TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                    if (tile instanceof ISteamTransporter) {
                        target = (ISteamTransporter)tile;
                        if (!target.doesConnect(direction.getOpposite())) continue;
                        myDirections.add(direction);
                        continue;
                    }
                    if (!(tile instanceof IFluidHandler) || !Steamcraft.steamRegistered || !(target = (IFluidHandler)tile).canDrain(direction.getOpposite(), FluidRegistry.getFluid((String)"steam")) && !target.canFill(direction.getOpposite(), FluidRegistry.getFluid((String)"steam"))) continue;
                    myDirections.add(direction);
                }
                if (myDirections.size() > 0) {
                    ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
                    for (i = 0; myDirections.size() == 2 && this.open && i < 10 && (this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) || !this.field_145850_b.isSideSolid(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction.getOpposite())); ++i) {
                        this.field_145850_b.func_72869_a("smoke", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), (double)((float)direction.offsetX * 0.1f), (double)((float)direction.offsetY * 0.1f), (double)((float)direction.offsetZ * 0.1f));
                    }
                }
            }
        } else {
            if (this.waitingOpen) {
                this.setOpen(!this.open);
            }
            if (this.turning != this.wasTurning) {
                this.wasTurning = this.turning;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.turning && this.turnTicks < 10) {
                ++this.turnTicks;
            }
            if (this.turnTicks >= 10) {
                this.turning = false;
                this.setOpen(!this.open);
                this.turnTicks = 0;
            }
            if (!this.turning) {
                if (this.wasTurning) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                this.turnTicks = 0;
            }
            ForgeDirection myDir = this.dir();
            ForgeDirection directions = new ForgeDirection[6];
            int i = 0;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (direction == myDir) continue;
                directions[i] = direction;
                ++i;
            }
            ArrayList myDirections = new ArrayList();
            for (ForgeDirection direction : directions) {
                ISteamTransporter target;
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (tile == null) continue;
                if (tile instanceof ISteamTransporter) {
                    target = (ISteamTransporter)tile;
                    if (!target.doesConnect(direction.getOpposite())) continue;
                    myDirections.add(direction);
                    continue;
                }
                if (!(tile instanceof IFluidHandler) || !Steamcraft.steamRegistered || !(target = (IFluidHandler)tile).canDrain(direction.getOpposite(), FluidRegistry.getFluid((String)"steam")) && !target.canFill(direction.getOpposite(), FluidRegistry.getFluid((String)"steam"))) continue;
                myDirections.add(direction);
            }
            if (myDirections.size() > 0) {
                ForgeDirection direction = ((ForgeDirection)myDirections.get(0)).getOpposite();
                while (!this.doesConnect(direction)) {
                    direction = ForgeDirection.getOrientation((int)((direction.flag + 1) % 5));
                }
                if (myDirections.size() == 2 && this.open && this.getNetwork() != null && this.getNetwork().getSteam() > 0 && (this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ) || !this.field_145850_b.isSideSolid(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction.getOpposite()))) {
                    if (!this.isLeaking) {
                        this.isLeaking = true;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.decrSteam(100);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "steamcraft:leaking", 2.0f, 0.9f);
                } else if (this.isLeaking) {
                    this.isLeaking = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.isLeaking) {
                this.isLeaking = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public boolean canInsert(ForgeDirection face) {
        return face != this.dir() && this.open;
    }

    @Override
    public boolean acceptsGauge(ForgeDirection face) {
        return face != this.dir().getOpposite();
    }

    public boolean isTurning() {
        return this.turning;
    }

    public void setTurning() {
        this.turning = true;
        this.turnTicks = 0;
    }

    public boolean isOpen() {
        return this.open;
    }

    private void setOpen(boolean open) {
        this.open = open;
        boolean changed = true;
        if (!this.field_145850_b.field_72995_K) {
            if (open) {
                if (SteamNetworkRegistry.getInstance().isInitialized(this.getDimension())) {
                    SteamNetwork.newOrJoin(this);
                } else {
                    changed = false;
                    this.waitingOpen = true;
                }
            } else if (this.getNetwork() != null) {
                this.getNetwork().split(this, true);
            } else {
                changed = false;
                this.waitingOpen = true;
            }
        }
        if (!changed) {
            this.open = !open;
        } else {
            this.waitingOpen = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        return false;
    }
}

