/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.world;

import cpw.mods.fml.common.IWorldGenerator;
import flaxbeard.steamcraft.data.AetherBlockData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class SteamcraftIslandGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    private void generateSurface(World world, Random random, int i, int j) {
        if (random.nextInt(10) == 0) {
            int minY = 255;
            int maxY = 0;
            for (int x = 0; x < 16; ++x) {
                block1: for (int z = 0; z < 16; ++z) {
                    for (int y = 255; y > 0; --y) {
                        if (world.func_147439_a(i + x, y, j + z).func_149688_o() == Material.field_151579_a || world.func_147439_a(i + x, y, j + z).isFoliage((IBlockAccess)world, i + x, y, j + z)) continue;
                        if (y < minY) {
                            minY = y;
                        }
                        if (y <= maxY) continue block1;
                        maxY = y;
                        continue block1;
                    }
                }
            }
            if (maxY - minY <= 14) {
                int offset = Math.max(20, 255 - maxY - (maxY - minY) - random.nextInt(125));
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int xOffset = 8 - Math.max(Math.abs(8 - x), Math.abs(7 - x));
                        int zOffset = 8 - Math.max(Math.abs(8 - z), Math.abs(7 - z));
                        int bottomOffset = Math.min(6, (int)((float)(xOffset + zOffset) / 1.5f)) - 2;
                        if (xOffset + zOffset <= 4) continue;
                        for (int y = 255; y > minY - bottomOffset; --y) {
                            if (world.func_147439_a(i + x, y, j + z).func_149688_o() == Material.field_151579_a || world.func_147439_a(i + x, y, j + z).func_149688_o() == Material.field_151586_h) continue;
                            Block block = world.func_147439_a(i + x, y, j + z);
                            int meta = world.func_72805_g(i + x, y, j + z);
                            world.func_147468_f(i + x, y, j + z);
                            if (y == minY - bottomOffset + 1 && world.func_147439_a(i + x, y - 1, j + z) == Blocks.field_150346_d) {
                                world.func_147449_b(i + x, y - 1, j + z, (Block)Blocks.field_150349_c);
                            }
                            world.func_147465_d(i + x, y + offset, j + z, block, meta, 2);
                            AetherBlockData.get(world).addCoord(new ChunkCoordinates(i + x, y + offset, j + z));
                        }
                    }
                }
            }
        }
    }

    private void generateNether(World world, Random random, int i, int j) {
    }
}

