/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityFallenMount;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.SpawnUtil;
import crazypants.enderzoo.entity.ai.EntityAIMountedArrowAttack;
import crazypants.enderzoo.entity.ai.EntityAIMountedAttackOnCollide;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityFallenKnight
extends EntitySkeleton
implements IEnderZooMob {
    public static final int EGG_FG_COL = 3562021;
    public static final int EGG_BG_COL = 0xA0A0A0;
    public static String NAME = "enderzoo.FallenKnight";
    private static final double ATTACK_MOVE_SPEED = Config.fallenKnightChargeSpeed;
    private EntityAIMountedArrowAttack aiArrowAttack;
    private EntityAIMountedAttackOnCollide aiAttackOnCollide;
    private final EntityAIBreakDoor breakDoorAI = new EntityAIBreakDoor((EntityLiving)this);
    private boolean canBreakDoors = false;
    private EntityLivingBase lastAttackTarget = null;
    private boolean firstUpdate = true;
    private boolean isMounted = false;
    private boolean spawned = false;

    public EntityFallenKnight(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(Config.fallenKnightFollowRange);
        MobInfo.FALLEN_KNIGHT.applyAttributes((EntityLivingBase)this);
    }

    protected void func_70785_a(Entity target, float distance) {
        if (this.field_70724_aR <= 0 && distance < this.getAttackRange() && target.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && target.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(target);
        }
    }

    private float getAttackRange() {
        if (this.func_70115_ae()) {
            return 3.0f;
        }
        return 2.0f;
    }

    public void func_85036_m() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiAttackOnCollide());
        this.field_70714_bg.func_85156_a((EntityAIBase)this.getAiArrowAttack());
        if (this.isRanged()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiArrowAttack());
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.getAiAttackOnCollide());
        }
    }

    public EntityAIMountedArrowAttack getAiArrowAttack() {
        if (this.aiArrowAttack == null) {
            this.aiArrowAttack = new EntityAIMountedArrowAttack((IRangedAttackMob)this, ATTACK_MOVE_SPEED, EntityFallenMount.MOUNTED_ATTACK_MOVE_SPEED, Config.fallenKnightRangedMinAttackPause, Config.fallenKnightRangedMaxAttackPause, Config.fallenKnightRangedMaxRange, Config.fallKnightMountedArchesMaintainDistance);
        }
        return this.aiArrowAttack;
    }

    public EntityAIMountedAttackOnCollide getAiAttackOnCollide() {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIMountedAttackOnCollide((EntityCreature)this, EntityPlayer.class, ATTACK_MOVE_SPEED, EntityFallenMount.MOUNTED_ATTACK_MOVE_SPEED, false);
        }
        return this.aiAttackOnCollide;
    }

    protected String func_70639_aQ() {
        return "mob.zombie.say";
    }

    protected String func_70621_aR() {
        return "mob.zombie.hurt";
    }

    protected String func_70673_aS() {
        return "mob.zombie.death";
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.firstUpdate && !this.field_70170_p.field_72995_K) {
            this.spawnMount();
        }
        if (this.isRidingMount()) {
            EntityLiving entLiving = (EntityLiving)this.field_70154_o;
            if (this.lastAttackTarget != this.func_70638_az() || this.firstUpdate) {
                EntityUtil.cancelCurrentTasks(entLiving);
                this.lastAttackTarget = this.func_70638_az();
            }
        }
        this.firstUpdate = false;
        if (!this.isMounted == this.isRidingMount()) {
            this.getAiAttackOnCollide().func_75251_c();
            this.getAiArrowAttack().func_75251_c();
            this.func_70661_as().func_75499_g();
            this.isMounted = this.isRidingMount();
        }
        if (this.func_70027_ad() && this.isRidingMount()) {
            this.field_70154_o.func_70015_d(8);
        }
        if (Config.fallenKnightArchersSwitchToMelee && (!this.isMounted || !Config.fallKnightMountedArchesMaintainDistance) && this.func_70638_az() != null && this.isRanged() && this.func_70068_e((Entity)this.func_70638_az()) < 5.0) {
            this.func_70062_b(0, this.getSwordForLevel(this.getRandomEquipmentLevel()));
        }
    }

    private boolean isRidingMount() {
        return this.func_70115_ae() && this.field_70154_o.getClass() == EntityFallenMount.class;
    }

    protected void func_70623_bb() {
        Entity mount = this.field_70154_o;
        super.func_70623_bb();
        if (this.field_70128_L && mount != null) {
            mount.func_70106_y();
        }
    }

    private void spawnMount() {
        if (this.field_70154_o != null || !this.spawned) {
            return;
        }
        EntityFallenMount mount = null;
        if (Config.fallenMountEnabled && this.field_70146_Z.nextFloat() <= Config.fallenKnightChanceMounted) {
            mount = new EntityFallenMount(this.field_70170_p);
            mount.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            mount.func_110161_a(null);
            if (!SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityCreature)mount, false)) {
                mount = null;
            }
        }
        if (mount != null) {
            this.func_98053_h(false);
            this.setCanBreakDoors(false);
            this.field_70170_p.func_72838_d((Entity)mount);
            this.func_70078_a((Entity)mount);
        }
    }

    private boolean isRanged() {
        ItemStack itemstack = this.func_70694_bm();
        return itemstack != null && itemstack.func_77973_b() == Items.field_151031_f;
    }

    protected void func_82164_bB() {
        float occupiedDiffcultyMultiplier = EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        int equipmentLevel = this.getRandomEquipmentLevel(occupiedDiffcultyMultiplier);
        int armorLevel = equipmentLevel;
        if (armorLevel == 1) {
            ++armorLevel;
        }
        float chancePerPiece = this.isHardDifficulty() ? Config.fallenKnightChancePerArmorPieceHard : Config.fallenKnightChancePerArmorPiece;
        chancePerPiece *= 1.0f + occupiedDiffcultyMultiplier;
        for (int slot = 1; slot < 5; ++slot) {
            Item item;
            ItemStack itemStack = this.func_71124_b(slot);
            if (itemStack != null || !(this.field_70146_Z.nextFloat() <= chancePerPiece) || (item = EntityLiving.func_82161_a((int)slot, (int)armorLevel)) == null) continue;
            ItemStack stack = new ItemStack(item);
            if (armorLevel == 0) {
                ((ItemArmor)item).func_82813_b(stack, 0);
            }
            this.func_70062_b(slot, stack);
        }
        if (this.field_70146_Z.nextFloat() > Config.fallenKnightRangedRatio) {
            this.func_70062_b(0, this.getSwordForLevel(equipmentLevel));
        } else {
            this.func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
        }
    }

    private int getRandomEquipmentLevel() {
        return this.getRandomEquipmentLevel(EntityUtil.getDifficultyMultiplierForLocation(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }

    private int getRandomEquipmentLevel(float occupiedDiffcultyMultiplier) {
        float chanceImprovedArmor = this.isHardDifficulty() ? Config.fallenKnightChanceArmorUpgradeHard : Config.fallenKnightChanceArmorUpgrade;
        chanceImprovedArmor *= 1.0f + occupiedDiffcultyMultiplier;
        int armorLevel = this.field_70146_Z.nextInt(2);
        for (int i = 0; i < 2; ++i) {
            if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
            ++armorLevel;
        }
        return armorLevel;
    }

    protected boolean isHardDifficulty() {
        return EntityUtil.isHardDifficulty(this.field_70170_p);
    }

    private ItemStack getSwordForLevel(int swordLevel) {
        if (swordLevel < 2) {
            swordLevel += this.field_70146_Z.nextInt(this.isHardDifficulty() ? 3 : 2);
            swordLevel = Math.min(swordLevel, 2);
        }
        switch (swordLevel) {
            case 0: {
                return new ItemStack(Items.field_151041_m);
            }
            case 1: {
                return new ItemStack(Items.field_151052_q);
            }
            case 2: {
                return new ItemStack(Items.field_151040_l);
            }
            case 4: {
                return new ItemStack(Items.field_151048_u);
            }
        }
        return new ItemStack(Items.field_151040_l);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData livingData) {
        this.spawned = true;
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        this.func_82201_a(0);
        this.func_82164_bB();
        this.func_82162_bC();
        float f = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        this.setCanBreakDoors(this.field_70146_Z.nextFloat() < f * 0.1f);
        return livingData;
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        root.func_74757_a("canBreakDoors", this.canBreakDoors);
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        this.setCanBreakDoors(root.func_74767_n("canBreakDoors"));
    }

    private void setCanBreakDoors(boolean val) {
        if (this.canBreakDoors != val) {
            this.canBreakDoors = val;
            if (this.canBreakDoors) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.breakDoorAI);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.breakDoorAI);
            }
        }
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
        int numDrops = this.field_70146_Z.nextInt(3 + lootingLevel);
        for (int i = 0; i < numDrops; ++i) {
            if (this.field_70146_Z.nextBoolean()) {
                this.func_145779_a(Items.field_151103_aS, 1);
                continue;
            }
            this.func_145779_a(Items.field_151078_bh, 1);
        }
    }

    protected void func_70600_l(int p_70600_1_) {
    }
}

