/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.inventory.ContainerTerraformer;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityTerraformer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IBubbleProvider,
IFluidHandler {
    private final int tankCapacity = 2000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    public boolean active;
    public boolean lastActive;
    public static final int WATTS_PER_TICK = 1;
    private ItemStack[] containingItems = new ItemStack[14];
    private ArrayList<BlockVec3> terraformableBlocksList = new ArrayList();
    private ArrayList<BlockVec3> grassBlockList = new ArrayList();
    private ArrayList<BlockVec3> grownTreesList = new ArrayList();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int terraformableBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int grassBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean treesDisabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean grassDisabled;
    public final double MAX_SIZE = 15.0;
    private int[] useCount = new int[2];
    private int saplingIndex = 6;
    public float bubbleSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityTerraformer() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
    }

    public int getScaledWaterLevel(int i) {
        double fuelLevel = this.waterTank.getFluid() == null ? 0.0 : (double)this.waterTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public double getDistanceFromServer(double par1, double par3, double par5) {
        double d3 = (double)this.field_145851_c + 0.5 - par1;
        double d4 = (double)this.field_145848_d + 0.5 - par3;
        double d5 = (double)this.field_145849_e + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[0] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0])) != null && liquid.getFluid().getName().equals(FluidRegistry.WATER.getName()) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(liquid, true);
                this.containingItems[0] = FluidUtil.getUsedContainer((ItemStack)this.containingItems[0]);
            }
            boolean bl = this.active = (double)this.bubbleSize == this.MAX_SIZE && this.hasEnoughEnergyToRun && this.getFirstBonemealStack() != null && this.waterTank.getFluid() != null && this.waterTank.getFluid().amount > 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.active == this.lastActive && this.ticks % 60 != 0)) {
            this.terraformableBlocksList.clear();
            this.grassBlockList.clear();
            if (this.active) {
                int bubbleSize = (int)Math.ceil(this.bubbleSize);
                double bubbleSizeSq = this.bubbleSize;
                bubbleSizeSq *= bubbleSizeSq;
                boolean doGrass = !this.grassDisabled && this.getFirstSeedStack() != null;
                boolean doTrees = !this.treesDisabled && this.getFirstSaplingStack() != null;
                for (int x = this.field_145851_c - bubbleSize; x < this.field_145851_c + bubbleSize; ++x) {
                    for (int y = this.field_145848_d - bubbleSize; y < this.field_145848_d + bubbleSize; ++y) {
                        for (int z = this.field_145849_e - bubbleSize; z < this.field_145849_e + bubbleSize; ++z) {
                            Block blockID = this.field_145850_b.func_147439_a(x, y, z);
                            if (blockID == null || blockID.isAir((IBlockAccess)this.field_145850_b, x, y, z) || !(this.getDistanceFromServer(x, y, z) < bubbleSizeSq)) continue;
                            if (doGrass && blockID instanceof ITerraformableBlock && ((ITerraformableBlock)blockID).isTerraformable(this.field_145850_b, x, y, z)) {
                                this.terraformableBlocksList.add(new BlockVec3(x, y, z));
                                continue;
                            }
                            if (!doTrees) continue;
                            Block blockIDAbove = this.field_145850_b.func_147439_a(x, y + 1, z);
                            if (blockID != Blocks.field_150349_c || blockIDAbove != null && !blockIDAbove.isAir((IBlockAccess)this.field_145850_b, x, y + 1, z)) continue;
                            this.grassBlockList.add(new BlockVec3(x, y, z));
                        }
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.terraformableBlocksList.size() > 0 && this.ticks % 15 == 0) {
            ArrayList<BlockVec3> terraformableBlocks2 = new ArrayList<BlockVec3>(this.terraformableBlocksList);
            int randomIndex = this.field_145850_b.field_73012_v.nextInt(this.terraformableBlocksList.size());
            BlockVec3 vec = terraformableBlocks2.get(randomIndex);
            if (vec.getBlock((IBlockAccess)this.field_145850_b) instanceof ITerraformableBlock) {
                BlockGrass id;
                switch (this.field_145850_b.field_73012_v.nextInt(40)) {
                    case 0: {
                        if (this.field_145850_b.func_147469_q(vec.x - 1, vec.y, vec.z) && this.field_145850_b.func_147469_q(vec.x + 1, vec.y, vec.z) && this.field_145850_b.func_147469_q(vec.x, vec.y, vec.z - 1) && this.field_145850_b.func_147469_q(vec.x, vec.y, vec.z + 1)) {
                            id = Blocks.field_150358_i;
                            break;
                        }
                        id = Blocks.field_150349_c;
                        break;
                    }
                    default: {
                        id = Blocks.field_150349_c;
                    }
                }
                this.field_145850_b.func_147449_b(vec.x, vec.y, vec.z, (Block)id);
                if (id == Blocks.field_150349_c) {
                    this.useCount[0] = this.useCount[0] + 1;
                    this.waterTank.drain(1, true);
                    this.checkUsage(1);
                } else if (id == Blocks.field_150358_i) {
                    this.checkUsage(2);
                }
            }
            this.terraformableBlocksList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K && !this.treesDisabled && this.grassBlockList.size() > 0 && this.ticks % 50 == 0) {
            int randomIndex = this.field_145850_b.field_73012_v.nextInt(this.grassBlockList.size());
            BlockVec3 vecGrass = this.grassBlockList.get(randomIndex);
            if (vecGrass.getBlock((IBlockAccess)this.field_145850_b) == Blocks.field_150349_c) {
                BlockVec3 vecSapling = vecGrass.translate(0, 1, 0);
                ItemStack sapling = this.getFirstSaplingStack();
                boolean flag = false;
                for (BlockVec3 testVec : this.grownTreesList) {
                    if (testVec.distanceSquared(vecSapling) >= 9) continue;
                    flag = true;
                    break;
                }
                if (!flag && sapling != null) {
                    Block b = Block.func_149634_a((Item)sapling.func_77973_b());
                    this.field_145850_b.func_147465_d(vecSapling.x, vecSapling.y, vecSapling.z, b, sapling.func_77960_j(), 3);
                    if (b instanceof BlockSapling) {
                        if (this.field_145850_b.func_72957_l(vecSapling.x, vecSapling.y, vecSapling.z) >= 9) {
                            ((BlockSapling)b).func_149878_d(this.field_145850_b, vecSapling.x, vecSapling.y, vecSapling.z, this.field_145850_b.field_73012_v);
                            this.grownTreesList.add(vecSapling.clone());
                        }
                    } else if (b instanceof BlockBush && this.field_145850_b.func_72957_l(vecSapling.x, vecSapling.y, vecSapling.z) >= 5) {
                        for (int j = 0; j < 12; ++j) {
                            if (this.field_145850_b.func_147439_a(vecSapling.x, vecSapling.y, vecSapling.z) != b) {
                                this.grownTreesList.add(vecSapling.clone());
                                break;
                            }
                            ((BlockBush)b).func_149674_a(this.field_145850_b, vecSapling.x, vecSapling.y, vecSapling.z, this.field_145850_b.field_73012_v);
                        }
                    }
                    this.useCount[1] = this.useCount[1] + 1;
                    this.waterTank.drain(50, true);
                    this.checkUsage(0);
                }
            }
            this.grassBlockList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.terraformableBlocksListSize = this.terraformableBlocksList.size();
            this.grassBlocksListSize = this.grassBlockList.size();
        }
        this.bubbleSize = this.hasEnoughEnergyToRun && (!this.grassDisabled || !this.treesDisabled) ? (float)Math.min((double)Math.max(0.0f, this.bubbleSize + 0.1f), this.MAX_SIZE) : (float)Math.min((double)Math.max(0.0f, this.bubbleSize - 0.1f), this.MAX_SIZE);
        this.lastActive = this.active;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            this.bubbleSize = dataStream.readFloat();
        }
    }

    private void checkUsage(int type) {
        ItemStack stack = null;
        if ((this.useCount[0] + this.useCount[1]) % 4 == 0 && (stack = this.getFirstBonemealStack()) != null) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.containingItems[this.getSelectiveStack((int)2, (int)6)] = null;
            }
        }
        switch (type) {
            case 0: {
                stack = this.containingItems[this.saplingIndex];
                if (stack == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.saplingIndex] = null;
                break;
            }
            case 1: {
                if (this.useCount[0] % 4 != 0 || (stack = this.getFirstSeedStack()) == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.getSelectiveStack((int)10, (int)14)] = null;
                break;
            }
            case 2: {
                this.waterTank.drain(50, true);
            }
        }
    }

    private int getSelectiveStack(int start, int end) {
        for (int i = start; i < end; ++i) {
            ItemStack stack = this.containingItems[i];
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    private int getRandomStack(int start, int end) {
        int stackcount = 0;
        for (int i = start; i < end; ++i) {
            if (this.containingItems[i] == null) continue;
            ++stackcount;
        }
        if (stackcount == 0) {
            return -1;
        }
        int random = this.field_145850_b.field_73012_v.nextInt(stackcount);
        for (int i = start; i < end; ++i) {
            if (this.containingItems[i] == null) continue;
            if (random == 0) {
                return i;
            }
            --random;
        }
        return -1;
    }

    public ItemStack getFirstBonemealStack() {
        int index = this.getSelectiveStack(2, 6);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSaplingStack() {
        int index = this.getRandomStack(6, 10);
        if (index != -1) {
            this.saplingIndex = index;
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSeedStack() {
        int index = this.getSelectiveStack(10, 14);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        this.bubbleSize = nbt.func_74760_g("BubbleSize");
        this.useCount = nbt.func_74759_k("UseCountArray");
        if (this.useCount.length == 0) {
            this.useCount = new int[2];
        }
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
        if (nbt.func_74764_b("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeStandardItemsToNBT(nbt);
        nbt.func_74776_a("BubbleSize", this.bubbleSize);
        nbt.func_74783_a("UseCountArray", this.useCount);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
    }

    public ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"container.tileTerraformer.name");
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 1) {
            return ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return FluidContainerRegistry.containsFluid((ItemStack)itemstack, (FluidStack)new FluidStack(FluidRegistry.WATER, 1));
            }
            case 1: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77960_j() == 15;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ContainerTerraformer.isOnSaplingList(itemstack);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return itemstack.func_77973_b() == Items.field_151014_N;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return !this.grassDisabled || !this.treesDisabled;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown <= 0) {
            switch (index) {
                case 0: {
                    this.treesDisabled = !this.treesDisabled;
                    break;
                }
                case 1: {
                    this.grassDisabled = !this.grassDisabled;
                }
            }
            this.disableCooldown = 10;
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.treesDisabled;
            }
            case 1: {
                return this.grassDisabled;
            }
        }
        return false;
    }

    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    public double getPacketRange() {
        return 64.0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && "water".equals(fluid.getName());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - this.bubbleSize), (double)((float)this.field_145848_d - this.bubbleSize), (double)((float)this.field_145849_e - this.bubbleSize), (double)((float)this.field_145851_c + this.bubbleSize), (double)((float)this.field_145848_d + this.bubbleSize), (double)((float)this.field_145849_e + this.bubbleSize));
    }

    public float getBubbleSize() {
        return this.bubbleSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }
}

