/*
 * Decompiled with CFR 0.152.
 */
package minechem;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import minechem.MinechemBlocksGeneration;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.fluid.FluidHelper;
import minechem.item.blueprint.ItemBlueprint;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.item.chemistjournal.ChemistJournalRecipeCloning;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.oredictionary.OreDictionaryAppliedEnergisticsHandler;
import minechem.oredictionary.OreDictionaryDefaultHandler;
import minechem.oredictionary.OreDictionaryGregTechHandler;
import minechem.oredictionary.OreDictionaryHandler;
import minechem.oredictionary.OreDictionaryIC2Handler;
import minechem.oredictionary.OreDictionaryMekanismHandler;
import minechem.oredictionary.OreDictionaryUndergroundBiomesHandler;
import minechem.oredictionary.OreEventHandler;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerFluidRecipe;
import minechem.tileentity.decomposer.DecomposerFluidRecipeSelect;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import minechem.tileentity.decomposer.DecomposerRecipeSelect;
import minechem.tileentity.decomposer.DecomposerRecipeSuper;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.utils.Compare;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MinechemRecipes {
    private static final MinechemRecipes recipes = new MinechemRecipes();
    public ArrayList decomposition = new ArrayList();
    public ArrayList synthesis = new ArrayList();
    public static int BLOCK_MULTIPLIER = 8;
    public static int COST_INGOT = 300;
    public static int COST_BLOCK = 15;
    public static int COST_ITEM = 10;
    public static int COST_METALBLOCK = COST_INGOT * BLOCK_MULTIPLIER;
    public static int COST_PLANK = 20;
    public static int COST_LAPIS = 20;
    public static int COST_LAPISBLOCK = COST_LAPIS * BLOCK_MULTIPLIER;
    public static int COST_GRASS = 40;
    public static int COST_SMOOTH = 30;
    public static int COST_STAR = 6000;
    public static int COST_SUGAR = 30;
    public static int COST_GLOW = 70;
    public static int COST_GLOWBLOCK = COST_GLOW * 4;
    public static int COST_TEAR = 3000;
    public static int COST_OBSIDIAN = 100;
    public static int COST_PLANT = 200;
    public static int COST_FOOD = 250;
    public static int COST_WOOD = COST_PLANK * 4;
    public static int COST_GLASS = 300;
    public static int COST_PANE = COST_GLASS / 3;
    public static int COST_WOOL = 200;
    public static int COST_CARPET = COST_WOOL / 2;
    public static int COST_GEM = 1000;
    public static int COST_GEMBLOCK = COST_GEM * BLOCK_MULTIPLIER;
    private static final int INGOT_AMOUNT = 144;
    private static final int BUCKET_AMOUNT = 1000;
    private ArrayList<OreDictionaryHandler> oreDictionaryHandlers;

    public static MinechemRecipes getInstance() {
        return recipes;
    }

    public void registerFluidRecipes() {
        int threeQuarterFluidPerIngot = 180;
        DecomposerRecipe.add(new DecomposerFluidRecipe(new FluidStack(FluidRegistry.WATER, 1000), this.element(ElementEnum.H, 2), this.element(ElementEnum.O)));
        DecomposerRecipe.add(new DecomposerFluidRecipeSelect("lava", 250, 0.2f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Na), this.element(ElementEnum.Cl))));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("water", 1000, this.element(ElementEnum.H, 2), this.element(ElementEnum.O));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("iron.molten", 144, this.element(ElementEnum.Fe, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("gold.molten", 144, this.element(ElementEnum.Au, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("copper.molten", 144, this.element(ElementEnum.Cu, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("tin.molten", 144, this.element(ElementEnum.Sn, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("aluminum.molten", 144, this.element(ElementEnum.Al, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("cobalt.molten", 144, this.element(ElementEnum.Co, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("ardite.molten", 144, this.element(ElementEnum.Fe, 2), this.element(ElementEnum.W, 2), this.element(ElementEnum.Si, 2));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("bronze.molten", 144, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Sn, 4));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("aluminumbrass.molten", 144, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Al, 4));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("manyullyn.molten", 144, this.element(ElementEnum.Co, 8), this.element(ElementEnum.Fe, 1), this.element(ElementEnum.W, 1), this.element(ElementEnum.Si, 1));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("alumite.molten", 144, this.element(ElementEnum.Al, 8), this.element(ElementEnum.Fe, 3), this.molecule(MoleculeEnum.siliconDioxide, 2), this.molecule(MoleculeEnum.magnesiumOxide, 1));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("obsidian.molten", 144, this.molecule(MoleculeEnum.siliconDioxide, 16), this.molecule(MoleculeEnum.magnesiumOxide, 8));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("steel.molten", 144, this.element(ElementEnum.Fe, 14), this.element(ElementEnum.C, 2));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("stone.seared", 144, this.molecule(MoleculeEnum.siliconOxide, 12), this.molecule(MoleculeEnum.ironOxide, 4));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("glass.molten", 144, this.molecule(MoleculeEnum.siliconDioxide, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("emerald.molten", 144, this.molecule(MoleculeEnum.beryl, 6), this.element(ElementEnum.Cr, 6), this.element(ElementEnum.V, 6));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("blood.molten", 144, this.element(ElementEnum.O, 6), this.element(ElementEnum.Fe, 2), this.molecule(MoleculeEnum.ironOxide, 8));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("nickel.molten", 144, this.element(ElementEnum.Ni, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("lead.molten", 144, this.element(ElementEnum.Pb, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("silver.molten", 144, this.element(ElementEnum.Ag, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("platinum.molten", 144, this.element(ElementEnum.Pt, 16));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("invar.molten", 144, this.element(ElementEnum.Fe, 10), this.element(ElementEnum.Ni, 6));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("electrum.molten", 144, this.element(ElementEnum.Ag, 8), this.element(ElementEnum.Au, 8));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("ender", threeQuarterFluidPerIngot, this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate));
        this.registerMFRFluidRecipes();
        if (Settings.decomposeChemicalFluids) {
            for (ElementEnum element : FluidHelper.elements.keySet()) {
                DecomposerFluidRecipe.add(new DecomposerFluidRecipe(new FluidStack((Fluid)FluidHelper.elements.get(element), 125), new Element(element, 1)));
            }
            for (MoleculeEnum molecule : FluidHelper.molecules.keySet()) {
                DecomposerFluidRecipe.add(new DecomposerFluidRecipe(new FluidStack((Fluid)FluidHelper.molecules.get(molecule), 125), molecule.componentsArray()));
            }
        }
    }

    private void registerMFRFluidRecipes() {
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("mushroomsoup", 1000, this.molecule(MoleculeEnum.water, 4), this.molecule(MoleculeEnum.pantherine, 2));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("chocolatemilk", 1000, this.element(ElementEnum.Ca, 4), this.molecule(MoleculeEnum.theobromine, 1));
        DecomposerFluidRecipe.createAndAddFluidRecipeSafely("milk", 1000, this.element(ElementEnum.Ca, 4), this.molecule(MoleculeEnum.oleicAcid, 1));
    }

    /*
     * Opcode count of 14578 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void registerVanillaChemicalRecipes() {
        Molecule moleculeSiliconDioxide = this.molecule(MoleculeEnum.siliconDioxide, 4);
        Molecule moleculeCellulose = this.molecule(MoleculeEnum.cellulose, 1);
        Molecule moleculePolyvinylChloride = this.molecule(MoleculeEnum.polyvinylChloride);
        Molecule moleculeLazurite = this.molecule(MoleculeEnum.lazurite, 9);
        Element elementHydrogen = this.element(ElementEnum.H, 64);
        Element elementHelium = this.element(ElementEnum.He, 64);
        Element elementCarbon = this.element(ElementEnum.C, 64);
        ItemStack blockStone = new ItemStack(Blocks.field_150348_b);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockStone, 0.2f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Al), this.element(ElementEnum.O))));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150348_b, 16), true, COST_SMOOTH, this.element(ElementEnum.Si), this.element(ElementEnum.O, 2), null, this.element(ElementEnum.Al, 2), this.element(ElementEnum.O, 3), null));
        ItemStack blockGrass = new ItemStack((Block)Blocks.field_150349_c, 1, 0);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockGrass, 0.07f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ga), this.element(ElementEnum.As)), new DecomposerRecipe(moleculeCellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack((Block)Blocks.field_150349_c, 16), true, COST_GRASS, null, moleculeCellulose, null, null, this.element(ElementEnum.O, 2), this.element(ElementEnum.Si)));
        ItemStack blockDirt = new ItemStack(Blocks.field_150346_d, 1, 0);
        ItemStack blockPodzol = new ItemStack(Blocks.field_150346_d, 1, 2);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockDirt, 0.07f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ga), this.element(ElementEnum.As))));
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockPodzol, 0.07f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ga), this.element(ElementEnum.As))));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150346_d, 1, 0), true, COST_BLOCK, this.molecule(MoleculeEnum.siliconDioxide), null, null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150346_d, 1, 2), true, COST_BLOCK, null, null, null, this.molecule(MoleculeEnum.siliconDioxide), null, null, null, null, null));
        ItemStack blockCobblestone = new ItemStack(Blocks.field_150347_e);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockCobblestone, 0.1f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Na), this.element(ElementEnum.Cl))));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150347_e, 16), true, COST_SMOOTH, this.element(ElementEnum.Si, 2), this.element(ElementEnum.O, 4), null));
        ItemStack blockOakWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 0);
        ItemStack blockSpruceWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 1);
        ItemStack blockBirchWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 2);
        ItemStack blockJungleWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 3);
        ItemStack blockAcaciaWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 4);
        ItemStack blockDarkOakWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 5);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOakWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSpruceWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBirchWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockJungleWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAcaciaWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockDarkOakWoodPlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOakWoodPlanks, true, COST_PLANK, null, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSpruceWoodPlanks, true, COST_PLANK, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null));
        SynthesisRecipe.add(new SynthesisRecipe(blockBirchWoodPlanks, true, COST_PLANK, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockJungleWoodPlanks, true, COST_PLANK, null, null, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockAcaciaWoodPlanks, true, COST_PLANK, null, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockDarkOakWoodPlanks, true, COST_PLANK, null, null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, null, null, null, null));
        ItemStack blockOakWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 0);
        ItemStack blockSpruceWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 1);
        ItemStack blockBirchWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 2);
        ItemStack blockJungleWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 3);
        ItemStack blockAcaciaWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 4);
        ItemStack blockDarkOakWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 5);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOakWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSpruceWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBirchWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockJungleWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAcaciaWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockDarkOakWoodSlabs, 0.4f, this.molecule(MoleculeEnum.cellulose, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOakWoodSlabs, true, COST_PLANK, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSpruceWoodSlabs, true, COST_PLANK, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), null));
        SynthesisRecipe.add(new SynthesisRecipe(blockBirchWoodSlabs, true, COST_PLANK, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockJungleWoodSlabs, true, COST_PLANK, null, null, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockAcaciaWoodSlabs, true, COST_PLANK, null, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockDarkOakWoodSlabs, true, COST_PLANK, null, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), null, null, null, null, null));
        ItemStack blockOakSapling = new ItemStack(Blocks.field_150345_g, 1, 0);
        ItemStack blockSpruceSapling = new ItemStack(Blocks.field_150345_g, 1, 1);
        ItemStack blockBirchSapling = new ItemStack(Blocks.field_150345_g, 1, 2);
        ItemStack blockJungleSapling = new ItemStack(Blocks.field_150345_g, 1, 3);
        ItemStack blockAcaciaSapling = new ItemStack(Blocks.field_150345_g, 1, 4);
        ItemStack blockDarkOakSapling = new ItemStack(Blocks.field_150345_g, 1, 5);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOakSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSpruceSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBirchSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockJungleSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAcaciaSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockDarkOakSapling, 0.25f, this.molecule(MoleculeEnum.cellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOakSapling, true, COST_PLANT, null, null, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSpruceSapling, true, COST_PLANT, null, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null));
        SynthesisRecipe.add(new SynthesisRecipe(blockBirchSapling, true, COST_PLANT, null, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockJungleSapling, true, COST_PLANT, null, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockAcaciaSapling, true, COST_PLANT, null, null, null, null, this.molecule(MoleculeEnum.cellulose), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockDarkOakSapling, true, COST_PLANT, null, null, null, this.molecule(MoleculeEnum.cellulose), null, null, null, null, null));
        ItemStack blockSand = new ItemStack((Block)Blocks.field_150354_m);
        DecomposerRecipe.add(new DecomposerRecipe(blockSand, this.molecule(MoleculeEnum.siliconDioxide, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSand, true, COST_BLOCK, moleculeSiliconDioxide, moleculeSiliconDioxide, moleculeSiliconDioxide, moleculeSiliconDioxide));
        ItemStack blockGravel = new ItemStack(Blocks.field_150351_n);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockGravel, 0.35f, this.molecule(MoleculeEnum.siliconDioxide)));
        SynthesisRecipe.add(new SynthesisRecipe(blockGravel, true, COST_BLOCK, null, null, null, null, null, null, null, null, this.molecule(MoleculeEnum.siliconDioxide)));
        ItemStack goldOre = new ItemStack(Blocks.field_150352_o);
        DecomposerRecipe.add(new DecomposerRecipe(goldOre, this.element(ElementEnum.Au, 48)));
        ItemStack ironOre = new ItemStack(Blocks.field_150366_p);
        DecomposerRecipe.add(new DecomposerRecipe(ironOre, this.element(ElementEnum.Fe, 48)));
        ItemStack coalOre = new ItemStack(Blocks.field_150365_q);
        DecomposerRecipe.add(new DecomposerRecipe(coalOre, this.element(ElementEnum.C, 48)));
        ItemStack blockOakLog = new ItemStack(Blocks.field_150364_r, 1, 0);
        ItemStack blockSpruceLog = new ItemStack(Blocks.field_150364_r, 1, 1);
        ItemStack blockBirchLog = new ItemStack(Blocks.field_150364_r, 1, 2);
        ItemStack blockJungleLog = new ItemStack(Blocks.field_150364_r, 1, 3);
        ItemStack blockAcaciaLog = new ItemStack(Blocks.field_150363_s, 1, 0);
        ItemStack blockDarkOakLog = new ItemStack(Blocks.field_150363_s, 1, 1);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOakLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSpruceLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBirchLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockJungleLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAcaciaLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockDarkOakLog, 0.5f, this.molecule(MoleculeEnum.cellulose, 8)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOakLog, true, COST_WOOD, this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockSpruceLog, true, COST_WOOD, null, null, null, null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockBirchLog, true, COST_WOOD, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null, null, null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockJungleLog, true, COST_WOOD, this.molecule(MoleculeEnum.cellulose, 2), null, null, this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockAcaciaLog, true, COST_WOOD, null, null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), this.molecule(MoleculeEnum.cellulose, 2), null, null, this.molecule(MoleculeEnum.cellulose, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockDarkOakLog, true, COST_WOOD, null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null, this.molecule(MoleculeEnum.cellulose, 2), null));
        ItemStack blockOakLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 0);
        ItemStack blockSpruceLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 1);
        ItemStack blockBirchLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 2);
        ItemStack blockJungleLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 3);
        ItemStack blockAcaciaLeaves = new ItemStack((Block)Blocks.field_150361_u, 1, 0);
        ItemStack blockDarkOakLeaves = new ItemStack((Block)Blocks.field_150361_u, 1, 1);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOakLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSpruceLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBirchLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockJungleLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAcaciaLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockDarkOakLeaves, 0.5f, this.molecule(MoleculeEnum.cellulose, 4)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOakLeaves, true, COST_BLOCK, moleculeCellulose, moleculeCellulose, moleculeCellulose, null, moleculeCellulose, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockSpruceLeaves, true, COST_BLOCK, null, null, null, null, moleculeCellulose, null, moleculeCellulose, moleculeCellulose, moleculeCellulose));
        SynthesisRecipe.add(new SynthesisRecipe(blockBirchLeaves, true, COST_BLOCK, moleculeCellulose, null, moleculeCellulose, null, null, null, moleculeCellulose, null, moleculeCellulose));
        SynthesisRecipe.add(new SynthesisRecipe(blockJungleLeaves, true, COST_BLOCK, moleculeCellulose, null, null, moleculeCellulose, moleculeCellulose, null, moleculeCellulose, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockAcaciaLeaves, true, COST_BLOCK, null, null, moleculeCellulose, null, moleculeCellulose, moleculeCellulose, null, null, moleculeCellulose));
        SynthesisRecipe.add(new SynthesisRecipe(blockDarkOakLeaves, true, COST_BLOCK, null, moleculeCellulose, null, moleculeCellulose, null, moleculeCellulose, null, moleculeCellulose, null));
        ItemStack itemDyePowderBlack = new ItemStack(Items.field_151100_aR, 1, 0);
        ItemStack itemDyePowderRed = new ItemStack(Items.field_151100_aR, 1, 1);
        ItemStack itemDyePowderGreen = new ItemStack(Items.field_151100_aR, 1, 2);
        ItemStack itemDyePowderBrown = new ItemStack(Items.field_151100_aR, 1, 3);
        ItemStack itemDyePowderBlue = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack itemDyePowderPurple = new ItemStack(Items.field_151100_aR, 1, 5);
        ItemStack itemDyePowderCyan = new ItemStack(Items.field_151100_aR, 1, 6);
        ItemStack itemDyePowderLightGray = new ItemStack(Items.field_151100_aR, 1, 7);
        ItemStack itemDyePowderGray = new ItemStack(Items.field_151100_aR, 1, 8);
        ItemStack itemDyePowderPink = new ItemStack(Items.field_151100_aR, 1, 9);
        ItemStack itemDyePowderLime = new ItemStack(Items.field_151100_aR, 1, 10);
        ItemStack itemDyePowderYellow = new ItemStack(Items.field_151100_aR, 1, 11);
        ItemStack itemDyePowderLightBlue = new ItemStack(Items.field_151100_aR, 1, 12);
        ItemStack itemDyePowderMagenta = new ItemStack(Items.field_151100_aR, 1, 13);
        ItemStack itemDyePowderOrange = new ItemStack(Items.field_151100_aR, 1, 14);
        ItemStack itemDyePowderWhite = new ItemStack(Items.field_151100_aR, 1, 15);
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderBlack, this.molecule(MoleculeEnum.blackPigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderRed, this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderGreen, this.molecule(MoleculeEnum.greenPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(itemDyePowderBrown, 0.4f, this.molecule(MoleculeEnum.theobromine), this.molecule(MoleculeEnum.tannicacid)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderBlue, this.molecule(MoleculeEnum.lazurite)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderPurple, this.molecule(MoleculeEnum.purplePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderCyan, this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderLightGray, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderGray, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderPink, this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderLime, this.molecule(MoleculeEnum.limePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderYellow, this.molecule(MoleculeEnum.yellowPigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderLightBlue, this.molecule(MoleculeEnum.lightbluePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderMagenta, this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderOrange, this.molecule(MoleculeEnum.orangePigment)));
        DecomposerRecipe.add(new DecomposerRecipe(itemDyePowderWhite, this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderBlack, false, COST_ITEM, this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderRed, false, COST_ITEM, this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderGreen, false, COST_ITEM, this.molecule(MoleculeEnum.greenPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderBrown, false, COST_ITEM, this.molecule(MoleculeEnum.theobromine)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderBlue, false, COST_ITEM, this.molecule(MoleculeEnum.lazurite)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderPurple, false, COST_ITEM, this.molecule(MoleculeEnum.purplePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderCyan, false, COST_ITEM, this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderLightGray, false, COST_ITEM, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderGray, false, COST_ITEM, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderPink, false, COST_ITEM, this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderLime, false, COST_ITEM, this.molecule(MoleculeEnum.limePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderYellow, false, COST_ITEM, this.molecule(MoleculeEnum.yellowPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderLightBlue, false, COST_ITEM, this.molecule(MoleculeEnum.lightbluePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderMagenta, false, COST_ITEM, this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderOrange, false, COST_ITEM, this.molecule(MoleculeEnum.orangePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDyePowderWhite, false, COST_ITEM, this.molecule(MoleculeEnum.whitePigment)));
        ItemStack blockGlass = new ItemStack(Blocks.field_150359_w);
        ItemStack blockWhiteStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 0);
        ItemStack blockOrangeStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 1);
        ItemStack blockMagentaStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 2);
        ItemStack blockLiteBlueStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 3);
        ItemStack blockYellowStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 4);
        ItemStack blockLimeStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 5);
        ItemStack blockPinkStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 6);
        ItemStack blockGrayStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 7);
        ItemStack blockLiteGrayStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 8);
        ItemStack blockCyanStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 9);
        ItemStack blockPurpleStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 10);
        ItemStack blockBlueStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 11);
        ItemStack blockBrownStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 12);
        ItemStack blockGreenStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 13);
        ItemStack blockRedStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 14);
        ItemStack blockBlackStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 15);
        DecomposerRecipe.add(new DecomposerRecipe(blockGlass, this.molecule(MoleculeEnum.siliconDioxide, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(blockGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, null, null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockWhiteStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.whitePigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockOrangeStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.orangePigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockMagentaStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, this.molecule(MoleculeEnum.lightbluePigment), null, this.molecule(MoleculeEnum.redPigment), moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockLiteBlueStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.lightbluePigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockYellowStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.yellowPigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockLimeStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.limePigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockPinkStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.redPigment), moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockGrayStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.blackPigment), moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockLiteGrayStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment), moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockCyanStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.lightbluePigment), moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockPurpleStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.purplePigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlueStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.lazurite), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockBrownStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.tannicacid), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockGreenStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.greenPigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockRedStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.redPigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlackStainedGlass, true, COST_GLASS, moleculeSiliconDioxide, null, moleculeSiliconDioxide, null, this.molecule(MoleculeEnum.blackPigment), null, moleculeSiliconDioxide, null, moleculeSiliconDioxide));
        ItemStack blockGlassPane = new ItemStack(Blocks.field_150410_aZ);
        ItemStack blockWhiteStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 0);
        ItemStack blockOrangeStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 1);
        ItemStack blockMagentaStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 2);
        ItemStack blockLiteBlueStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 3);
        ItemStack blockYellowStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 4);
        ItemStack blockLimeStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 5);
        ItemStack blockPinkStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 6);
        ItemStack blockGrayStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 7);
        ItemStack blockLiteGrayStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 8);
        ItemStack blockCyanStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 9);
        ItemStack blockPurpleStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 10);
        ItemStack blockBlueStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 11);
        ItemStack blockBrownStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 12);
        ItemStack blockGreenStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 13);
        ItemStack blockRedStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 14);
        ItemStack blockBlackStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 15);
        DecomposerRecipe.add(new DecomposerRecipe(blockGlassPane, this.molecule(MoleculeEnum.siliconDioxide, 6)));
        Molecule siO = new Molecule(MoleculeEnum.siliconDioxide, 1);
        SynthesisRecipe.add(new SynthesisRecipe(blockGlassPane, true, COST_PANE, siO, siO, siO, null, null, null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockWhiteStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.whitePigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockOrangeStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.orangePigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockMagentaStainedGlassPane, true, COST_PANE, siO, siO, siO, this.molecule(MoleculeEnum.lightbluePigment), null, this.molecule(MoleculeEnum.redPigment), siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockLiteBlueStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.lightbluePigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockYellowStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.yellowPigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockLimeStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.limePigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockPinkStainedGlassPane, true, COST_PANE, siO, siO, siO, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.redPigment), siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockGrayStainedGlassPane, true, COST_PANE, siO, siO, siO, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.blackPigment), siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockLiteGrayStainedGlassPane, true, COST_PANE, siO, siO, siO, this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment), siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockCyanStainedGlassPane, true, COST_PANE, siO, siO, siO, this.molecule(MoleculeEnum.whitePigment), null, this.molecule(MoleculeEnum.lightbluePigment), siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockPurpleStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.purplePigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlueStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.lazurite), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockBrownStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.tannicacid), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockGreenStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.greenPigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockRedStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.redPigment), null, siO, siO, siO));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlackStainedGlassPane, true, COST_PANE, siO, siO, siO, null, this.molecule(MoleculeEnum.blackPigment), null, siO, siO, siO));
        ItemStack blockOreLapis = new ItemStack(Blocks.field_150369_x);
        DecomposerRecipe.add(new DecomposerRecipe(blockOreLapis, this.molecule(MoleculeEnum.lazurite, 6), this.molecule(MoleculeEnum.sodalite), this.molecule(MoleculeEnum.noselite), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.pyrite)));
        ItemStack blockLapis = new ItemStack(Blocks.field_150368_y);
        DecomposerRecipe.add(new DecomposerRecipe(blockLapis, this.molecule(MoleculeEnum.lazurite, 9)));
        SynthesisRecipe.add(new SynthesisRecipe(blockLapis, true, COST_LAPISBLOCK, moleculeLazurite, null, null, null, null, null, null, null, null));
        ItemStack blockCobweb = new ItemStack(Blocks.field_150321_G);
        DecomposerRecipe.add(new DecomposerRecipe(blockCobweb, this.molecule(MoleculeEnum.fibroin)));
        ItemStack blockSunFlower = new ItemStack((Block)Blocks.field_150398_cm, 1, 0);
        ItemStack blockLilac = new ItemStack((Block)Blocks.field_150398_cm, 1, 1);
        ItemStack blockTallGrass = new ItemStack((Block)Blocks.field_150398_cm, 1, 2);
        ItemStack blockLargeFern = new ItemStack((Block)Blocks.field_150398_cm, 1, 3);
        ItemStack blockRoseBush = new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
        ItemStack blockPeony = new ItemStack((Block)Blocks.field_150398_cm, 1, 5);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockSunFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockLilac, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockTallGrass, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockLargeFern, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockRoseBush, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPeony, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSunFlower, true, COST_PLANT, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.yellowPigment), null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockLilac, true, COST_PLANT, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment), new Molecule(MoleculeEnum.whitePigment, 2), null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockTallGrass, true, COST_PLANT, new Molecule(MoleculeEnum.shikimicAcid, 2), null, null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockLargeFern, true, COST_PLANT, null, new Molecule(MoleculeEnum.shikimicAcid, 2), null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockRoseBush, true, COST_PLANT, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment), null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockPeony, true, COST_PLANT, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment), new Molecule(MoleculeEnum.whitePigment), null, null, null, null, null, null));
        ItemStack blockSandStone = new ItemStack(Blocks.field_150322_A, 1, 0);
        ItemStack blockChiseledSandStone = new ItemStack(Blocks.field_150322_A, 1, 1);
        ItemStack blockSmoothSandStone = new ItemStack(Blocks.field_150322_A, 1, 2);
        DecomposerRecipe.add(new DecomposerRecipe(blockSandStone, this.molecule(MoleculeEnum.siliconDioxide, 16)));
        DecomposerRecipe.add(new DecomposerRecipe(blockChiseledSandStone, this.molecule(MoleculeEnum.siliconDioxide, 16)));
        DecomposerRecipe.add(new DecomposerRecipe(blockSmoothSandStone, this.molecule(MoleculeEnum.siliconDioxide, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(blockSandStone, true, COST_BLOCK, null, null, null, null, this.molecule(MoleculeEnum.siliconDioxide, 16), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(blockChiseledSandStone, true, COST_BLOCK, null, null, null, null, null, null, null, this.molecule(MoleculeEnum.siliconDioxide, 16), null));
        SynthesisRecipe.add(new SynthesisRecipe(blockSmoothSandStone, true, COST_BLOCK, null, this.molecule(MoleculeEnum.siliconDioxide, 16), null, null, null, null, null, null, null));
        ItemStack blockWool = new ItemStack(Blocks.field_150325_L, 1, 0);
        ItemStack blockOrangeWool = new ItemStack(Blocks.field_150325_L, 1, 1);
        ItemStack blockMagentaWool = new ItemStack(Blocks.field_150325_L, 1, 2);
        ItemStack blockLightBlueWool = new ItemStack(Blocks.field_150325_L, 1, 3);
        ItemStack blockYellowWool = new ItemStack(Blocks.field_150325_L, 1, 4);
        ItemStack blockLimeWool = new ItemStack(Blocks.field_150325_L, 1, 5);
        ItemStack blockPinkWool = new ItemStack(Blocks.field_150325_L, 1, 6);
        ItemStack blockGrayWool = new ItemStack(Blocks.field_150325_L, 1, 7);
        ItemStack blockLightGrayWool = new ItemStack(Blocks.field_150325_L, 1, 8);
        ItemStack blockCyanWool = new ItemStack(Blocks.field_150325_L, 1, 9);
        ItemStack blockPurpleWool = new ItemStack(Blocks.field_150325_L, 1, 10);
        ItemStack blockBlueWool = new ItemStack(Blocks.field_150325_L, 1, 11);
        ItemStack blockBrownWool = new ItemStack(Blocks.field_150325_L, 1, 12);
        ItemStack blockGreenWool = new ItemStack(Blocks.field_150325_L, 1, 13);
        ItemStack blockRedWool = new ItemStack(Blocks.field_150325_L, 1, 14);
        ItemStack blockBlackWool = new ItemStack(Blocks.field_150325_L, 1, 15);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOrangeWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.orangePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockMagentaWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockLightBlueWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockYellowWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.yellowPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockLimeWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.limePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPinkWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockGrayWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockLightGrayWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockCyanWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPurpleWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.purplePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBlueWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lazurite)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBrownWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.tannicacid)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockGreenWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.greenPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockRedWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBlackWool, 0.6f, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockOrangeWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.orangePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockMagentaWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockLightBlueWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockYellowWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.yellowPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockLimeWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.limePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockPinkWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockGrayWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(blockLightGrayWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockCyanWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockPurpleWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.purplePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlueWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.lazurite)));
        SynthesisRecipe.add(new SynthesisRecipe(blockGreenWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.greenPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockRedWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(blockBlackWool, false, COST_WOOL, this.molecule(MoleculeEnum.glycine, 2), this.molecule(MoleculeEnum.blackPigment)));
        ItemStack carpetBlockWool = new ItemStack(Blocks.field_150404_cg, 1, 0);
        ItemStack carpetBlockOrangeWool = new ItemStack(Blocks.field_150404_cg, 1, 1);
        ItemStack carpetBlockMagentaWool = new ItemStack(Blocks.field_150404_cg, 1, 2);
        ItemStack carpetBlockLightBlueWool = new ItemStack(Blocks.field_150404_cg, 1, 3);
        ItemStack carpetBlockYellowWool = new ItemStack(Blocks.field_150404_cg, 1, 4);
        ItemStack carpetBlockLimeWool = new ItemStack(Blocks.field_150404_cg, 1, 5);
        ItemStack carpetBlockPinkWool = new ItemStack(Blocks.field_150404_cg, 1, 6);
        ItemStack carpetBlockGrayWool = new ItemStack(Blocks.field_150404_cg, 1, 7);
        ItemStack carpetBlockLightGrayWool = new ItemStack(Blocks.field_150404_cg, 1, 8);
        ItemStack carpetBlockCyanWool = new ItemStack(Blocks.field_150404_cg, 1, 9);
        ItemStack carpetBlockPurpleWool = new ItemStack(Blocks.field_150404_cg, 1, 10);
        ItemStack carpetBlockBlueWool = new ItemStack(Blocks.field_150404_cg, 1, 11);
        ItemStack carpetBlockBrownWool = new ItemStack(Blocks.field_150404_cg, 1, 12);
        ItemStack carpetBlockGreenWool = new ItemStack(Blocks.field_150404_cg, 1, 13);
        ItemStack carpetBlockRedWool = new ItemStack(Blocks.field_150404_cg, 1, 14);
        ItemStack carpetBlockBlackWool = new ItemStack(Blocks.field_150404_cg, 1, 15);
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockOrangeWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.orangePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockMagentaWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockLightBlueWool, 0.2f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockYellowWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.yellowPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockLimeWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.limePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockPinkWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockGrayWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockLightGrayWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockCyanWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockPurpleWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.purplePigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockBlueWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lazurite)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockBrownWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.tannicacid)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockGreenWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.greenPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockRedWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.redPigment)));
        DecomposerRecipe.add(new DecomposerRecipeChance(carpetBlockBlackWool, 0.4f, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockOrangeWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.orangePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockMagentaWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockLightBlueWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockYellowWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.yellowPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockLimeWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.limePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockPinkWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockGrayWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockLightGrayWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockCyanWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockPurpleWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.purplePigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockBlueWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.lazurite)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockGreenWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.greenPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockRedWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.redPigment)));
        SynthesisRecipe.add(new SynthesisRecipe(carpetBlockBlackWool, false, COST_CARPET, this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.blackPigment)));
        ItemStack blockYellowFlower = new ItemStack((Block)Blocks.field_150327_N);
        ItemStack blockPoppyFlower = new ItemStack((Block)Blocks.field_150328_O, 1, 0);
        ItemStack blockBlueOrchid = new ItemStack((Block)Blocks.field_150328_O, 1, 1);
        ItemStack blockAllium = new ItemStack((Block)Blocks.field_150328_O, 1, 2);
        ItemStack blockAsureBluet = new ItemStack((Block)Blocks.field_150328_O, 1, 3);
        ItemStack blockRedTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 4);
        ItemStack blockOrangeTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 5);
        ItemStack blockWhiteTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 6);
        ItemStack blockPinkTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
        ItemStack blockOxeyeDaisy = new ItemStack((Block)Blocks.field_150328_O, 1, 8);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockYellowFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.yellowPigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPoppyFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockBlueOrchid, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), this.molecule(MoleculeEnum.lazurite)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAllium, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.purplePigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockAsureBluet, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockRedTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOrangeTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.orangePigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockWhiteTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPinkTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1), new Molecule(MoleculeEnum.redPigment, 1)));
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOxeyeDaisy, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        ItemStack blockMushroomBrown = new ItemStack((Block)Blocks.field_150338_P);
        ItemStack blockMushroomRed = new ItemStack((Block)Blocks.field_150337_Q);
        if (Settings.recreationalChemicalEffects) {
            DecomposerRecipe.add(new DecomposerRecipe(blockMushroomBrown, this.molecule(MoleculeEnum.psilocybin), this.molecule(MoleculeEnum.water, 2)));
        }
        DecomposerRecipe.add(new DecomposerRecipe(blockMushroomRed, this.molecule(MoleculeEnum.pantherine), this.molecule(MoleculeEnum.water, 2)));
        DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(Blocks.field_150340_R), this.element(ElementEnum.Au, 144)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150340_R), true, COST_METALBLOCK, this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16), this.element(ElementEnum.Au, 16)));
        DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(Blocks.field_150339_S), this.element(ElementEnum.Fe, 144)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150339_S), true, COST_METALBLOCK, this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16), this.element(ElementEnum.Fe, 16)));
        ItemStack blockTnt = new ItemStack(Blocks.field_150335_W);
        DecomposerRecipe.add(new DecomposerRecipe(blockTnt, this.molecule(MoleculeEnum.tnt)));
        SynthesisRecipe.add(new SynthesisRecipe(blockTnt, false, COST_OBSIDIAN, this.molecule(MoleculeEnum.tnt)));
        ItemStack blockObsidian = new ItemStack(Blocks.field_150343_Z);
        DecomposerRecipe.add(new DecomposerRecipe(blockObsidian, this.molecule(MoleculeEnum.siliconDioxide, 16), this.molecule(MoleculeEnum.magnesiumOxide, 8)));
        SynthesisRecipe.add(new SynthesisRecipe(blockObsidian, true, COST_OBSIDIAN, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.magnesiumOxide, 2), null, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.magnesiumOxide, 2), this.molecule(MoleculeEnum.magnesiumOxide, 2), this.molecule(MoleculeEnum.magnesiumOxide, 2)));
        ItemStack blockOreDiamond = new ItemStack(Blocks.field_150482_ag);
        DecomposerRecipe.add(new DecomposerRecipe(blockOreDiamond, this.molecule(MoleculeEnum.fullrene, 6)));
        ItemStack blockDiamond = new ItemStack(Blocks.field_150484_ah);
        DecomposerRecipe.add(new DecomposerRecipe(blockDiamond, this.molecule(MoleculeEnum.fullrene, 27)));
        SynthesisRecipe.add(new SynthesisRecipe(blockDiamond, true, COST_GEMBLOCK, this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.fullrene, 3)));
        ItemStack blockPressurePlatePlanks = new ItemStack(Blocks.field_150452_aw);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockPressurePlatePlanks, 0.4f, this.molecule(MoleculeEnum.cellulose, 4)));
        ItemStack blockOreRedstone = new ItemStack(Blocks.field_150450_ax);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockOreRedstone, 0.8f, this.molecule(MoleculeEnum.iron3oxide, 9), this.element(ElementEnum.Cu, 9)));
        ItemStack blockCactus = new ItemStack(Blocks.field_150434_aF);
        DecomposerRecipe.add(new DecomposerRecipe(blockCactus, this.molecule(MoleculeEnum.mescaline), this.molecule(MoleculeEnum.water, 20)));
        SynthesisRecipe.add(new SynthesisRecipe(blockCactus, true, COST_PLANT, this.molecule(MoleculeEnum.water, 5), null, this.molecule(MoleculeEnum.water, 5), null, this.molecule(MoleculeEnum.mescaline), null, this.molecule(MoleculeEnum.water, 5), null, this.molecule(MoleculeEnum.water, 5)));
        ItemStack blockPumpkin = new ItemStack(Blocks.field_150423_aK);
        DecomposerRecipe.add(new DecomposerRecipe(blockPumpkin, this.molecule(MoleculeEnum.cucurbitacin)));
        SynthesisRecipe.add(new SynthesisRecipe(blockPumpkin, false, COST_PLANT, this.molecule(MoleculeEnum.cucurbitacin)));
        new ItemStack(Items.field_151080_bb);
        DecomposerRecipe.add(new DecomposerRecipe(blockPumpkin, this.molecule(MoleculeEnum.water)));
        SynthesisRecipe.add(new SynthesisRecipe(blockPumpkin, false, COST_PLANT, this.molecule(MoleculeEnum.cucurbitacin)));
        ItemStack blockNetherrack = new ItemStack(Blocks.field_150424_aL);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockNetherrack, 0.1f, new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.O), this.element(ElementEnum.Fe)), new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.Ni), this.element(ElementEnum.Tc)), new DecomposerRecipe(this.element(ElementEnum.Si, 3), this.element(ElementEnum.Ti), this.element(ElementEnum.Fe)), new DecomposerRecipe(this.element(ElementEnum.Si, 1), this.element(ElementEnum.W, 4), this.element(ElementEnum.Cr, 2)), new DecomposerRecipe(this.element(ElementEnum.Si, 10), this.element(ElementEnum.W, 1), this.element(ElementEnum.Zn, 8), this.element(ElementEnum.Be, 4))));
        ItemStack itemNetherbrick = new ItemStack(Items.field_151130_bT);
        DecomposerRecipe.add(new DecomposerRecipeSelect(itemNetherbrick, 0.15f, new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.C), this.element(ElementEnum.Fe)), new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.Ni), this.element(ElementEnum.Tc)), new DecomposerRecipe(this.element(ElementEnum.Si, 3), this.element(ElementEnum.Ti), this.element(ElementEnum.Fe)), new DecomposerRecipe(this.element(ElementEnum.Si, 1), this.element(ElementEnum.W, 4), this.element(ElementEnum.Cr, 2)), new DecomposerRecipe(this.element(ElementEnum.Si, 10), this.element(ElementEnum.W, 1), this.element(ElementEnum.Zn, 8), this.element(ElementEnum.Be, 4))));
        SynthesisRecipe.add(new SynthesisRecipe(itemNetherbrick, true, COST_SMOOTH, this.element(ElementEnum.Si, 2), this.element(ElementEnum.Si, 2), null, this.element(ElementEnum.Zn, 2), this.element(ElementEnum.W, 1), null, this.element(ElementEnum.Be, 2), this.element(ElementEnum.Be, 2), null));
        ItemStack itemPotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        DecomposerRecipe.add(new DecomposerRecipe(itemPotion, this.molecule(MoleculeEnum.water, 5), this.molecule(MoleculeEnum.siliconDioxide, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(itemPotion, true, COST_ITEM, null, this.molecule(MoleculeEnum.siliconDioxide, 4), null, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.water, 5), this.molecule(MoleculeEnum.siliconDioxide, 4), null, this.molecule(MoleculeEnum.siliconDioxide, 4), null));
        ItemStack blockIce = new ItemStack(Blocks.field_150432_aD);
        DecomposerRecipe.add(new DecomposerRecipe(blockIce, this.molecule(MoleculeEnum.water, 8)));
        ItemStack blockSlowSand = new ItemStack(Blocks.field_150425_aM);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockSlowSand, 0.2f, new DecomposerRecipe(this.element(ElementEnum.Pb, 3), this.element(ElementEnum.Be, 1), this.element(ElementEnum.Si, 2), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Pb, 1), this.element(ElementEnum.Si, 5), this.element(ElementEnum.O, 2)), new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.O)), new DecomposerRecipe(this.element(ElementEnum.Si, 6), this.element(ElementEnum.O, 2)), new DecomposerRecipe(this.element(ElementEnum.Es, 1), this.element(ElementEnum.O, 2))));
        ItemStack blockGlowStone = new ItemStack(Blocks.field_150426_aN);
        DecomposerRecipe.add(new DecomposerRecipe(blockGlowStone, this.element(ElementEnum.P, 4)));
        SynthesisRecipe.add(new SynthesisRecipe(blockGlowStone, true, COST_GLOWBLOCK, this.element(ElementEnum.P), null, this.element(ElementEnum.P), this.element(ElementEnum.P), null, this.element(ElementEnum.P), null, null, null));
        ItemStack blockMycelium = new ItemStack((Block)Blocks.field_150391_bh);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockMycelium, 0.09f, this.molecule(MoleculeEnum.fingolimod)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack((Block)Blocks.field_150391_bh, 16), false, COST_GRASS, this.molecule(MoleculeEnum.fingolimod)));
        ItemStack blockWhiteStone = new ItemStack(Blocks.field_150377_bs);
        DecomposerRecipe.add(new DecomposerRecipeSelect(blockWhiteStone, 0.8f, new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.O), this.element(ElementEnum.H, 4), this.element(ElementEnum.Li)), new DecomposerRecipe(this.element(ElementEnum.Es)), new DecomposerRecipe(this.element(ElementEnum.Pu)), new DecomposerRecipe(this.element(ElementEnum.Fr)), new DecomposerRecipe(this.element(ElementEnum.Nd)), new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.O, 4)), new DecomposerRecipe(this.element(ElementEnum.H, 4)), new DecomposerRecipe(this.element(ElementEnum.Be, 8)), new DecomposerRecipe(this.element(ElementEnum.Li, 2)), new DecomposerRecipe(this.element(ElementEnum.Zr)), new DecomposerRecipe(this.element(ElementEnum.Na)), new DecomposerRecipe(this.element(ElementEnum.Rb)), new DecomposerRecipe(this.element(ElementEnum.Ga), this.element(ElementEnum.As))));
        ItemStack blockOreEmerald = new ItemStack(Blocks.field_150412_bA);
        DecomposerRecipe.add(new DecomposerRecipe(blockOreEmerald, this.molecule(MoleculeEnum.beryl, 6), this.element(ElementEnum.Cr, 6), this.element(ElementEnum.V, 6)));
        ItemStack blockEmerald = new ItemStack(Blocks.field_150475_bE);
        SynthesisRecipe.add(new SynthesisRecipe(blockEmerald, true, COST_GEMBLOCK, this.element(ElementEnum.Cr, 3), this.element(ElementEnum.Cr, 3), this.element(ElementEnum.Cr, 3), this.element(ElementEnum.V, 9), this.molecule(MoleculeEnum.beryl, 18), this.element(ElementEnum.V, 9), this.element(ElementEnum.Cr, 3), this.element(ElementEnum.Cr, 3), this.element(ElementEnum.Cr, 3)));
        DecomposerRecipe.add(new DecomposerRecipe(blockEmerald, this.molecule(MoleculeEnum.beryl, 18), this.element(ElementEnum.Cr, 18), this.element(ElementEnum.V, 18)));
        ItemStack itemAppleRed = new ItemStack(Items.field_151034_e);
        DecomposerRecipe.add(new DecomposerRecipe(itemAppleRed, this.molecule(MoleculeEnum.malicAcid)));
        SynthesisRecipe.add(new SynthesisRecipe(itemAppleRed, false, COST_FOOD, this.molecule(MoleculeEnum.malicAcid), this.molecule(MoleculeEnum.water, 2)));
        ItemStack itemArrow = new ItemStack(Items.field_151032_g);
        DecomposerRecipe.add(new DecomposerRecipe(itemArrow, this.element(ElementEnum.Si), this.element(ElementEnum.O, 2), this.element(ElementEnum.N, 6)));
        ItemStack itemCoal = new ItemStack(Items.field_151044_h);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemCoal, 0.92f, this.element(ElementEnum.C, 8)));
        ItemStack blockCoal = new ItemStack(Blocks.field_150402_ci);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockCoal, 0.82f, this.element(ElementEnum.C, 72)));
        ItemStack itemChar = new ItemStack(Items.field_151044_h, 1, 1);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemChar, 0.82f, this.element(ElementEnum.C, 8)));
        SynthesisRecipe.add(new SynthesisRecipe(itemChar, false, COST_ITEM, this.element(ElementEnum.C, 4), this.element(ElementEnum.C, 4)));
        ItemStack itemDiamond = new ItemStack(Items.field_151045_i);
        DecomposerRecipe.add(new DecomposerRecipe(itemDiamond, this.molecule(MoleculeEnum.fullrene, 3)));
        SynthesisRecipe.add(new SynthesisRecipe(itemDiamond, true, COST_GEM, null, null, null, null, this.molecule(MoleculeEnum.fullrene, 3), null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(MinechemItemsRegistration.polytool), true, COST_STAR, null, this.molecule(MoleculeEnum.fullrene, 64), null, this.molecule(MoleculeEnum.fullrene, 64), null, this.molecule(MoleculeEnum.fullrene, 64), null, this.molecule(MoleculeEnum.fullrene, 64), null));
        SynthesisRecipe.add(new SynthesisRecipe(itemDiamond, true, COST_GEM, null, this.molecule(MoleculeEnum.fullrene), null, this.molecule(MoleculeEnum.fullrene), null, this.molecule(MoleculeEnum.fullrene), null, this.molecule(MoleculeEnum.fullrene), null));
        ItemStack itemIngotIron = new ItemStack(Items.field_151042_j);
        DecomposerRecipe.add(new DecomposerRecipe(itemIngotIron, this.element(ElementEnum.Fe, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(itemIngotIron, false, COST_INGOT, this.element(ElementEnum.Fe, 16)));
        ItemStack itemIngotGold = new ItemStack(Items.field_151043_k);
        DecomposerRecipe.add(new DecomposerRecipe(itemIngotGold, this.element(ElementEnum.Au, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(itemIngotGold, false, COST_INGOT, this.element(ElementEnum.Au, 16)));
        ItemStack itemStick = new ItemStack(Items.field_151055_y);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemStick, 0.3f, this.molecule(MoleculeEnum.cellulose)));
        ItemStack itemString = new ItemStack(Items.field_151007_F);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemString, 0.45f, this.molecule(MoleculeEnum.serine), this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.alinine)));
        SynthesisRecipe.add(new SynthesisRecipe(itemString, true, COST_ITEM, this.molecule(MoleculeEnum.serine), this.molecule(MoleculeEnum.glycine), this.molecule(MoleculeEnum.alinine)));
        ItemStack itemFeather = new ItemStack(Items.field_151008_G);
        DecomposerRecipe.add(new DecomposerRecipe(itemFeather, this.molecule(MoleculeEnum.water, 8), this.element(ElementEnum.N, 6)));
        SynthesisRecipe.add(new SynthesisRecipe(itemFeather, true, COST_ITEM, this.element(ElementEnum.N), this.molecule(MoleculeEnum.water, 2), this.element(ElementEnum.N), this.element(ElementEnum.N), this.molecule(MoleculeEnum.water, 1), this.element(ElementEnum.N), this.element(ElementEnum.N), this.molecule(MoleculeEnum.water, 5), this.element(ElementEnum.N)));
        ItemStack itemGunpowder = new ItemStack(Items.field_151016_H);
        DecomposerRecipe.add(new DecomposerRecipe(itemGunpowder, this.molecule(MoleculeEnum.potassiumNitrate), this.element(ElementEnum.S, 2), this.element(ElementEnum.C)));
        SynthesisRecipe.add(new SynthesisRecipe(itemGunpowder, true, COST_ITEM, this.molecule(MoleculeEnum.potassiumNitrate), this.element(ElementEnum.C), null, this.element(ElementEnum.S, 2), null, null, null, null, null));
        ItemStack itemBread = new ItemStack(Items.field_151025_P);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemBread, 0.1f, this.molecule(MoleculeEnum.starch), this.molecule(MoleculeEnum.sucrose)));
        ItemStack itemFlint = new ItemStack(Items.field_151145_ak);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemFlint, 0.5f, this.molecule(MoleculeEnum.siliconDioxide)));
        SynthesisRecipe.add(new SynthesisRecipe(itemFlint, true, COST_ITEM, null, moleculeSiliconDioxide, null, moleculeSiliconDioxide, moleculeSiliconDioxide, moleculeSiliconDioxide, null, null, null));
        ItemStack itemAppleGold = new ItemStack(Items.field_151153_ao, 1, 0);
        DecomposerRecipe.add(new DecomposerRecipe(itemAppleGold, this.molecule(MoleculeEnum.malicAcid), this.element(ElementEnum.Au, 64)));
        ItemStack itemDoorWood = new ItemStack(Items.field_151135_aq);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemDoorWood, 0.4f, this.molecule(MoleculeEnum.cellulose, 12)));
        ItemStack itemBucket = new ItemStack(Items.field_151133_ar);
        DecomposerRecipe.add(new DecomposerRecipe(itemBucket, this.element(ElementEnum.Fe, 48)));
        SynthesisRecipe.add(new SynthesisRecipe(itemBucket, true, COST_FOOD, null, null, null, this.element(ElementEnum.Fe, 16), null, this.element(ElementEnum.Fe, 16), null, this.element(ElementEnum.Fe, 16), null));
        ItemStack itemBucketWater = new ItemStack(Items.field_151131_as);
        DecomposerRecipe.add(new DecomposerRecipe(itemBucketWater, this.molecule(MoleculeEnum.water, 16), this.element(ElementEnum.Fe, 48)));
        SynthesisRecipe.add(new SynthesisRecipe(itemBucketWater, true, COST_FOOD, null, null, null, this.element(ElementEnum.Fe, 16), this.molecule(MoleculeEnum.water, 16), this.element(ElementEnum.Fe, 16), null, this.element(ElementEnum.Fe, 16), null));
        ItemStack itemRedstone = new ItemStack(Items.field_151137_ax);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemRedstone, 0.42f, this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
        SynthesisRecipe.add(new SynthesisRecipe(itemRedstone, true, COST_LAPIS, null, null, this.molecule(MoleculeEnum.iron3oxide), null, this.element(ElementEnum.Cu), null, null, null, null));
        ItemStack blockRedstone = new ItemStack(Blocks.field_150451_bX);
        DecomposerRecipe.add(new DecomposerRecipeChance(blockRedstone, 0.42f, this.molecule(MoleculeEnum.iron3oxide, 9), this.element(ElementEnum.Cu, 9)));
        SynthesisRecipe.add(new SynthesisRecipe(blockRedstone, true, COST_LAPISBLOCK, null, null, this.molecule(MoleculeEnum.iron3oxide, 9), null, this.element(ElementEnum.Cu, 9), null, null, null, null));
        ItemStack itemSnowball = new ItemStack(Items.field_151126_ay);
        DecomposerRecipe.add(new DecomposerRecipe(itemSnowball, this.molecule(MoleculeEnum.water)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151126_ay, 5), true, COST_ITEM, this.molecule(MoleculeEnum.water), null, this.molecule(MoleculeEnum.water), null, this.molecule(MoleculeEnum.water), null, this.molecule(MoleculeEnum.water), null, this.molecule(MoleculeEnum.water)));
        ItemStack itemLeather = new ItemStack(Items.field_151116_aA);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemLeather, 0.2f, this.molecule(MoleculeEnum.keratin)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151116_aA, 5), true, COST_ITEM, null, null, null, null, this.molecule(MoleculeEnum.keratin), null, null, null, null));
        ItemStack itemBrick = new ItemStack(Items.field_151118_aC);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemBrick, 0.5f, this.molecule(MoleculeEnum.kaolinite)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151118_aC, 8), true, COST_ITEM, this.molecule(MoleculeEnum.kaolinite), this.molecule(MoleculeEnum.kaolinite), null, this.molecule(MoleculeEnum.kaolinite), this.molecule(MoleculeEnum.kaolinite), null));
        ItemStack itemClayBall = new ItemStack(Items.field_151119_aD);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemClayBall, 0.5f, this.molecule(MoleculeEnum.kaolinite)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151119_aD, 2), false, COST_ITEM, this.molecule(MoleculeEnum.kaolinite)));
        ItemStack itemReed = new ItemStack(Items.field_151120_aE);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemReed, 0.65f, this.molecule(MoleculeEnum.sucrose), this.element(ElementEnum.H, 2), this.element(ElementEnum.O)));
        ItemStack itemVine = new ItemStack(Blocks.field_150395_bd);
        DecomposerRecipe.add(new DecomposerRecipe(itemVine, this.molecule(MoleculeEnum.cellulose, 6)));
        SynthesisRecipe.add(new SynthesisRecipe(itemVine, true, COST_GRASS, this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose), this.molecule(MoleculeEnum.cellulose), null, this.molecule(MoleculeEnum.cellulose)));
        ItemStack itemPaper = new ItemStack(Items.field_151121_aF);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemPaper, 0.35f, this.molecule(MoleculeEnum.cellulose)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151121_aF, 8), true, COST_ITEM, null, this.molecule(MoleculeEnum.cellulose), null, null, this.molecule(MoleculeEnum.cellulose), null, null, this.molecule(MoleculeEnum.cellulose), null));
        ItemStack itemCompass = new ItemStack(Items.field_151111_aL);
        DecomposerRecipe.add(new DecomposerRecipeSelect(itemCompass, 1.0f, new DecomposerRecipe(this.element(ElementEnum.Fe, 64)), new DecomposerRecipe(this.element(ElementEnum.Fe, 64), this.molecule(MoleculeEnum.iron3oxide)), new DecomposerRecipe(this.element(ElementEnum.Fe, 64), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)), new DecomposerRecipe(this.element(ElementEnum.Fe, 64), this.element(ElementEnum.Cu))));
        ItemStack itemMap = new ItemStack((Item)Items.field_151148_bJ);
        DecomposerRecipe.add(new DecomposerRecipeSuper(itemMap, new ItemStack[]{itemPaper, itemPaper, itemPaper, itemPaper, itemPaper, itemPaper, itemPaper, itemPaper, itemCompass}));
        ItemStack itemBook = new ItemStack(Items.field_151122_aG);
        DecomposerRecipe.add(new DecomposerRecipeSuper(itemBook, new ItemStack[]{itemPaper, itemPaper, itemPaper, itemLeather}));
        ItemStack blockBook = new ItemStack(Blocks.field_150342_X);
        DecomposerRecipe.add(new DecomposerRecipeSuper(blockBook, new ItemStack[]{blockBirchWoodPlanks, blockBirchWoodPlanks, blockBirchWoodPlanks, itemBook, itemBook, itemBook, blockBirchWoodPlanks, blockBirchWoodPlanks, blockBirchWoodPlanks}));
        ItemStack itemSlimeBall = new ItemStack(Items.field_151123_aH);
        DecomposerRecipe.add(new DecomposerRecipeSelect(itemSlimeBall, 0.9f, new DecomposerRecipe(this.molecule(MoleculeEnum.pmma)), new DecomposerRecipe(this.element(ElementEnum.Hg)), new DecomposerRecipe(this.molecule(MoleculeEnum.water, 10))));
        ItemStack itemGlowstone = new ItemStack(Items.field_151114_aO);
        DecomposerRecipe.add(new DecomposerRecipe(itemGlowstone, this.element(ElementEnum.P)));
        ItemStack itemBone = new ItemStack(Items.field_151103_aS);
        DecomposerRecipe.add(new DecomposerRecipe(itemBone, this.molecule(MoleculeEnum.hydroxylapatite)));
        SynthesisRecipe.add(new SynthesisRecipe(itemBone, false, COST_ITEM, this.molecule(MoleculeEnum.hydroxylapatite)));
        ItemStack itemSugar = new ItemStack(Items.field_151102_aT);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemSugar, 0.75f, this.molecule(MoleculeEnum.sucrose)));
        SynthesisRecipe.add(new SynthesisRecipe(itemSugar, false, COST_SUGAR, this.molecule(MoleculeEnum.sucrose)));
        ItemStack itemMelon = new ItemStack(Items.field_151127_ba);
        DecomposerRecipe.add(new DecomposerRecipe(itemMelon, this.molecule(MoleculeEnum.water, 1)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Items.field_151127_ba), false, COST_FOOD, this.molecule(MoleculeEnum.cucurbitacin), this.molecule(MoleculeEnum.asparticAcid), this.molecule(MoleculeEnum.water, 1)));
        ItemStack blockMelon = new ItemStack(Blocks.field_150440_ba);
        DecomposerRecipe.add(new DecomposerRecipe(blockMelon, this.molecule(MoleculeEnum.cucurbitacin), this.molecule(MoleculeEnum.asparticAcid), this.molecule(MoleculeEnum.water, 16)));
        SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(Blocks.field_150440_ba, 1), false, COST_FOOD, this.molecule(MoleculeEnum.cucurbitacin), this.molecule(MoleculeEnum.asparticAcid), this.molecule(MoleculeEnum.water, 16)));
        ItemStack itemChickenCooked = new ItemStack(Items.field_151077_bg);
        DecomposerRecipe.add(new DecomposerRecipe(itemChickenCooked, this.element(ElementEnum.K), this.element(ElementEnum.Na), this.element(ElementEnum.C, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(itemChickenCooked, true, COST_FOOD, this.element(ElementEnum.K, 16), this.element(ElementEnum.Na, 16), this.element(ElementEnum.C, 16)));
        ItemStack itemRottenFlesh = new ItemStack(Items.field_151078_bh);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemRottenFlesh, 0.05f, new Molecule(MoleculeEnum.nodularin, 1)));
        ItemStack itemEnderPearl = new ItemStack(Items.field_151079_bi);
        DecomposerRecipe.add(new DecomposerRecipe(itemEnderPearl, this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 8)));
        SynthesisRecipe.add(new SynthesisRecipe(itemEnderPearl, true, COST_TEAR, this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate), this.molecule(MoleculeEnum.calciumCarbonate)));
        ItemStack blockEnderDragonEgg = new ItemStack(Blocks.field_150380_bt);
        DecomposerRecipe.add(new DecomposerRecipe(blockEnderDragonEgg, this.molecule(MoleculeEnum.calciumCarbonate, 16), this.molecule(MoleculeEnum.hydroxylapatite, 6), this.element(ElementEnum.Pu, 18), this.element(ElementEnum.Fm, 8)));
        SynthesisRecipe.add(new SynthesisRecipe(blockEnderDragonEgg, true, COST_BLOCK * 2, this.molecule(MoleculeEnum.calciumCarbonate, 18), this.molecule(MoleculeEnum.hydroxylapatite, 8), this.element(ElementEnum.Pu, 22), this.element(ElementEnum.Fm, 12)));
        ItemStack itemBlazeRod = new ItemStack(Items.field_151072_bj);
        DecomposerRecipe.add(new DecomposerRecipe(itemBlazeRod, this.element(ElementEnum.Pu, 6)));
        SynthesisRecipe.add(new SynthesisRecipe(itemBlazeRod, true, COST_TEAR, this.element(ElementEnum.Pu, 2), null, null, this.element(ElementEnum.Pu, 2), null, null, this.element(ElementEnum.Pu, 2), null, null));
        ItemStack itemBlazePowder = new ItemStack(Items.field_151065_br);
        DecomposerRecipe.add(new DecomposerRecipe(itemBlazePowder, this.element(ElementEnum.Pu)));
        ItemStack itemGhastTear = new ItemStack(Items.field_151073_bk);
        DecomposerRecipe.add(new DecomposerRecipe(itemGhastTear, this.element(ElementEnum.Yb, 4), this.element(ElementEnum.No, 4)));
        SynthesisRecipe.add(new SynthesisRecipe(itemGhastTear, true, COST_TEAR, this.element(ElementEnum.Yb), this.element(ElementEnum.Yb), this.element(ElementEnum.No), null, this.element(ElementEnum.Yb, 2), this.element(ElementEnum.No, 2), null, this.element(ElementEnum.No), null));
        if (Settings.recreationalChemicalEffects) {
            ItemStack itemNetherStalkSeeds = new ItemStack(Items.field_151075_bm);
            DecomposerRecipe.add(new DecomposerRecipeChance(itemNetherStalkSeeds, 0.5f, this.molecule(MoleculeEnum.cocainehcl)));
        }
        ItemStack itemSpiderEye = new ItemStack(Items.field_151070_bp);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemSpiderEye, 0.2f, this.molecule(MoleculeEnum.tetrodotoxin)));
        SynthesisRecipe.add(new SynthesisRecipe(itemSpiderEye, true, COST_ITEM, this.element(ElementEnum.C), null, null, null, this.molecule(MoleculeEnum.tetrodotoxin), null, null, null, this.element(ElementEnum.C)));
        ItemStack itemFermentedSpiderEye = new ItemStack(Items.field_151071_bq);
        DecomposerRecipe.add(new DecomposerRecipe(itemFermentedSpiderEye, this.element(ElementEnum.Po), this.molecule(MoleculeEnum.ethanol)));
        ItemStack itemMagmaCream = new ItemStack(Items.field_151064_bs);
        DecomposerRecipe.add(new DecomposerRecipe(itemMagmaCream, this.element(ElementEnum.Hg), this.element(ElementEnum.Pu), this.molecule(MoleculeEnum.pmma, 3)));
        SynthesisRecipe.add(new SynthesisRecipe(itemMagmaCream, true, COST_TEAR, null, this.element(ElementEnum.Pu), null, this.molecule(MoleculeEnum.pmma), this.element(ElementEnum.Hg), this.molecule(MoleculeEnum.pmma), null, this.molecule(MoleculeEnum.pmma), null));
        ItemStack itemSpeckledMelon = new ItemStack(Items.field_151060_bw);
        DecomposerRecipe.add(new DecomposerRecipe(itemSpeckledMelon, this.molecule(MoleculeEnum.water, 4), this.molecule(MoleculeEnum.whitePigment), this.element(ElementEnum.Au, 1)));
        ItemStack itemEmerald = new ItemStack(Items.field_151166_bC);
        DecomposerRecipe.add(new DecomposerRecipe(itemEmerald, this.molecule(MoleculeEnum.beryl, 2), this.element(ElementEnum.Cr, 2), this.element(ElementEnum.V, 2)));
        SynthesisRecipe.add(new SynthesisRecipe(itemEmerald, true, 5000, null, this.element(ElementEnum.Cr), null, this.element(ElementEnum.V), this.molecule(MoleculeEnum.beryl, 2), this.element(ElementEnum.V), null, this.element(ElementEnum.Cr), null));
        ItemStack itemWheat = new ItemStack(Items.field_151015_O);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemWheat, 0.3f, this.molecule(MoleculeEnum.cellulose, 2)));
        ItemStack itemCarrot = new ItemStack(Items.field_151172_bF);
        DecomposerRecipe.add(new DecomposerRecipe(itemCarrot, this.molecule(MoleculeEnum.retinol)));
        ItemStack itemPotato = new ItemStack(Items.field_151174_bG);
        DecomposerRecipe.add(new DecomposerRecipeChance(itemPotato, 0.4f, this.molecule(MoleculeEnum.water, 8), this.element(ElementEnum.K, 2), this.molecule(MoleculeEnum.cellulose)));
        ItemStack itemGoldenCarrot = new ItemStack(Items.field_151150_bK);
        DecomposerRecipe.add(new DecomposerRecipe(itemGoldenCarrot, this.molecule(MoleculeEnum.retinol), this.element(ElementEnum.Au, 4)));
        ItemStack itemNetherStar = new ItemStack(Items.field_151156_bN);
        DecomposerRecipe.add(new DecomposerRecipe(itemNetherStar, elementHelium, elementHelium, elementHelium, elementCarbon, this.element(ElementEnum.Cn, 16), elementHelium, elementHydrogen, elementHydrogen, elementHydrogen));
        SynthesisRecipe.add(new SynthesisRecipe(itemNetherStar, true, COST_STAR, elementHelium, elementHelium, elementHelium, elementCarbon, this.element(ElementEnum.Cn, 16), elementHelium, elementHydrogen, elementHydrogen, elementHydrogen));
        ItemStack itemNetherQuartz = new ItemStack(Items.field_151128_bU);
        DecomposerRecipe.add(new DecomposerRecipe(itemNetherQuartz, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.galliumarsenide, 1)));
        ItemStack itemRecord13 = new ItemStack(Items.field_151096_cd);
        ItemStack itemRecordCat = new ItemStack(Items.field_151093_ce);
        ItemStack itemRecordFar = new ItemStack(Items.field_151092_ch);
        ItemStack itemRecordMall = new ItemStack(Items.field_151089_ci);
        ItemStack itemRecordMellohi = new ItemStack(Items.field_151090_cj);
        ItemStack itemRecordStal = new ItemStack(Items.field_151087_ck);
        ItemStack itemRecordStrad = new ItemStack(Items.field_151088_cl);
        ItemStack itemRecordWard = new ItemStack(Items.field_151085_cm);
        ItemStack itemRecordChirp = new ItemStack(Items.field_151091_cg);
        ItemStack itemRecord11 = new ItemStack(Items.field_151086_cn);
        ItemStack itemRecordWait = new ItemStack(Items.field_151084_co);
        ItemStack itemRecordBlocks = new ItemStack(Items.field_151094_cf);
        DecomposerRecipe.add(new DecomposerRecipe(itemRecord13, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordCat, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordFar, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordMall, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordMellohi, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordStal, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordStrad, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordWard, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordChirp, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecord11, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordWait, moleculePolyvinylChloride, moleculePolyvinylChloride));
        DecomposerRecipe.add(new DecomposerRecipe(itemRecordBlocks, moleculePolyvinylChloride, moleculePolyvinylChloride));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecord13, true, COST_GEM, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordCat, true, COST_GEM, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordFar, true, COST_GEM, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordMall, true, COST_GEM, null, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordMellohi, true, COST_GEM, null, null, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordStal, true, COST_GEM, null, null, null, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordStrad, true, COST_GEM, null, null, null, null, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordWard, true, COST_GEM, null, null, null, null, null, null, null, moleculePolyvinylChloride, moleculePolyvinylChloride));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordChirp, true, COST_GEM, moleculePolyvinylChloride, null, null, null, null, null, null, null, moleculePolyvinylChloride));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecord11, true, COST_GEM, moleculePolyvinylChloride, null, null, null, moleculePolyvinylChloride, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordWait, true, COST_GEM, moleculePolyvinylChloride, null, null, moleculePolyvinylChloride, null, null, null, null, null));
        SynthesisRecipe.add(new SynthesisRecipe(itemRecordBlocks, true, COST_GEM, moleculePolyvinylChloride, null, null, null, null, moleculePolyvinylChloride, null, null, null));
        ItemStack bars = new ItemStack(Blocks.field_150411_aY);
        DecomposerRecipe.add(new DecomposerRecipe(bars, this.element(ElementEnum.Fe, 3), this.element(ElementEnum.Fe, 3)));
        SynthesisRecipe.add(new SynthesisRecipe(bars, false, COST_BLOCK, this.element(ElementEnum.Fe, 3), this.element(ElementEnum.Fe, 3)));
        DecomposerRecipe.createAndAddRecipeSafely("oreUranium", new Element(ElementEnum.U, 48));
    }

    public void RegisterModRecipes() {
        Item alloy;
        DecomposerRecipe.createAndAddRecipeSafely("dustSalt", new Element(ElementEnum.Na), new Element(ElementEnum.Cl));
        DecomposerRecipe.createAndAddRecipeSafely("logWood", new Molecule(MoleculeEnum.cellulose, 8));
        DecomposerRecipe.createAndAddRecipeSafely("plankWood", new Molecule(MoleculeEnum.cellulose, 2));
        DecomposerRecipe.createAndAddRecipeSafely("ingotIron", this.element(ElementEnum.Fe, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotGold", this.element(ElementEnum.Au, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotCopper", this.element(ElementEnum.Cu, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotTin", this.element(ElementEnum.Sn, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotSilver", this.element(ElementEnum.Ag, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotLead", this.element(ElementEnum.Pb, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotPlatinum", this.element(ElementEnum.Pt, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotAluminium", this.element(ElementEnum.Al, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotMagnesium", this.element(ElementEnum.Mg, 16));
        DecomposerRecipe.createAndAddRecipeSafely("ingotSteel", this.element(ElementEnum.Fe, 15), this.element(ElementEnum.C, 1));
        DecomposerRecipe.createAndAddRecipeSafely("ingotHSLA", this.element(ElementEnum.Fe, 15), this.element(ElementEnum.C, 1));
        DecomposerRecipe.createAndAddRecipeSafely("ingotBronze", this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Sn, 4));
        DecomposerRecipe.createAndAddRecipeSafely("ingotElectrum", this.element(ElementEnum.Ag, 8), this.element(ElementEnum.Au, 8));
        DecomposerRecipe.createAndAddRecipeSafely("ingotInvar", this.element(ElementEnum.Fe, 10), this.element(ElementEnum.Ni, 6));
        SynthesisRecipe.createAndAddRecipeSafely("ingotIron", false, COST_INGOT, this.element(ElementEnum.Fe, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotGold", false, COST_INGOT, this.element(ElementEnum.Au, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotCopper", false, COST_INGOT, this.element(ElementEnum.Cu, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotTin", false, COST_INGOT, this.element(ElementEnum.Sn, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotSilver", false, COST_INGOT, this.element(ElementEnum.Ag, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotLead", false, COST_INGOT, this.element(ElementEnum.Pb, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotPlatinum", false, COST_INGOT, this.element(ElementEnum.Pt, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotAluminium", false, COST_INGOT, this.element(ElementEnum.Al, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotMagnesium", false, COST_INGOT, this.element(ElementEnum.Mg, 16));
        SynthesisRecipe.createAndAddRecipeSafely("ingotSteel", false, COST_INGOT, this.element(ElementEnum.Fe, 15), this.element(ElementEnum.C, 1));
        SynthesisRecipe.createAndAddRecipeSafely("ingotHSLA", false, COST_INGOT, this.element(ElementEnum.Fe, 15), this.element(ElementEnum.C, 1));
        SynthesisRecipe.createAndAddRecipeSafely("ingotBronze", false, COST_INGOT, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Sn, 4));
        SynthesisRecipe.createAndAddRecipeSafely("ingotElectrum", false, COST_INGOT, this.element(ElementEnum.Ag, 8), this.element(ElementEnum.Au, 8));
        SynthesisRecipe.createAndAddRecipeSafely("ingotInvar", false, COST_INGOT, this.element(ElementEnum.Fe, 10), this.element(ElementEnum.Ni, 6));
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            Block rockwool = GameRegistry.findBlock((String)"ThermalExpansion", (String)"Rockwool");
            ItemStack blockRockWool = new ItemStack(rockwool, 1, 0);
            ItemStack blockRockOrangeWool = new ItemStack(rockwool, 1, 1);
            ItemStack blockRockMagentaWool = new ItemStack(rockwool, 1, 2);
            ItemStack blockRockLightBlueWool = new ItemStack(rockwool, 1, 3);
            ItemStack blockRockYellowWool = new ItemStack(rockwool, 1, 4);
            ItemStack blockRockLimeWool = new ItemStack(rockwool, 1, 5);
            ItemStack blockRockPinkWool = new ItemStack(rockwool, 1, 6);
            ItemStack blockRockGrayWool = new ItemStack(rockwool, 1, 7);
            ItemStack blockRockLightGrayWool = new ItemStack(rockwool, 1, 8);
            ItemStack blockRockCyanWool = new ItemStack(rockwool, 1, 9);
            ItemStack blockRockPurpleWool = new ItemStack(rockwool, 1, 10);
            ItemStack blockRockBlueWool = new ItemStack(rockwool, 1, 11);
            ItemStack blockRockBrownWool = new ItemStack(rockwool, 1, 12);
            ItemStack blockRockGreenWool = new ItemStack(rockwool, 1, 13);
            ItemStack blockRockRedWool = new ItemStack(rockwool, 1, 14);
            ItemStack blockRockBlackWool = new ItemStack(rockwool, 1, 15);
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockOrangeWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.orangePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockMagentaWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockLightBlueWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockYellowWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.yellowPigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockLimeWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.limePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockPinkWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockGrayWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockLightGrayWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockCyanWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockPurpleWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.purplePigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockBlueWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lazurite)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockBrownWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.tannicacid)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockGreenWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.greenPigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockRedWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.redPigment)));
            DecomposerRecipe.add(new DecomposerRecipeChance(blockRockBlackWool, 0.2f, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.blackPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockOrangeWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.orangePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockMagentaWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.redPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockLightBlueWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockYellowWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.yellowPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockLimeWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.limePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockPinkWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.redPigment), this.molecule(MoleculeEnum.whitePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockGrayWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment, 2)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockLightGrayWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.whitePigment), this.molecule(MoleculeEnum.blackPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockCyanWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lightbluePigment), this.molecule(MoleculeEnum.whitePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockPurpleWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.purplePigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockBlueWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.lazurite)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockGreenWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.greenPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockRedWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.redPigment)));
            SynthesisRecipe.add(new SynthesisRecipe(blockRockBlackWool, false, COST_WOOL, this.molecule(MoleculeEnum.asbestos, 2), this.molecule(MoleculeEnum.blackPigment)));
            Block glass = GameRegistry.findBlock((String)"ThermalExpansion", (String)"Glass");
            Block frame = GameRegistry.findBlock((String)"ThermalExpansion", (String)"Frame");
            Block light = GameRegistry.findBlock((String)"ThermalExpansion", (String)"Light");
            ItemStack glassStack = new ItemStack(glass);
            ItemStack lightFrameStack = new ItemStack(frame, 1, 9);
            ItemStack lightStack = new ItemStack(light);
            DecomposerRecipe.add(new DecomposerRecipe(glassStack, this.molecule(MoleculeEnum.magnesiumOxide, 8), this.molecule(MoleculeEnum.siliconOxide, 16), this.element(ElementEnum.Pb, 8)));
            DecomposerRecipe.add(new DecomposerRecipe(lightFrameStack, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.galliumarsenide, 1), this.molecule(MoleculeEnum.magnesiumOxide, 16), this.molecule(MoleculeEnum.siliconOxide, 32), this.element(ElementEnum.Pb, 16), this.element(ElementEnum.Cu, 16)));
            DecomposerRecipe.add(new DecomposerRecipe(lightStack, this.molecule(MoleculeEnum.siliconDioxide, 4), this.molecule(MoleculeEnum.galliumarsenide, 1), this.molecule(MoleculeEnum.magnesiumOxide, 16), this.molecule(MoleculeEnum.siliconOxide, 32), this.element(ElementEnum.Pb, 16), this.element(ElementEnum.Cu, 16), this.element(ElementEnum.P, 4)));
        }
        if (Loader.isModLoaded((String)"ThermalFoundation")) {
            Item bucket = GameRegistry.findItem((String)"ThermalFoundation", (String)"bucket");
            Item material = GameRegistry.findItem((String)"ThermalFoundation", (String)"material");
            ItemStack redstoneBucket = new ItemStack(bucket, 1, 0);
            ItemStack glowstoneBucket = new ItemStack(bucket, 1, 1);
            ItemStack enderBucket = new ItemStack(bucket, 1, 2);
            ItemStack signalumBlend = new ItemStack(material, 1, 42);
            ItemStack lumiumBlend = new ItemStack(material, 1, 43);
            ItemStack enderiumBlend = new ItemStack(material, 1, 44);
            ItemStack signalumIngot = new ItemStack(material, 1, 74);
            ItemStack lumiumIngot = new ItemStack(material, 1, 75);
            ItemStack enderiumIngot = new ItemStack(material, 1, 76);
            DecomposerRecipe.add(new DecomposerRecipe(redstoneBucket, this.element(ElementEnum.Cu, 4), this.element(ElementEnum.Fe, 48), this.molecule(MoleculeEnum.iron3oxide, 4)));
            DecomposerRecipe.add(new DecomposerRecipe(enderBucket, this.element(ElementEnum.Fe, 48), this.element(ElementEnum.Es, 4), this.molecule(MoleculeEnum.calciumCarbonate, 32)));
            DecomposerRecipe.add(new DecomposerRecipe(glowstoneBucket, this.element(ElementEnum.Fe, 48), this.element(ElementEnum.P, 4)));
            DecomposerRecipe.add(new DecomposerRecipe(signalumBlend, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Ag, 4), this.molecule(MoleculeEnum.iron3oxide)));
            DecomposerRecipe.add(new DecomposerRecipe(signalumIngot, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Ag, 4), this.molecule(MoleculeEnum.iron3oxide)));
            DecomposerRecipe.add(new DecomposerRecipe(lumiumBlend, this.element(ElementEnum.Sn, 12), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.P)));
            DecomposerRecipe.add(new DecomposerRecipe(lumiumIngot, this.element(ElementEnum.Sn, 12), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.P)));
            DecomposerRecipe.add(new DecomposerRecipe(enderiumBlend, this.element(ElementEnum.Sn, 8), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.Pt, 4), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 8)));
            DecomposerRecipe.add(new DecomposerRecipe(enderiumIngot, this.element(ElementEnum.Sn, 8), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.Pt, 4), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 8)));
            SynthesisRecipe.add(new SynthesisRecipe(signalumBlend, false, COST_INGOT, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Ag, 4), this.molecule(MoleculeEnum.iron3oxide)));
            SynthesisRecipe.add(new SynthesisRecipe(signalumIngot, false, COST_INGOT, this.element(ElementEnum.Cu, 12), this.element(ElementEnum.Ag, 4), this.molecule(MoleculeEnum.iron3oxide)));
            SynthesisRecipe.add(new SynthesisRecipe(lumiumBlend, false, COST_INGOT, this.element(ElementEnum.Sn, 12), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.P)));
            SynthesisRecipe.add(new SynthesisRecipe(lumiumIngot, false, COST_INGOT, this.element(ElementEnum.Sn, 12), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.P)));
            SynthesisRecipe.add(new SynthesisRecipe(enderiumBlend, false, COST_INGOT, this.element(ElementEnum.Sn, 8), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.Pt, 4), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 8)));
            SynthesisRecipe.add(new SynthesisRecipe(enderiumIngot, false, COST_INGOT * 2, this.element(ElementEnum.Sn, 8), this.element(ElementEnum.Ag, 4), this.element(ElementEnum.Pt, 4), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 8), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Pu), this.element(ElementEnum.C, 8), this.element(ElementEnum.S, 16)));
        }
        if (Loader.isModLoaded((String)"RedstoneArsenal")) {
            alloy = GameRegistry.findItem((String)"RedstoneArsenal", (String)"material");
            ItemStack blend = new ItemStack(alloy, 1, 0);
            ItemStack ingot = new ItemStack(alloy, 1, 32);
            ItemStack nugget = new ItemStack(alloy, 1, 64);
            ItemStack gem = new ItemStack(alloy, 1, 96);
            DecomposerRecipe.add(new DecomposerRecipe(blend, this.element(ElementEnum.Au, 8), this.element(ElementEnum.Ag, 8), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            DecomposerRecipe.add(new DecomposerRecipe(ingot, this.element(ElementEnum.Au, 8), this.element(ElementEnum.Ag, 8), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            DecomposerRecipe.add(new DecomposerRecipeSelect(nugget, 0.11f, new DecomposerRecipe(this.element(ElementEnum.Au, 8), this.element(ElementEnum.Ag, 8), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu))));
            DecomposerRecipe.add(new DecomposerRecipe(gem, this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            SynthesisRecipe.add(new SynthesisRecipe(blend, false, COST_INGOT * 2, this.element(ElementEnum.Au, 8), this.element(ElementEnum.Ag, 8), this.molecule(MoleculeEnum.iron3oxide, 2), this.element(ElementEnum.Cu, 2)));
            SynthesisRecipe.add(new SynthesisRecipe(ingot, false, COST_INGOT * 2, this.element(ElementEnum.Au, 8), this.element(ElementEnum.Ag, 8), this.molecule(MoleculeEnum.iron3oxide, 2), this.element(ElementEnum.Cu, 2)));
            SynthesisRecipe.add(new SynthesisRecipe(gem, false, COST_INGOT * 2, this.molecule(MoleculeEnum.fullrene, 3), this.molecule(MoleculeEnum.iron3oxide, 2), this.element(ElementEnum.Cu, 2)));
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            alloy = GameRegistry.findItem((String)"EnderIO", (String)"itemAlloy");
            ItemStack electricalSteel = new ItemStack(alloy, 1, 0);
            ItemStack energeticAlloy = new ItemStack(alloy, 1, 1);
            ItemStack vibrantAlloy = new ItemStack(alloy, 1, 2);
            ItemStack redstoneAlloy = new ItemStack(alloy, 1, 3);
            ItemStack conductiveIron = new ItemStack(alloy, 1, 4);
            ItemStack pulsatingIron = new ItemStack(alloy, 1, 5);
            ItemStack darkSteel = new ItemStack(alloy, 1, 6);
            ItemStack soularium = new ItemStack(alloy, 1, 7);
            DecomposerRecipe.add(new DecomposerRecipe(electricalSteel, this.element(ElementEnum.Fe, 8), this.element(ElementEnum.C, 4), this.element(ElementEnum.Si, 4)));
            DecomposerRecipe.add(new DecomposerRecipe(energeticAlloy, this.element(ElementEnum.Au, 8), this.element(ElementEnum.P, 1), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            DecomposerRecipe.add(new DecomposerRecipe(vibrantAlloy, this.element(ElementEnum.Au, 8), this.element(ElementEnum.P, 1), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 4)));
            DecomposerRecipe.add(new DecomposerRecipe(redstoneAlloy, this.element(ElementEnum.Si, 12), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            DecomposerRecipe.add(new DecomposerRecipe(conductiveIron, this.element(ElementEnum.Fe, 12), this.molecule(MoleculeEnum.iron3oxide), this.element(ElementEnum.Cu)));
            DecomposerRecipe.add(new DecomposerRecipe(pulsatingIron, this.element(ElementEnum.Fe, 12), this.element(ElementEnum.Es), this.molecule(MoleculeEnum.calciumCarbonate, 6)));
            DecomposerRecipe.add(new DecomposerRecipe(darkSteel, this.molecule(MoleculeEnum.magnesiumOxide, 4), this.molecule(MoleculeEnum.siliconOxide, 8), this.element(ElementEnum.Fe, 8), this.element(ElementEnum.C, 4)));
            DecomposerRecipe.add(new DecomposerRecipeSelect(soularium, 0.4f, new DecomposerRecipe(this.element(ElementEnum.Pb, 3), this.element(ElementEnum.Be, 1), this.element(ElementEnum.Si, 2), this.element(ElementEnum.O), this.element(ElementEnum.Au, 8)), new DecomposerRecipe(this.element(ElementEnum.Pb, 1), this.element(ElementEnum.Si, 5), this.element(ElementEnum.O, 2), this.element(ElementEnum.Au, 8)), new DecomposerRecipe(this.element(ElementEnum.Si, 2), this.element(ElementEnum.O), this.element(ElementEnum.Au, 8)), new DecomposerRecipe(this.element(ElementEnum.Si, 6), this.element(ElementEnum.O, 2), this.element(ElementEnum.Au, 8)), new DecomposerRecipe(this.element(ElementEnum.Es, 1), this.element(ElementEnum.O, 2), this.element(ElementEnum.Au, 8))));
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            MoleculeEnum certusQuartzMolecule = MoleculeEnum.aluminiumPhosphate;
            MoleculeEnum chargedCertusQuartzMolecule = MoleculeEnum.aluminiumHypophosphite;
            Molecule chargedCertusQuartzChemical = new Molecule(chargedCertusQuartzMolecule);
            PotionChemical[] chargedCertusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(chargedCertusQuartzMolecule, 4)};
            PotionChemical[] chargedCertusQuartzCrystalSynthesisFormula = new PotionChemical[]{null, chargedCertusQuartzChemical, null, chargedCertusQuartzChemical, null, chargedCertusQuartzChemical, null, chargedCertusQuartzChemical, null};
            PotionChemical[] quartzGlassDecompositionFormula = new PotionChemical[]{new Molecule(certusQuartzMolecule, 5), new Molecule(MoleculeEnum.siliconDioxide, 16)};
            PotionChemical[] quartzGlassCrystalSynthesisFormula = new PotionChemical[]{new Molecule(certusQuartzMolecule), new Molecule(MoleculeEnum.siliconDioxide, 4), new Molecule(certusQuartzMolecule), new Molecule(MoleculeEnum.siliconDioxide, 4), new Molecule(certusQuartzMolecule), new Molecule(MoleculeEnum.siliconDioxide, 4), new Molecule(certusQuartzMolecule), new Molecule(MoleculeEnum.siliconDioxide, 4), new Molecule(certusQuartzMolecule)};
            Item item = GameRegistry.findItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial");
            Block skyStone = GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockSkyStone");
            Block quartzGlass = GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockQuartzGlass");
            ItemStack charged = new ItemStack(item, 1, 1);
            ItemStack singularity = new ItemStack(item, 1, 47);
            ItemStack skystone = new ItemStack(skyStone);
            ItemStack quartzglass = new ItemStack(quartzGlass);
            DecomposerRecipe.add(new DecomposerRecipe(charged, chargedCertusQuartzDecompositionFormula));
            SynthesisRecipe.add(new SynthesisRecipe(charged, true, 30000, chargedCertusQuartzCrystalSynthesisFormula));
            DecomposerRecipe.add(new DecomposerRecipe(singularity, this.element(ElementEnum.Fm, 148), this.element(ElementEnum.Md, 142), this.element(ElementEnum.No, 133), this.element(ElementEnum.Lr, 124), this.element(ElementEnum.Rf, 107), this.element(ElementEnum.Db, 104), this.element(ElementEnum.Sg, 93), this.element(ElementEnum.Bh, 81), this.element(ElementEnum.Hs, 67), this.element(ElementEnum.Mt, 54), this.element(ElementEnum.Ds, 52), this.element(ElementEnum.Rg, 37), this.element(ElementEnum.Cn, 33), this.element(ElementEnum.Uut, 22)));
            DecomposerRecipe.add(new DecomposerRecipeSelect(skystone, 0.9f, new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.He)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.Xe)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.Ar)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.He)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.Ne)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.He)), new DecomposerRecipe(this.element(ElementEnum.Al), this.element(ElementEnum.He)), new DecomposerRecipe(this.element(ElementEnum.Si), this.element(ElementEnum.Xe)), new DecomposerRecipe(this.element(ElementEnum.Fe), this.element(ElementEnum.Ar)), new DecomposerRecipe(this.element(ElementEnum.Mg), this.element(ElementEnum.Kr)), new DecomposerRecipe(this.element(ElementEnum.Ti), this.element(ElementEnum.Ne)), new DecomposerRecipe(this.element(ElementEnum.Pb), this.element(ElementEnum.Rn)), new DecomposerRecipe(this.element(ElementEnum.Zn), this.element(ElementEnum.Ne)), new DecomposerRecipe(this.element(ElementEnum.Al), this.element(ElementEnum.Ar))));
            DecomposerRecipe.add(new DecomposerRecipe(quartzglass, quartzGlassDecompositionFormula));
            SynthesisRecipe.add(new SynthesisRecipe(quartzglass, true, 30000, quartzGlassCrystalSynthesisFormula));
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            Block metalPost = GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.post.metal");
            Block metalPlatform = GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.post.metal.platform");
            Block post = GameRegistry.findBlock((String)"Railcraft", (String)"tile.railcraft.post");
            DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(metalPost), this.element(ElementEnum.Fe, 5)));
            DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(metalPlatform), this.element(ElementEnum.Fe, 5)));
            DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(post), new PotionChemical[0]));
        }
    }

    public void RegisterRecipes() {
        this.registerVanillaChemicalRecipes();
        ItemStack blockGlass = new ItemStack(Blocks.field_150359_w);
        ItemStack blockThinGlass = new ItemStack(Blocks.field_150410_aZ);
        ItemStack blockIron = new ItemStack(Blocks.field_150339_S);
        ItemStack itemIngotIron = new ItemStack(Items.field_151042_j);
        ItemStack itemRedstone = new ItemStack(Items.field_151137_ax);
        ItemStack minechemItemsAtomicManipulator = new ItemStack((Item)MinechemItemsRegistration.atomicManipulator);
        ItemStack moleculePolyvinylChloride = new ItemStack((Item)MinechemItemsRegistration.molecule, 1, MoleculeEnum.polyvinylChloride.id());
        GameRegistry.addRecipe((ItemStack)MinechemItemsRegistration.concaveLens, (Object[])new Object[]{"G G", "GGG", "G G", Character.valueOf('G'), blockGlass});
        GameRegistry.addRecipe((ItemStack)MinechemItemsRegistration.convexLens, (Object[])new Object[]{" G ", "GGG", " G ", Character.valueOf('G'), blockGlass});
        GameRegistry.addRecipe((ItemStack)MinechemItemsRegistration.microscopeLens, (Object[])new Object[]{"A", "B", "A", Character.valueOf('A'), MinechemItemsRegistration.convexLens, Character.valueOf('B'), MinechemItemsRegistration.concaveLens});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.microscope), (Object[])new Object[]{" LI", " PI", "III", Character.valueOf('L'), MinechemItemsRegistration.microscopeLens, Character.valueOf('P'), blockThinGlass, Character.valueOf('I'), itemIngotIron});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.microscope), (Object[])new Object[]{" LI", " PI", "III", Character.valueOf('L'), MinechemItemsRegistration.microscopeLens, Character.valueOf('P'), blockThinGlass, Character.valueOf('I'), itemIngotIron});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)MinechemItemsRegistration.atomicManipulator), (Object[])new Object[]{"PPP", "PIP", "PPP", Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('I'), blockIron});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.decomposer), (Object[])new Object[]{"III", "IAI", "IRI", Character.valueOf('A'), minechemItemsAtomicManipulator, Character.valueOf('I'), itemIngotIron, Character.valueOf('R'), itemRedstone});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.synthesis), (Object[])new Object[]{"IRI", "IAI", "IDI", Character.valueOf('A'), minechemItemsAtomicManipulator, Character.valueOf('I'), itemIngotIron, Character.valueOf('R'), itemRedstone, Character.valueOf('D'), new ItemStack(Items.field_151045_i)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.fusion, 16, 0), (Object[])new Object[]{"ILI", "ILI", "ILI", Character.valueOf('I'), itemIngotIron, Character.valueOf('L'), ElementItem.createStackOf(ElementEnum.Pb, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.fusion, 16, 1), (Object[])new Object[]{"IWI", "IBI", "IWI", Character.valueOf('I'), itemIngotIron, Character.valueOf('W'), ElementItem.createStackOf(ElementEnum.W, 1), Character.valueOf('B'), ElementItem.createStackOf(ElementEnum.Be, 1)});
        GameRegistry.addRecipe((ItemStack)MinechemItemsRegistration.projectorLens, (Object[])new Object[]{"ABA", Character.valueOf('A'), MinechemItemsRegistration.concaveLens, Character.valueOf('B'), MinechemItemsRegistration.convexLens});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.blueprintProjector), (Object[])new Object[]{" I ", "GPL", " I ", Character.valueOf('I'), itemIngotIron, Character.valueOf('P'), blockThinGlass, Character.valueOf('L'), MinechemItemsRegistration.projectorLens, Character.valueOf('G'), new ItemStack(Blocks.field_150379_bu)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(MinechemBlocksGeneration.leadChest), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), new ItemStack((Item)MinechemItemsRegistration.element, 1, ElementEnum.Pb.atomicNumber()), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)MinechemItemsRegistration.journal), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack(Blocks.field_150359_w)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemBlueprint.createItemStackFromBlueprint(MinechemBlueprint.fusion), (Object[])new Object[]{new ItemStack(Items.field_151121_aF), new ItemStack(Blocks.field_150484_ah)});
        GameRegistry.addShapelessRecipe((ItemStack)ItemBlueprint.createItemStackFromBlueprint(MinechemBlueprint.fission), (Object[])new Object[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151045_i)});
        GameRegistry.addRecipe((ItemStack)MinechemItemsRegistration.emptyTube, (Object[])new Object[]{"   ", "P P", " P ", Character.valueOf('P'), blockThinGlass});
        GameRegistry.addRecipe((IRecipe)new ChemistJournalRecipeCloning());
        this.addDecomposerRecipesFromMolecules();
        this.addSynthesisRecipesFromMolecules();
        this.addUnusedSynthesisRecipes();
    }

    private void addDecomposerRecipesFromMolecules() {
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            ItemStack itemStack = new ItemStack((Item)MinechemItemsRegistration.molecule, 1, molecule.id());
            DecomposerRecipe.add(new DecomposerRecipe(itemStack, molecule.components()));
        }
    }

    private void addSynthesisRecipesFromMolecules() {
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            ItemStack moleculeItemStack = new ItemStack((Item)MinechemItemsRegistration.molecule, 1, molecule.id());
            SynthesisRecipe.add(new SynthesisRecipe(moleculeItemStack, false, COST_ITEM, molecule.components()));
        }
    }

    private void addUnusedSynthesisRecipes() {
        for (DecomposerRecipe nextDecomposerRecipe : DecomposerRecipe.recipes.values()) {
            ArrayList<PotionChemical> rawDecomposerRecipe;
            if (nextDecomposerRecipe.getInput().func_77960_j() == -1) continue;
            boolean check = false;
            for (SynthesisRecipe nextSynthesisRecipe : SynthesisRecipe.recipes.values()) {
                if (!Compare.stacksAreSameKind(nextSynthesisRecipe.getOutput(), nextDecomposerRecipe.getInput())) continue;
                check = true;
                break;
            }
            if (check || (rawDecomposerRecipe = nextDecomposerRecipe.getOutputRaw()) == null || !this.shouldCreateSynthesis(nextDecomposerRecipe.getInput())) continue;
            SynthesisRecipe.add(new SynthesisRecipe(nextDecomposerRecipe.getInput(), false, 100, rawDecomposerRecipe));
        }
    }

    public boolean shouldCreateSynthesis(ItemStack item) {
        if (item.func_77973_b() == Items.field_151055_y) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            return this.shouldCreateSynthesis((ItemBlock)item.func_77973_b());
        }
        return true;
    }

    public boolean shouldCreateSynthesis(ItemBlock block) {
        return !(block.field_150939_a instanceof BlockOre);
    }

    public static ArrayList<OreDictionaryHandler> getOreDictionaryHandlers() {
        return MinechemRecipes.recipes.oreDictionaryHandlers;
    }

    public void registerOreDictOres() {
        this.RegisterHandlers();
        for (String oreName : OreDictionary.getOreNames()) {
            this.registerOre(oreName);
        }
        MinecraftForge.EVENT_BUS.register((Object)new OreEventHandler());
    }

    public void registerOre(String oreName) {
        if (oreName.contains("gemApatite")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Ca, 5), this.molecule(MoleculeEnum.phosphate, 4), this.element(ElementEnum.Cl));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.element(ElementEnum.Ca, 5), this.molecule(MoleculeEnum.phosphate, 4), this.element(ElementEnum.Cl));
        } else if (oreName.contains("plateSilicon")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Si, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.element(ElementEnum.Si, 2));
        } else if (oreName.contains("xychoriumBlue")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Cu, 1));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 300, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Cu, 1));
        } else if (oreName.contains("xychoriumRed")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Fe, 1));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 300, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Fe, 1));
        } else if (oreName.contains("xychoriumGreen")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.V, 1));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 300, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.V, 1));
        } else if (oreName.contains("xychoriumDark")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Si, 1));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 300, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Si, 1));
        } else if (oreName.contains("xychoriumLight")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Ti, 1));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 300, this.element(ElementEnum.Zr, 2), this.element(ElementEnum.Ti, 1));
        } else if (oreName.contains("gemPeridot")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.olivine));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.olivine));
        } else if (oreName.contains("cropMaloberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.xylitol), this.molecule(MoleculeEnum.sucrose));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.xylitol), this.molecule(MoleculeEnum.sucrose));
        } else if (oreName.contains("cropDuskberry")) {
            if (Settings.recreationalChemicalEffects) {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.psilocybin), this.element(ElementEnum.S, 2));
                SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.psilocybin), this.element(ElementEnum.S, 2));
            }
        } else if (oreName.contains("cropSkyberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.theobromine), this.element(ElementEnum.S, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.theobromine), this.element(ElementEnum.S, 2));
        } else if (oreName.contains("cropBlightberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.asprin), this.element(ElementEnum.S, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.asprin), this.element(ElementEnum.S, 2));
        } else if (oreName.contains("cropBlueberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.blueorgodye), this.molecule(MoleculeEnum.sucrose, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.blueorgodye), this.molecule(MoleculeEnum.sucrose, 2));
        } else if (oreName.contains("cropRaspberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.redorgodye), this.molecule(MoleculeEnum.sucrose, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.redorgodye), this.molecule(MoleculeEnum.sucrose, 2));
        } else if (oreName.contains("cropBlackberry")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.molecule(MoleculeEnum.purpleorgodye), this.molecule(MoleculeEnum.sucrose, 2));
            SynthesisRecipe.createAndAddRecipeSafely(oreName, false, 1000, this.molecule(MoleculeEnum.purpleorgodye), this.molecule(MoleculeEnum.sucrose, 2));
        } else {
            for (OreDictionaryHandler handler : this.oreDictionaryHandlers) {
                if (!handler.canHandle(oreName)) continue;
                handler.handle(oreName);
                return;
            }
        }
    }

    private Element element(ElementEnum var1, int var2) {
        return new Element(var1, var2);
    }

    private Element element(ElementEnum var1) {
        return new Element(var1, 1);
    }

    private Molecule molecule(MoleculeEnum var1, int var2) {
        return new Molecule(var1, var2);
    }

    private Molecule molecule(MoleculeEnum var1) {
        return new Molecule(var1, 1);
    }

    public void RegisterHandlers() {
        this.oreDictionaryHandlers = new ArrayList();
        if (Loader.isModLoaded((String)"Mekanism")) {
            this.oreDictionaryHandlers.add(new OreDictionaryMekanismHandler());
        }
        if (Loader.isModLoaded((String)"UndergroundBiomes")) {
            this.oreDictionaryHandlers.add(new OreDictionaryUndergroundBiomesHandler());
        }
        if (Loader.isModLoaded((String)"gregtech_addon")) {
            this.oreDictionaryHandlers.add(new OreDictionaryGregTechHandler());
        }
        if (Loader.isModLoaded((String)"IC2")) {
            this.oreDictionaryHandlers.add(new OreDictionaryIC2Handler());
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.oreDictionaryHandlers.add(new OreDictionaryAppliedEnergisticsHandler());
        }
        this.oreDictionaryHandlers.add(new OreDictionaryDefaultHandler());
    }
}

