/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.element;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import minechem.fluid.FluidHelper;
import minechem.item.ChemicalRoomStateEnum;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementClassificationEnum;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;

public class ElementEnum
extends MinechemChemicalType {
    public static int heaviestMass = 0;
    public static Map<Integer, ElementEnum> elements = new Hashtable<Integer, ElementEnum>();
    public static Map<String, ElementEnum> nameToElements = new HashMap<String, ElementEnum>();
    public static final ElementEnum H = ElementEnum.addElement(1, "H", "Hydrogen", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum He = ElementEnum.addElement(2, "He", "Helium", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Li = ElementEnum.addElement(3, "Li", "Lithium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Be = ElementEnum.addElement(4, "Be", "Beryllium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum B = ElementEnum.addElement(5, "B", "Boron", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum C = ElementEnum.addElement(6, "C", "Carbon", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum N = ElementEnum.addElement(7, "N", "Nitrogen", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum O = ElementEnum.addElement(8, "O", "Oxygen", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum F = ElementEnum.addElement(9, "F", "Fluorine", ElementClassificationEnum.halogen, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Ne = ElementEnum.addElement(10, "Ne", "Neon", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Na = ElementEnum.addElement(11, "Na", "Sodium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Mg = ElementEnum.addElement(12, "Mg", "Magnesium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Al = ElementEnum.addElement(13, "Al", "Aluminium", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Si = ElementEnum.addElement(14, "Si", "Silicon", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum P = ElementEnum.addElement(15, "P", "Phosphorus", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum S = ElementEnum.addElement(16, "S", "Sulfur", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Cl = ElementEnum.addElement(17, "Cl", "Chlorine", ElementClassificationEnum.halogen, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Ar = ElementEnum.addElement(18, "Ar", "Argon", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum K = ElementEnum.addElement(19, "K", "Potassium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ca = ElementEnum.addElement(20, "Ca", "Calcium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Sc = ElementEnum.addElement(21, "Sc", "Scandium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ti = ElementEnum.addElement(22, "Ti", "Titanium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum V = ElementEnum.addElement(23, "V", "Vanadium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Cr = ElementEnum.addElement(24, "Cr", "Chromium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Mn = ElementEnum.addElement(25, "Mn", "Manganese", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Fe = ElementEnum.addElement(26, "Fe", "Iron", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Co = ElementEnum.addElement(27, "Co", "Cobalt", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ni = ElementEnum.addElement(28, "Ni", "Nickel", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Cu = ElementEnum.addElement(29, "Cu", "Copper", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Zn = ElementEnum.addElement(30, "Zn", "Zinc", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ga = ElementEnum.addElement(31, "Ga", "Gallium", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ge = ElementEnum.addElement(32, "Ge", "Germanium", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum As = ElementEnum.addElement(33, "As", "Arsenic", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Se = ElementEnum.addElement(34, "Se", "Selenium", ElementClassificationEnum.nonmetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Br = ElementEnum.addElement(35, "Br", "Bromine", ElementClassificationEnum.halogen, ChemicalRoomStateEnum.liquid, RadiationEnum.stable);
    public static final ElementEnum Kr = ElementEnum.addElement(36, "Kr", "Krypton", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Rb = ElementEnum.addElement(37, "Rb", "Rubidium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Sr = ElementEnum.addElement(38, "Sr", "Strontium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Y = ElementEnum.addElement(39, "Y", "Yttrium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Zr = ElementEnum.addElement(40, "Zr", "Zirconium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Nb = ElementEnum.addElement(41, "Nb", "Niobium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Mo = ElementEnum.addElement(42, "Mo", "Molybdenum", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Tc = ElementEnum.addElement(43, "Tc", "Technetium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Ru = ElementEnum.addElement(44, "Ru", "Ruthenium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Rh = ElementEnum.addElement(45, "Rh", "Rhodium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Pd = ElementEnum.addElement(46, "Pd", "Palladium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ag = ElementEnum.addElement(47, "Ag", "Silver", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Cd = ElementEnum.addElement(48, "Cd", "Cadmium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum In = ElementEnum.addElement(49, "In", "Indium", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Sn = ElementEnum.addElement(50, "Sn", "Tin", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Sb = ElementEnum.addElement(51, "Sb", "Antimony", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Te = ElementEnum.addElement(52, "Te", "Tellurium", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum I = ElementEnum.addElement(53, "I", "Iodine", ElementClassificationEnum.halogen, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Xe = ElementEnum.addElement(54, "Xe", "Xenon", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.stable);
    public static final ElementEnum Cs = ElementEnum.addElement(55, "Cs", "Caesium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ba = ElementEnum.addElement(56, "Ba", "Barium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum La = ElementEnum.addElement(57, "La", "Lanthanum", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ce = ElementEnum.addElement(58, "Ce", "Cerium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Pr = ElementEnum.addElement(59, "Pr", "Praseodymium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Nd = ElementEnum.addElement(60, "Nd", "Neodymium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Pm = ElementEnum.addElement(61, "Pm", "Promethium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum Sm = ElementEnum.addElement(62, "Sm", "Samarium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Eu = ElementEnum.addElement(63, "Eu", "Europium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Gd = ElementEnum.addElement(64, "Gd", "Gadolinium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Tb = ElementEnum.addElement(65, "Tb", "Terbium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Dy = ElementEnum.addElement(66, "Dy", "Dyprosium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ho = ElementEnum.addElement(67, "Ho", "Holmium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Er = ElementEnum.addElement(68, "Er", "Erbium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Tm = ElementEnum.addElement(69, "Tm", "Thulium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Yb = ElementEnum.addElement(70, "Yb", "Ytterbium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Lu = ElementEnum.addElement(71, "Lu", "Lutetium", ElementClassificationEnum.lanthanide, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Hf = ElementEnum.addElement(72, "Hf", "Hafnium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ta = ElementEnum.addElement(73, "Ta", "Tantalum", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum W = ElementEnum.addElement(74, "W", "Tungsten", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Re = ElementEnum.addElement(75, "Re", "Rhenium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Os = ElementEnum.addElement(76, "Os", "Osmium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Ir = ElementEnum.addElement(77, "Ir", "Iridium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Pt = ElementEnum.addElement(78, "Pt", "Platinum", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Au = ElementEnum.addElement(79, "Au", "Gold", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Hg = ElementEnum.addElement(80, "Hg", "Mercury", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.liquid, RadiationEnum.stable);
    public static final ElementEnum Tl = ElementEnum.addElement(81, "Tl", "Thallium", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Pb = ElementEnum.addElement(82, "Pb", "Lead", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.stable);
    public static final ElementEnum Bi = ElementEnum.addElement(83, "Bi", "Bismuth", ElementClassificationEnum.otherMetal, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Po = ElementEnum.addElement(84, "Po", "Polonium", ElementClassificationEnum.semimetallic, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum At = ElementEnum.addElement(85, "At", "Astantine", ElementClassificationEnum.halogen, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Rn = ElementEnum.addElement(86, "Rn", "Radon", ElementClassificationEnum.inertGas, ChemicalRoomStateEnum.gas, RadiationEnum.radioactive);
    public static final ElementEnum Fr = ElementEnum.addElement(87, "Fr", "Francium", ElementClassificationEnum.alkaliMetal, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Ra = ElementEnum.addElement(88, "Ra", "Radium", ElementClassificationEnum.alkalineEarthMetal, ChemicalRoomStateEnum.solid, RadiationEnum.slightlyRadioactive);
    public static final ElementEnum Ac = ElementEnum.addElement(89, "Ac", "Actinium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum Th = ElementEnum.addElement(90, "Th", "Thorium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Pa = ElementEnum.addElement(91, "Pa", "Protactinium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.slightlyRadioactive);
    public static final ElementEnum U = ElementEnum.addElement(92, "U", "Uranium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Np = ElementEnum.addElement(93, "Np", "Neptunium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Pu = ElementEnum.addElement(94, "Pu", "Plutonium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Am = ElementEnum.addElement(95, "Am", "Americium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.slightlyRadioactive);
    public static final ElementEnum Cm = ElementEnum.addElement(96, "Cm", "Curium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.hardlyRadioactive);
    public static final ElementEnum Bk = ElementEnum.addElement(97, "Bk", "Berkelium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.slightlyRadioactive);
    public static final ElementEnum Cf = ElementEnum.addElement(98, "Cf", "Californium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.slightlyRadioactive);
    public static final ElementEnum Es = ElementEnum.addElement(99, "Es", "Einsteinium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum Fm = ElementEnum.addElement(100, "Fm", "Fermium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum Md = ElementEnum.addElement(101, "Md", "Mendelenium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum No = ElementEnum.addElement(102, "No", "Nobelium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Lr = ElementEnum.addElement(103, "Lr", "Lawrencium", ElementClassificationEnum.actinide, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Rf = ElementEnum.addElement(104, "Rf", "Rutherfordium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Db = ElementEnum.addElement(105, "Db", "Dubnium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.radioactive);
    public static final ElementEnum Sg = ElementEnum.addElement(106, "Sg", "Seaborgium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Bh = ElementEnum.addElement(107, "Bh", "Bohrium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Hs = ElementEnum.addElement(108, "Hs", "Hassium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.highlyRadioactive);
    public static final ElementEnum Mt = ElementEnum.addElement(109, "Mt", "Meitnerium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.extremelyRadioactive);
    public static final ElementEnum Ds = ElementEnum.addElement(110, "Ds", "Darmstadtium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.extremelyRadioactive);
    public static final ElementEnum Rg = ElementEnum.addElement(111, "Rg", "Roenthenium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.extremelyRadioactive);
    public static final ElementEnum Cn = ElementEnum.addElement(112, "Cn", "Copernicium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.extremelyRadioactive);
    public static final ElementEnum Uut = ElementEnum.addElement(113, "Uut", "Ununtrium", ElementClassificationEnum.transitionMetal, ChemicalRoomStateEnum.solid, RadiationEnum.extremelyRadioactive);
    private final String descriptiveName;
    private final String localizationKey;
    private final ElementClassificationEnum classification;
    private final String name;
    private final int id;

    public ElementEnum(int id, String name, String descriptiveName, ElementClassificationEnum classification, ChemicalRoomStateEnum roomState, RadiationEnum radioactivity) {
        super(roomState, radioactivity);
        this.id = id;
        this.name = name;
        this.descriptiveName = MinechemUtil.capitalizeFully(descriptiveName);
        this.localizationKey = "element." + name;
        this.classification = classification;
    }

    public static ElementEnum addElement(int id, String name, String descriptiveName, ElementClassificationEnum classification, ChemicalRoomStateEnum roomState, RadiationEnum radioactivity) {
        ElementEnum element = new ElementEnum(id, name, descriptiveName, classification, roomState, radioactivity);
        ElementEnum.registerElement(element);
        FluidHelper.registerElement(element);
        return element;
    }

    public static ElementEnum addElement(ElementEnum element) {
        ElementEnum.registerElement(element);
        FluidHelper.registerElement(element);
        return element;
    }

    public static void registerElement(ElementEnum element) {
        if (elements.containsKey(element.id)) {
            throw new IllegalArgumentException("id " + element.id + " is used");
        }
        if (nameToElements.containsKey(element.name())) {
            throw new IllegalArgumentException("name" + element.name() + " is used");
        }
        if (element.id >= heaviestMass) {
            heaviestMass = element.id;
        }
        elements.put(element.id, element);
        nameToElements.put(element.name(), element);
    }

    public static void unregisterElement(ElementEnum element) {
        elements.remove(element.id);
        nameToElements.remove(element.name());
    }

    public ElementClassificationEnum classification() {
        return this.classification;
    }

    public int atomicNumber() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String getUnlocalizedName() {
        return this.localizationKey;
    }

    public String getLongName() {
        return this.descriptiveName;
    }

    public static ElementEnum getByID(int atomicNumber) {
        return elements.get(atomicNumber);
    }

    public static ElementEnum getByName(String name) {
        return nameToElements.get(name);
    }

    public static void init() {
    }
}

