/*
 * Decompiled with CFR 0.152.
 */
package minechem.minetweaker;

import java.util.ArrayList;
import java.util.List;
import minechem.item.ChemicalRoomStateEnum;
import minechem.item.element.ElementClassificationEnum;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PharmacologyEffect;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.utils.InputHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.minechem.Chemicals")
public class Chemicals {
    @ZenMethod
    public static void addElement(int id, String name, String descriptiveName, String classification, String roomState, String radioactivity) {
        if (id < 0) {
            throw new IllegalArgumentException(id + " is invalid");
        }
        if (ElementEnum.getByID(id) != null) {
            throw new IllegalArgumentException(id + ": " + name + " is already registered as an element");
        }
        ElementClassificationEnum eClass = InputHelper.getClassification(classification);
        ChemicalRoomStateEnum state = InputHelper.getRoomState(roomState);
        RadiationEnum radiation = InputHelper.getRadiation(radioactivity);
        MineTweakerAPI.apply((IUndoableAction)new AddElementAction(id, name, descriptiveName, eClass, state, radiation));
    }

    @ZenMethod
    public static void addMolecule(String name, int id, String roomState, IIngredient[] chemicals) {
        ChemicalRoomStateEnum state = InputHelper.getRoomState(roomState);
        if (MoleculeEnum.getByName(name) != null || MoleculeEnum.getById(id) != null) {
            throw new IllegalArgumentException(name + " is already registered as a molecule");
        }
        ArrayList<PotionChemical> chem = InputHelper.getChemicals(chemicals);
        PotionChemical[] chemical = chem.toArray(new PotionChemical[chem.size()]);
        MineTweakerAPI.apply((IUndoableAction)new AddMoleculeAction(name, id, state, chemical));
    }

    @ZenMethod
    public static void addCureEffect(IIngredient ingredient) {
        PharmacologyEffect.Cure effect = new PharmacologyEffect.Cure();
        Chemicals.addEffect(ingredient, effect);
    }

    @ZenMethod
    public static void addCureEffect(IIngredient ingredient, String string) {
        PharmacologyEffect.Cure effect = new PharmacologyEffect.Cure(string);
        Chemicals.addEffect(ingredient, effect);
    }

    @ZenMethod
    public static void addDamageEffect(IIngredient ingredient, double damage) {
        PharmacologyEffect.Damage effect = new PharmacologyEffect.Damage((float)damage);
        Chemicals.addEffect(ingredient, effect);
    }

    @ZenMethod
    public static void addFoodEffect(IIngredient ingredient, int level, double saturation) {
        PharmacologyEffect.Food effect = new PharmacologyEffect.Food(level, (float)saturation);
        Chemicals.addEffect(ingredient, effect);
    }

    @ZenMethod
    public static void addBurnEffect(IIngredient ingredient, int time) {
        PharmacologyEffect.Burn effect = new PharmacologyEffect.Burn(time);
        Chemicals.addEffect(ingredient, effect);
    }

    @ZenMethod
    public static void addPotionEffect(IIngredient ingredient, String potion, int time) {
        Chemicals.addPotionEffect(ingredient, potion, time, 0);
    }

    @ZenMethod
    public static void addPotionEffect(IIngredient ingredient, String potion, int time, int level) {
        PharmacologyEffect.Potion effect = new PharmacologyEffect.Potion(potion, level, time);
        Chemicals.addEffect(ingredient, effect);
    }

    private static void addEffect(IIngredient ingredient, PharmacologyEffect effect) {
        PotionChemical chemical = InputHelper.getChemical(ingredient);
        if (!(chemical instanceof Molecule)) {
            throw new IllegalArgumentException("Ingredient is not a molecule");
        }
        MineTweakerAPI.apply((IUndoableAction)new AddMoleculeEffectAction(((Molecule)chemical).molecule, effect));
    }

    @ZenMethod
    public static void removeMoleculeEffects(IIngredient ingredient) {
        PotionChemical chemical = InputHelper.getChemical(ingredient);
        if (!(chemical instanceof Molecule)) {
            throw new IllegalArgumentException("Ingredient is not a molecule");
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveEffectsAction(((Molecule)chemical).molecule));
    }

    private static class RemoveEffectsAction
    implements IUndoableAction {
        private MoleculeEnum molecule;
        private List<PharmacologyEffect> list;

        public RemoveEffectsAction(MoleculeEnum molecule) {
            this.molecule = molecule;
        }

        public void apply() {
            this.list = PharmacologyEffectRegistry.removeEffects(this.molecule);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.list != null && !this.list.isEmpty()) {
                PharmacologyEffectRegistry.addEffects(this.molecule, this.list);
            }
        }

        public String describe() {
            return "Removing effects from " + this.molecule.name();
        }

        public String describeUndo() {
            return "Restoring effects for " + this.molecule.name();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddMoleculeEffectAction
    implements IUndoableAction {
        private PharmacologyEffect effect;
        private MoleculeEnum molecule;

        public AddMoleculeEffectAction(MoleculeEnum molecule, PharmacologyEffect effect) {
            this.molecule = molecule;
            this.effect = effect;
        }

        public void apply() {
            PharmacologyEffectRegistry.addEffect(this.molecule, this.effect);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            PharmacologyEffectRegistry.removeEffect(this.molecule, this.effect);
        }

        public String describe() {
            return "Adding " + this.effect.toString() + " to molecule " + this.molecule.name();
        }

        public String describeUndo() {
            return "Removing " + this.effect.toString() + " to molecule " + this.molecule.name();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddElementAction
    implements IUndoableAction {
        private final ElementEnum element;

        public AddElementAction(int id, String name, String descriptiveName, ElementClassificationEnum classification, ChemicalRoomStateEnum roomState, RadiationEnum radioactivity) {
            this.element = new ElementEnum(id, name, descriptiveName, classification, roomState, radioactivity);
        }

        public void apply() {
            ElementEnum.registerElement(this.element);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ElementEnum.unregisterElement(this.element);
        }

        public String describe() {
            return "Adding Element: " + this.element.name();
        }

        public String describeUndo() {
            return "Removing Element: " + this.element.name();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddMoleculeAction
    implements IUndoableAction {
        private final MoleculeEnum molecule;

        public AddMoleculeAction(String name, int id, ChemicalRoomStateEnum state, PotionChemical ... chemical) {
            this.molecule = new MoleculeEnum(name, id, state, chemical);
        }

        public void apply() {
            MoleculeEnum.registerMTMolecule(this.molecule);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MoleculeEnum.unregisterMolecule(this.molecule);
        }

        public String describe() {
            return "Adding Molecule: " + this.molecule.name();
        }

        public String describeUndo() {
            return "Removing Molecule: " + this.molecule.name();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

