/*
 * Decompiled with CFR 0.152.
 */
package minechem.minetweaker;

import java.util.ArrayList;
import minechem.utils.InputHelper;
import minechem.utils.MinechemFuelHandler;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.minechem.Fuels")
public class Fuels {
    @ZenMethod
    public static void addFuel(IIngredient input, int value) {
        ArrayList<ItemStack> toAdd = InputHelper.getInputs(input);
        for (ItemStack add : toAdd) {
            MineTweakerAPI.apply((IUndoableAction)new AddFuelAction(add, value));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient input) {
        ArrayList<ItemStack> toRemove = InputHelper.getInputs(input);
        for (ItemStack remove : toRemove) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuelAction(remove));
        }
    }

    private static class RemoveFuelAction
    implements IUndoableAction {
        private final ItemStack stack;
        private int oldValue;

        public RemoveFuelAction(ItemStack input) {
            this.stack = input;
        }

        public void apply() {
            this.oldValue = MinechemFuelHandler.removeFuel(this.stack);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.oldValue > 0) {
                MinechemFuelHandler.addFuel(this.stack, this.oldValue);
            }
        }

        public String describe() {
            return "Removing fuel value for " + this.stack.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring fuel value for " + this.stack.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddFuelAction
    implements IUndoableAction {
        private final ItemStack stack;
        private final int value;
        private int oldValue;

        public AddFuelAction(ItemStack input, int burn) {
            this.stack = input;
            this.value = burn;
        }

        public void apply() {
            this.oldValue = MinechemFuelHandler.addFuel(this.stack, this.value);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            MinechemFuelHandler.removeFuel(this.stack);
            if (this.oldValue > 0) {
                MinechemFuelHandler.addFuel(this.stack, this.oldValue);
            }
        }

        public String describe() {
            return "Adding fuel value for " + this.stack.func_82833_r();
        }

        public String describeUndo() {
            return "Removing fuel value for " + this.stack.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

