/*
 * Decompiled with CFR 0.152.
 */
package minechem.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DecomposerUpdateMessage
implements IMessage,
IMessageHandler<DecomposerUpdateMessage, IMessage> {
    private int posX;
    private int posY;
    private int posZ;
    private int energyStored;
    private int state;
    private int fluidId;
    private int fluidAmount;

    public DecomposerUpdateMessage() {
    }

    public DecomposerUpdateMessage(DecomposerTileEntity tile) {
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.energyStored = tile.getEnergyStored();
        this.state = tile.getState().ordinal();
        if (tile.tank != null) {
            this.fluidId = tile.tank.getFluidID();
            this.fluidAmount = tile.tank.amount;
        } else {
            this.fluidId = -1;
            this.fluidAmount = -1;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.energyStored = buf.readInt();
        this.state = buf.readInt();
        this.fluidId = buf.readInt();
        this.fluidAmount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.energyStored);
        buf.writeInt(this.state);
        buf.writeInt(this.fluidId);
        buf.writeInt(this.fluidAmount);
    }

    public IMessage onMessage(DecomposerUpdateMessage message, MessageContext ctx) {
        TileEntity tileEntity = ctx.side == Side.CLIENT ? FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.posX, message.posY, message.posZ) : FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_147438_o(message.posX, message.posY, message.posZ);
        if (tileEntity instanceof DecomposerTileEntity) {
            ((DecomposerTileEntity)tileEntity).syncEnergyValue(message.energyStored);
            ((DecomposerTileEntity)tileEntity).setState(message.state);
            FluidStack tankStack = null;
            if (message.fluidId != -1) {
                tankStack = new FluidStack(FluidRegistry.getFluid((int)message.fluidId), message.fluidAmount);
            }
            ((DecomposerTileEntity)tileEntity).tank = tankStack;
        }
        return null;
    }
}

