/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import minechem.Settings;
import minechem.api.IDecomposerControl;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerFluidRecipe;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class DecomposerRecipe {
    public static Map<MapKey, DecomposerRecipe> recipes = new LinkedHashMap<MapKey, DecomposerRecipe>();
    private static final Random rand = new Random();
    ItemStack input;
    public Map<MapKey, PotionChemical> output = new LinkedHashMap<MapKey, PotionChemical>();

    public static DecomposerRecipe add(DecomposerRecipe recipe) {
        if (recipe.input != null && recipe.input.func_77973_b() != null) {
            if (DecomposerRecipe.isBlacklisted(recipe.input) || recipe.input.func_77973_b() instanceof IDecomposerControl && ((IDecomposerControl)recipe.input.func_77973_b()).getDecomposerMultiplier(recipe.input) == 0.0) {
                return null;
            }
            if (recipes.get(MapKey.getKey(recipe.input)) == null) {
                recipes.put(MapKey.getKey(recipe.input), recipe);
            }
        } else if (recipe instanceof DecomposerFluidRecipe && ((DecomposerFluidRecipe)recipe).inputFluid != null && recipes.get(MapKey.getKey(((DecomposerFluidRecipe)recipe).inputFluid)) == null) {
            recipes.put(MapKey.getKey(((DecomposerFluidRecipe)recipe).inputFluid), recipe);
        }
        return recipe;
    }

    public static DecomposerRecipe remove(String string) {
        if (recipes.containsKey(string)) {
            return recipes.remove(string);
        }
        return null;
    }

    public static DecomposerRecipe remove(ItemStack itemStack) {
        MapKey key = MapKey.getKey(itemStack);
        if (key != null && recipes.containsKey(key)) {
            return recipes.remove(key);
        }
        return null;
    }

    public static DecomposerRecipe remove(MapKey key) {
        return recipes.remove(key);
    }

    public static DecomposerRecipe get(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return null;
        }
        return DecomposerRecipe.get(MapKey.getKey(itemStack));
    }

    public static DecomposerRecipe get(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        return DecomposerRecipe.get(MapKey.getKey(fluidStack));
    }

    public static DecomposerRecipe get(MapKey key) {
        return recipes.get(key);
    }

    public static void removeRecipeSafely(String item) {
        for (ItemStack i : OreDictionary.getOres((String)item)) {
            DecomposerRecipe.remove(i);
        }
    }

    public static void createAndAddRecipeSafely(String item, PotionChemical ... chemicals) {
        if (chemicals.length > 0) {
            for (ItemStack i : OreDictionary.getOres((String)item)) {
                DecomposerRecipe.add(new DecomposerRecipe(new ItemStack(i.func_77973_b(), 1, i.func_77960_j()), chemicals));
            }
        }
    }

    public DecomposerRecipe(ItemStack input, PotionChemical ... chemicals) {
        this(chemicals);
        this.input = input;
    }

    public DecomposerRecipe(ItemStack input, List<PotionChemical> chemicals) {
        this(chemicals.toArray(new PotionChemical[chemicals.size()]));
        this.input = input;
    }

    public DecomposerRecipe(PotionChemical ... chemicals) {
        this.addChemicals(chemicals);
    }

    public void addChemicals(PotionChemical ... chemicals) {
        for (PotionChemical potionChemical : chemicals) {
            PotionChemical current = this.output.get(new MapKey(potionChemical));
            if (current != null) {
                current.amount += potionChemical.amount;
                continue;
            }
            this.output.put(new MapKey(potionChemical), potionChemical.copy());
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public MapKey getKey() {
        return new MapKey(this.getInput());
    }

    public ArrayList<PotionChemical> getOutput() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    public ArrayList<PotionChemical> getOutputRaw() {
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        result.addAll(this.output.values());
        return result;
    }

    public ArrayList<PotionChemical> getPartialOutputRaw(int f) {
        ArrayList<PotionChemical> raw = this.getOutput();
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        if (raw != null) {
            for (PotionChemical chem : raw) {
                try {
                    PotionChemical reduced;
                    if (chem == null || (reduced = chem.copy()) == null) continue;
                    reduced.amount = (int)Math.floor(chem.amount / f);
                    if (reduced.amount == 0 && rand.nextFloat() > (float)(chem.amount / f)) {
                        reduced.amount = 1;
                    }
                    result.add(reduced);
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public boolean isNull() {
        return this.output == null;
    }

    public boolean hasOutput() {
        return !this.output.values().isEmpty();
    }

    public boolean outputContains(PotionChemical potionChemical) {
        PotionChemical output;
        boolean contains = false;
        Iterator<PotionChemical> i$ = this.output.values().iterator();
        while (i$.hasNext() && !(contains = potionChemical.sameAs(output = i$.next()))) {
        }
        return contains;
    }

    public static boolean isBlacklisted(ItemStack itemStack) {
        for (ItemStack stack : Settings.decomposerBlacklist) {
            if (stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public float getChance() {
        return 1.0f;
    }
}

