/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock;

import java.util.HashMap;
import minechem.item.blueprint.BlueprintBlock;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.tileentity.multiblock.MultiBlockStatusEnum;
import minechem.tileentity.prefab.MinechemTileEntityElectric;
import minechem.tileentity.prefab.TileEntityProxy;
import minechem.utils.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class MultiBlockTileEntity
extends MinechemTileEntityElectric {
    private static final Integer air = 0;
    int offsetX;
    int offsetY;
    int offsetZ;
    public MinechemBlueprint blueprint;
    Integer[][][] structure;
    protected boolean completeStructure;
    SafeTimeTracker tracker = new SafeTimeTracker();

    public MultiBlockTileEntity(int maxEnergy) {
        super(maxEnergy);
    }

    public void setBlueprint(MinechemBlueprint blueprint) {
        this.blueprint = blueprint;
        this.structure = blueprint.getResultStructure();
        this.offsetX = this.field_145851_c - blueprint.getManagerPosX();
        this.offsetY = this.field_145848_d - blueprint.getManagerPosY();
        this.offsetZ = this.field_145849_e - blueprint.getManagerPosZ();
    }

    @Override
    public void func_145845_h() {
        if (this.tracker.markTimeIfDelay(this.field_145850_b, 40L)) {
            if (this.completeStructure && !this.areBlocksCorrect()) {
                this.completeStructure = false;
                this.unlinkProxies();
            }
            if (!this.completeStructure && this.areBlocksCorrect()) {
                this.completeStructure = true;
                this.linkProxies();
            }
        }
    }

    private void unlinkProxies() {
        for (int y = 0; y < this.blueprint.ySize; ++y) {
            for (int x = 0; x < this.blueprint.xSize; ++x) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    this.unlinkProxy(x, y, z);
                }
            }
        }
    }

    private void unlinkProxy(int x, int y, int z) {
        int worldX = this.field_145851_c + this.offsetX + x;
        int worldY = this.field_145848_d + this.offsetY + y;
        int worldZ = this.field_145849_e + this.offsetZ + z;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(worldX, worldY, worldZ);
        if (tileEntity != null && tileEntity instanceof TileEntityProxy) {
            ((TileEntityProxy)tileEntity).setManager(null);
        }
    }

    private void linkProxies() {
        for (int y = 0; y < this.blueprint.ySize; ++y) {
            for (int x = 0; x < this.blueprint.xSize; ++x) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    this.linkProxy(x, y, z);
                }
            }
        }
    }

    private void linkProxy(int x, int y, int z) {
        int worldX = this.field_145851_c + this.offsetX + x;
        int worldY = this.field_145848_d + this.offsetY + y;
        int worldZ = this.field_145849_e + this.offsetZ + z;
        HashMap<Integer, BlueprintBlock> lut = this.blueprint.getBlockLookup();
        TileEntity tileEntity = this.field_145850_b.func_147438_o(worldX, worldY, worldZ);
        if (tileEntity != null && tileEntity instanceof TileEntityProxy) {
            ((TileEntityProxy)tileEntity).setManager(this);
        }
    }

    private boolean areBlocksCorrect() {
        for (int y = 0; y < this.blueprint.ySize; ++y) {
            for (int x = 0; x < this.blueprint.xSize; ++x) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    MultiBlockStatusEnum multiBlockStatusEnum = this.checkBlock(x, y, z);
                    if (multiBlockStatusEnum != MultiBlockStatusEnum.INCORRECT) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private MultiBlockStatusEnum checkBlock(int x, int y, int z) {
        if (x == this.blueprint.getManagerPosX() && y == this.blueprint.getManagerPosY() && z == this.blueprint.getManagerPosZ()) {
            return MultiBlockStatusEnum.CORRECT;
        }
        int worldX = this.field_145851_c + (this.offsetX + x);
        int worldY = this.field_145848_d + (this.offsetY + y);
        int worldZ = this.field_145849_e + (this.offsetZ + z);
        Integer structureID = this.structure[y][x][z];
        Block block = this.field_145850_b.func_147439_a(worldX, worldY, worldZ);
        if (structureID == -1) {
            return MultiBlockStatusEnum.CORRECT;
        }
        if (structureID == air) {
            if (block == Blocks.field_150350_a) {
                return MultiBlockStatusEnum.CORRECT;
            }
            return MultiBlockStatusEnum.INCORRECT;
        }
        HashMap<Integer, BlueprintBlock> lut = this.blueprint.getBlockLookup();
        BlueprintBlock blueprintBlock = lut.get(structureID);
        if (block == blueprintBlock.block && this.field_145850_b.func_72805_g(worldX, worldY, worldZ) == blueprintBlock.metadata) {
            return MultiBlockStatusEnum.CORRECT;
        }
        return MultiBlockStatusEnum.INCORRECT;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("completeStructure", this.completeStructure);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.completeStructure = false;
    }
}

