/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock.fusion;

import minechem.gui.GuiContainerTabbed;
import minechem.gui.GuiTabHelp;
import minechem.gui.GuiTabPatreon;
import minechem.reference.Resources;
import minechem.tileentity.multiblock.fusion.FusionContainer;
import minechem.tileentity.multiblock.fusion.FusionTabStateControl;
import minechem.tileentity.multiblock.fusion.FusionTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class FusionGui
extends GuiContainerTabbed {
    private static float increaseRate = 0.2f;
    private static float decreaseRate = 0.4f;
    FusionTileEntity fusion;
    static int guiWidth = 176;
    static int guiHeight = 187;
    int storedEnergy;
    int maxEnergy;

    public FusionGui(InventoryPlayer inventoryPlayer, FusionTileEntity fusion) {
        super(new FusionContainer(inventoryPlayer, fusion));
        this.fusion = fusion;
        this.field_146999_f = guiWidth;
        this.field_147000_g = guiHeight;
        this.storedEnergy = this.fusion.getEnergyStored();
        this.maxEnergy = fusion.getMaxEnergyStored();
        this.addTab(new FusionTabStateControl((Gui)this, fusion));
        this.addTab(new GuiTabHelp(this, MinechemUtil.getLocalString("help.fusion")));
        this.addTab(new GuiTabPatreon(this));
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String info = MinechemUtil.getLocalString("block.fusionReactor.name");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        this.field_146289_q.func_78276_b(info, (guiWidth - infoWidth) / 2, 5, 0);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.updateEnergy();
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.FUSION);
        int x = (this.field_146294_l - guiWidth) / 2;
        int y = (this.field_146295_m - guiHeight) / 2;
        this.func_73729_b(x, y, 0, 0, guiWidth, guiHeight);
        this.drawEnergyBarOverlay(x, y);
    }

    public void drawEnergyBarOverlay(int x, int y) {
        this.func_73729_b(x + 8, y + 38, 0, 187, this.fusion.getPowerRemainingScaled(160.0), 3);
    }

    private void updateEnergy() {
        this.storedEnergy = this.fusion.getEnergyStored();
    }
}

