/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.server.PacketSender$;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import scala.Array$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t=f\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0012:jm\u0016T!a\u0001\u0003\u0002\u0013\r|W\u000e]8oK:$(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0003_\u000eT!!\u0003\u0006\u0002\u0007\rLGNC\u0001\f\u0003\ta\u0017n\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u00051\u0001O]3gC\nT!a\u0005\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u0016!\t\u0011R*\u00198bO\u0016$WI\u001c<je>tW.\u001a8u!\t9\"$D\u0001\u0019\u0015\tI\"#\u0001\u0004ee&4XM]\u0005\u00037a\u0011!\u0002R3wS\u000e,\u0017J\u001c4p\u0011!i\u0002A!b\u0001\n\u0003q\u0012\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u00121!\u00138u\u0011!1\u0003A!A!\u0002\u0013y\u0012!C2ba\u0006\u001c\u0017\u000e^=!\u0011!A\u0003A!b\u0001\n\u0003q\u0012\u0001\u00049mCR$XM]\"pk:$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u001bAd\u0017\r\u001e;fe\u000e{WO\u001c;!\u0011!a\u0003A!b\u0001\n\u0003i\u0013!\u00027bE\u0016dW#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0012\u0012A\u00014t\u0013\t\u0019\u0004GA\u0003MC\n,G\u000e\u0003\u00056\u0001\t\u0005\t\u0015!\u0003/\u0003\u0019a\u0017MY3mA!Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0003i_N$\bc\u0001\u0011:w%\u0011!(\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005qzT\"A\u001f\u000b\u0005y\u0012\u0012a\u00028fi^|'o[\u0005\u0003\u0001v\u0012q\"\u00128wSJ|g.\\3oi\"{7\u000f\u001e\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\u0006)1o\\;oIV\tA\tE\u0002!s\u0015\u0003\"AR%\u000f\u0005\u0001:\u0015B\u0001%\"\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u000b\u0003\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\rM|WO\u001c3!\u0011!y\u0005A!b\u0001\n\u0003q\u0012!B:qK\u0016$\u0007\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\rM\u0004X-\u001a3!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q9Qk\u0016-Z5nc\u0006C\u0001,\u0001\u001b\u0005\u0011\u0001\"B\u000fS\u0001\u0004y\u0002\"\u0002\u0015S\u0001\u0004y\u0002\"\u0002\u0017S\u0001\u0004q\u0003\"B\u001cS\u0001\u0004A\u0004\"\u0002\"S\u0001\u0004!\u0005\"B(S\u0001\u0004y\u0002b\u00020\u0001\u0005\u0004%\teX\u0001\u0005]>$W-F\u0001a!\ta\u0014-\u0003\u0002c{\t\u00112i\\7q_:,g\u000e^\"p]:,7\r^8s\u0011\u0019!\u0007\u0001)A\u0005A\u0006)an\u001c3fA!)a\r\u0001C\u0005O\u0006A1/\u0019<f!\u0006$\b.F\u0001i!\tIg.D\u0001k\u0015\tYG.\u0001\u0002j_*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005\u00111\u0015\u000e\\3\t\u000fE\u0004!\u0019!C\u0007e\u0006Q1/Z2u_J\u001c\u0016N_3\u0016\u0003M|\u0011\u0001^\u000f\u0003\u0005\u0001AaA\u001e\u0001!\u0002\u001b\u0019\u0018aC:fGR|'oU5{K\u0002Bq\u0001\u001f\u0001C\u0002\u0013%\u00110\u0001\u0003eCR\fW#\u0001>\u0011\u0007\u0001ZX0\u0003\u0002}C\t)\u0011I\u001d:bsB\u0011\u0001E`\u0005\u0003\u007f\u0006\u0012AAQ=uK\"9\u00111\u0001\u0001!\u0002\u0013Q\u0018!\u00023bi\u0006\u0004\u0003\u0002CA\u0004\u0001\t\u0007I\u0011\u0002\u0010\u0002\u0017M,7\r^8s\u0007>,h\u000e\u001e\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003 \u00031\u0019Xm\u0019;pe\u000e{WO\u001c;!\u0011!\ty\u0001\u0001b\u0001\n\u0013q\u0012!E:fGR|'o\u001d)feBc\u0017\r\u001e;fe\"9\u00111\u0003\u0001!\u0002\u0013y\u0012AE:fGR|'o\u001d)feBc\u0017\r\u001e;fe\u0002B\u0001\"a\u0006\u0001\u0001\u0004%IAH\u0001\bQ\u0016\fG\rU8t\u0011%\tY\u0002\u0001a\u0001\n\u0013\ti\"A\u0006iK\u0006$\u0007k\\:`I\u0015\fH\u0003BA\u0010\u0003K\u00012\u0001IA\u0011\u0013\r\t\u0019#\t\u0002\u0005+:LG\u000fC\u0005\u0002(\u0005e\u0011\u0011!a\u0001?\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005-\u0002\u0001)Q\u0005?\u0005A\u0001.Z1e!>\u001c\b\u0005C\u0005\u00020\u0001\u0011\r\u0011\"\u0002\u00022\u0005y!/Z1e'\u0016\u001cGo\u001c:D_N$8/\u0006\u0002\u00024A!\u0001e_A\u001b!\r\u0001\u0013qG\u0005\u0004\u0003s\t#A\u0002#pk\ndW\r\u0003\u0005\u0002>\u0001\u0001\u000bQBA\u001a\u0003A\u0011X-\u00193TK\u000e$xN]\"pgR\u001c\b\u0005C\u0005\u0002B\u0001\u0011\r\u0011\"\u0002\u00022\u0005\u0001rO]5uKN+7\r^8s\u0007>\u001cHo\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0004\u00024\u0005\trO]5uKN+7\r^8s\u0007>\u001cHo\u001d\u0011\t\u0013\u0005%\u0003A1A\u0005\u0006\u0005E\u0012!\u0004:fC\u0012\u0014\u0015\u0010^3D_N$8\u000f\u0003\u0005\u0002N\u0001\u0001\u000bQBA\u001a\u00039\u0011X-\u00193CsR,7i\\:ug\u0002B\u0011\"!\u0015\u0001\u0005\u0004%)!!\r\u0002\u001d]\u0014\u0018\u000e^3CsR,7i\\:ug\"A\u0011Q\u000b\u0001!\u0002\u001b\t\u0019$A\bxe&$XMQ=uK\u000e{7\u000f^:!\u0011)\tI\u0006\u0001EC\u0002\u00135\u00111L\u0001\u000bI\u00164\u0018nY3J]\u001a|WCAA/!!\ty&!\u001b\u0002n\u00055TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0013%lW.\u001e;bE2,'bAA4C\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0004\u001b\u0006\u0004\b\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005MD.\u0001\u0003mC:<\u0017b\u0001&\u0002r!Q\u0011\u0011\u0010\u0001\t\u0002\u0003\u0006k!!\u0018\u0002\u0017\u0011,g/[2f\u0013:4w\u000e\t\u0005\b\u0003{\u0002A\u0011IA@\u000359W\r\u001e#fm&\u001cW-\u00138g_R\u0011\u0011\u0011\u0011\t\u0007\u0003\u0007\u000bI)R#\u000e\u0005\u0005\u0015%bAADY\u0006!Q\u000f^5m\u0013\u0011\tY'!\"\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006Aq-\u001a;MC\n,G\u000e\u0006\u0004\u0002\u0012\u0006e\u0015\u0011\u0016\t\u0005Am\f\u0019\nE\u0002!\u0003+K1!a&\"\u0005\u0019\te.\u001f*fM\"A\u00111TAF\u0001\u0004\ti*A\u0004d_:$X\r\u001f;\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)\u0013\u0003\u001di\u0017m\u00195j]\u0016LA!a*\u0002\"\n91i\u001c8uKb$\b\u0002CAV\u0003\u0017\u0003\r!!,\u0002\t\u0005\u0014xm\u001d\t\u0005\u0003?\u000by+\u0003\u0003\u00022\u0006\u0005&!C!sOVlWM\u001c;tQ1\tY)!.\u0002<\u0006u\u0016qXAa!\u0011\ty*a.\n\t\u0005e\u0016\u0011\u0015\u0002\t\u0007\u0006dGNY1dW\u00061A-\u001b:fGRL\u0012!A\u0001\u0004I>\u001c\u0017EAAb\u0003a2WO\\2uS>t\u0007&\u000b\u001etiJLgn\u001a\u0011.[\u0001:U\r\u001e\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005\\1cK2\u0004sN\u001a\u0011uQ\u0016\u0004CM]5wK:Bq!a2\u0001\t\u0003\tI-\u0001\u0005tKRd\u0015MY3m)\u0019\t\t*a3\u0002N\"A\u00111TAc\u0001\u0004\ti\n\u0003\u0005\u0002,\u0006\u0015\u0007\u0019AAWQ!\t)-!.\u0002@\u0006E\u0017EAAj\u000314WO\\2uS>t\u0007F^1mk\u0016T4\u000f\u001e:j]\u001eL#h\u001d;sS:<\u0007%L\u0017!'\u0016$8\u000f\t;iK\u0002b\u0017MY3mA=4\u0007\u0005\u001e5fA\u0011\u0014\u0018N^3/AI+G/\u001e:og\u0002\"\b.\u001a\u0011oK^\u0004c/\u00197vK2\u0002s\u000f[5dQ\u0002j\u0017-\u001f\u0011cK\u0002\"(/\u001e8dCR,GM\f\u0005\b\u0003/\u0004A\u0011AAm\u0003-9W\r^\"ba\u0006\u001c\u0017\u000e^=\u0015\r\u0005E\u00151\\Ao\u0011!\tY*!6A\u0002\u0005u\u0005\u0002CAV\u0003+\u0004\r!!,)\u0019\u0005U\u0017QWA^\u0003{\u000by,!9\"\u0005\u0005\r\u0018a\u00124v]\u000e$\u0018n\u001c8)SirW/\u001c2fe\u0002jS\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Co\u001c;bY\u0002\u001a\u0017\r]1dSRL\be\u001c4!i\",\u0007\u0005\u001a:jm\u0016d\u0003%\u001b8!Ef$Xm\u001d\u0018\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\u0006iq-\u001a;TK\u000e$xN]*ju\u0016$b!!%\u0002l\u00065\b\u0002CAN\u0003K\u0004\r!!(\t\u0011\u0005-\u0016Q\u001da\u0001\u0003[CC\"!:\u00026\u0006m\u0016QXA`\u0003c\f#!a=\u0002!\u001a,hn\u0019;j_:D\u0013F\u000f8v[\n,'\u000fI\u0017.AI+G/\u001e:og\u0002\"\b.\u001a\u0011tSj,\u0007e\u001c4!C\u0002\u001a\u0018N\\4mK\u0002\u001aXm\u0019;pe\u0002zg\u000e\t;iK\u0002\"'/\u001b<fY\u0001Jg\u000e\t2zi\u0016\u001ch\u0006C\u0004\u0002x\u0002!\t!!?\u0002\u001f\u001d,G\u000f\u00157biR,'oQ8v]R$b!!%\u0002|\u0006u\b\u0002CAN\u0003k\u0004\r!!(\t\u0011\u0005-\u0016Q\u001fa\u0001\u0003[CC\"!>\u00026\u0006m\u0016QXA`\u0005\u0003\t#Aa\u0001\u0002\u0003\u001a,hn\u0019;j_:D\u0013F\u000f8v[\n,'\u000fI\u0017.AI+G/\u001e:og\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\u0002H.\u0019;uKJ\u001c\b%\u001b8!i\",\u0007\u0005\u001a:jm\u0016t\u0003b\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\u000be\u0016\fGmU3di>\u0014HCBAI\u0005\u0017\u0011i\u0001\u0003\u0005\u0002\u001c\n\u0015\u0001\u0019AAO\u0011!\tYK!\u0002A\u0002\u00055\u0006\u0006\u0004B\u0003\u0003k\u000bY,!0\u0002@\nE\u0011E\u0001B\n\u0003Q3WO\\2uS>t\u0007f]3di>\u0014(H\\;nE\u0016\u0014\u0018FO:ue&tw\rI\u0017.AI+\u0017\r\u001a\u0011uQ\u0016\u00043-\u001e:sK:$\beY8oi\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u001aXm\u0019;pe:BqAa\u0006\u0001\t\u0003\u0011I\"A\u0006xe&$XmU3di>\u0014HCBAI\u00057\u0011i\u0002\u0003\u0005\u0002\u001c\nU\u0001\u0019AAO\u0011!\tYK!\u0006A\u0002\u00055\u0006\u0006\u0004B\u000b\u0003k\u000bY,!0\u0002@\n\u0005\u0012E\u0001B\u0012\u0003y3WO\\2uS>t\u0007f]3di>\u0014(H\\;nE\u0016\u0014H\u0006\t<bYV,'h\u001d;sS:<\u0017\u0006I\u0017.A]\u0013\u0018\u000e^3!i\",\u0007e\u001d9fG&4\u0017.\u001a3!G>tG/\u001a8ug\u0002\"x\u000e\t;iK\u0002\u001a\b/Z2jM&,G\rI:fGR|'O\f\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0003!\u0011X-\u00193CsR,GCBAI\u0005W\u0011i\u0003\u0003\u0005\u0002\u001c\n\u0015\u0002\u0019AAO\u0011!\tYK!\nA\u0002\u00055\u0006\u0006\u0004B\u0013\u0003k\u000bY,!0\u0002@\nE\u0012E\u0001B\u001a\u000353WO\\2uS>t\u0007f\u001c4gg\u0016$(H\\;nE\u0016\u0014\u0018F\u000f8v[\n,'\u000fI\u0017.AI+\u0017\r\u001a\u0011bAMLgn\u001a7fA\tLH/\u001a\u0011bi\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002zgMZ:fi:BqAa\u000e\u0001\t\u0003\u0011I$A\u0005xe&$XMQ=uKR1\u0011\u0011\u0013B\u001e\u0005{A\u0001\"a'\u00036\u0001\u0007\u0011Q\u0014\u0005\t\u0003W\u0013)\u00041\u0001\u0002.\"b!QGA[\u0003w\u000bi,a0\u0003B\u0005\u0012!1I\u0001VMVt7\r^5p]\"zgMZ:fijrW/\u001c2fe2\u0002c/\u00197vKjrW/\u001c2fe&\u0002S&\f\u0011Xe&$X\rI1!g&tw\r\\3!Ef$X\r\t;pAQDW\rI:qK\u000eLg-[3eA=4gm]3u]!9!q\t\u0001\u0005B\t%\u0013\u0001\u00027pC\u0012$B!a\b\u0003L!A!Q\nB#\u0001\u0004\u0011y%A\u0002oER\u0004BA!\u0015\u0003^5\u0011!1\u000b\u0006\u0005\u0005\u001b\u0012)F\u0003\u0003\u0003X\te\u0013!C7j]\u0016\u001c'/\u00194u\u0015\t\u0011Y&A\u0002oKRLAAa\u0018\u0003T\tqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007b\u0002B2\u0001\u0011\u0005#QM\u0001\u0005g\u00064X\r\u0006\u0003\u0002 \t\u001d\u0004\u0002\u0003B'\u0005C\u0002\rAa\u0014\t\u000f\t-\u0004\u0001\"\u0003\u0003n\u0005qa/\u00197jI\u0006$XmU3di>\u0014HcA\u0010\u0003p!9!\u0011\u000fB5\u0001\u0004y\u0012AB:fGR|'\u000fC\u0004\u0003v\u0001!IAa\u001e\u0002\u0017\rDWmY6TK\u000e$xN\u001d\u000b\u0004?\te\u0004b\u0002B>\u0005g\u0002\raH\u0001\u0007_\u001a47/\u001a;\t\u000f\tU\u0004\u0001\"\u0003\u0003\u0000Q)qD!!\u0003\u0004\"A\u00111\u0016B?\u0001\u0004\ti\u000bC\u0004\u0003\u0006\nu\u0004\u0019A\u0010\u0002\u00039DqA!#\u0001\t\u0013\u0011Y)\u0001\u0007n_Z,Gk\\*fGR|'\u000fF\u0003 \u0005\u001b\u0013y\t\u0003\u0005\u0002\u001c\n\u001d\u0005\u0019AAO\u0011\u001d\u0011\tHa\"A\u0002}AqAa%\u0001\t\u0013\u0011)*A\btK\u000e$xN\u001d+p\u0011\u0016\fG\rU8t)\ry\"q\u0013\u0005\b\u0005c\u0012\t\n1\u0001 \u0011\u001d\u0011Y\n\u0001C\u0005\u0005;\u000bAb]3di>\u0014xJ\u001a4tKR$2a\bBP\u0011\u001d\u0011\tH!'A\u0002}AqAa)\u0001\t\u0013\u0011)+\u0001\u0007pM\u001a\u001cX\r^*fGR|'\u000fF\u0002 \u0005OCqAa\u001f\u0003\"\u0002\u0007q\u0004C\u0004\u0003,\u0002!IA!,\u0002\u0019\u0011L7o[!di&4\u0018\u000e^=\u0015\u0005\u0005}\u0001")
public class Drive
extends ManagedEnvironment
implements DeviceInfo {
    private final int capacity;
    private final int platterCount;
    private final Label label;
    private final Option<EnvironmentHost> host;
    private final Option<String> sound;
    private final int speed;
    private final ComponentConnector node;
    private final int sectorSize;
    private final byte[] data;
    private final int sectorCount;
    private final int sectorsPerPlatter;
    private int headPos;
    private final double[] readSectorCosts;
    private final double[] writeSectorCosts;
    private final double[] readByteCosts;
    private final double[] writeByteCosts;
    private Map<String, String> deviceInfo;
    private volatile boolean bitmap$0;

    private Map deviceInfo$lzycompute() {
        Drive drive = this;
        synchronized (drive) {
            if (!this.bitmap$0) {
                this.deviceInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"disk"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"Hard disk drive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vendor"), (Object)"MightyPirates GmbH & Co. KG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)new StringBuilder().append((Object)"MPD").append((Object)((Object)BoxesRunTime.boxToInteger((int)(this.capacity() / 1024))).toString()).append((Object)"L").append((Object)((Object)BoxesRunTime.boxToInteger((int)this.platterCount())).toString()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capacity"), (Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)this.capacity() * 1.024)))).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.capacity())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clock"), (Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeSectorCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.readByteCosts()[this.speed()]) / 100))).toString()).append((Object)"/").append((Object)((Object)BoxesRunTime.boxToInteger((int)((int)((double)2000 / this.writeByteCosts()[this.speed()]) / 100))).toString()).toString())}));
                this.bitmap$0 = true;
            }
            return this.deviceInfo;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public int platterCount() {
        return this.platterCount;
    }

    public Label label() {
        return this.label;
    }

    public Option<String> sound() {
        return this.sound;
    }

    public int speed() {
        return this.speed;
    }

    @Override
    public ComponentConnector node() {
        return this.node;
    }

    private File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)this.node().address()).append((Object)".bin").toString());
    }

    private final int sectorSize() {
        return 512;
    }

    private byte[] data() {
        return this.data;
    }

    private int sectorCount() {
        return this.sectorCount;
    }

    private int sectorsPerPlatter() {
        return this.sectorsPerPlatter;
    }

    private int headPos() {
        return this.headPos;
    }

    private void headPos_$eq(int x$1) {
        this.headPos = x$1;
    }

    public final double[] readSectorCosts() {
        return this.readSectorCosts;
    }

    public final double[] writeSectorCosts() {
        return this.writeSectorCosts;
    }

    public final double[] readByteCosts() {
        return this.readByteCosts;
    }

    public final double[] writeByteCosts() {
        return this.writeByteCosts;
    }

    private final Map<String, String> deviceInfo() {
        return this.bitmap$0 ? this.deviceInfo : this.deviceInfo$lzycompute();
    }

    @Override
    public java.util.Map<String, String> getDeviceInfo() {
        return WrapAsJava$.MODULE$.mapAsJavaMap(this.deviceInfo());
    }

    @Callback(direct=true, doc="function():string -- Get the current label of the drive.")
    public synchronized Object[] getLabel(Context context, Arguments args) {
        return this.label() == null ? null : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(doc="function(value:string):string -- Sets the label of the drive. Returns the new value, which may be truncated.")
    public synchronized Object[] setLabel(Context context, Arguments args) {
        if (this.label() == null) {
            throw new Exception("drive does not support labeling");
        }
        if (args.checkAny(0) == null) {
            this.label().setLabel(null);
        } else {
            this.label().setLabel(args.checkString(0));
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.label().getLabel()}));
    }

    @Callback(direct=true, doc="function():number -- Returns the total capacity of the drive, in bytes.")
    public Object[] getCapacity(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.capacity())}));
    }

    @Callback(direct=true, doc="function():number -- Returns the size of a single sector on the drive, in bytes.")
    public Object[] getSectorSize(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)512)}));
    }

    @Callback(direct=true, doc="function():number -- Returns the number of platters in the drive.")
    public Object[] getPlatterCount(Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.platterCount())}));
    }

    @Callback(direct=true, doc="function(sector:number):string -- Read the current contents of the specified sector.")
    public synchronized Object[] readSector(Context context, Arguments args) {
        context.consumeCallBudget(this.readSectorCosts()[this.speed()]);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        byte[] sectorData = new byte[512];
        Array$.MODULE$.copy((Object)this.data(), this.sectorOffset(sector), (Object)sectorData, 0, 512);
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectorData}));
    }

    @Callback(direct=true, doc="function(sector:number, value:string) -- Write the specified contents to the specified sector.")
    public synchronized Object[] writeSector(Context context, Arguments args) {
        context.consumeCallBudget(this.writeSectorCosts()[this.speed()]);
        byte[] sectorData = args.checkByteArray(1);
        int sector = this.moveToSector(context, this.checkSector(args, 0));
        this.diskActivity();
        Array$.MODULE$.copy((Object)sectorData, 0, (Object)this.data(), this.sectorOffset(sector), scala.math.package$.MODULE$.min(512, sectorData.length));
        return null;
    }

    @Callback(direct=true, doc="function(offset:number):number -- Read a single byte at the specified offset.")
    public synchronized Object[] readByte(Context context, Arguments args) {
        context.consumeCallBudget(this.readByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.data()[offset])}));
    }

    @Callback(direct=true, doc="function(offset:number, value:number) -- Write a single byte to the specified offset.")
    public synchronized Object[] writeByte(Context context, Arguments args) {
        context.consumeCallBudget(this.writeByteCosts()[this.speed()]);
        int offset = args.checkInteger(0) - 1;
        byte value = (byte)args.checkInteger(1);
        this.moveToSector(context, this.checkSector(offset));
        this.diskActivity();
        this.data()[offset] = value;
        return null;
    }

    @Override
    public synchronized void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                if (path.exists()) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(Files.toByteArray((File)path));
                    GZIPInputStream zin = new GZIPInputStream(bin);
                    int read = 0;
                    for (int offset = 0; read >= 0 && offset < this.data().length; offset += read) {
                        read = zin.read(this.data(), offset, this.data().length - offset);
                    }
                }
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed loading drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        this.headPos_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(nbt.func_74762_e("headPos")), 0)), this.sectorToHeadPos(this.sectorCount())));
        if (this.label() != null) {
            this.label().load(nbt);
        }
    }

    @Override
    public synchronized void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.node().address() != null) {
            try {
                File path = this.savePath();
                path.getParentFile().mkdirs();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = new GZIPOutputStream(bos);
                zos.write(this.data());
                zos.close();
                Files.write((byte[])bos.toByteArray(), (File)path);
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed saving drive contents for '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node().address()})), throwable);
            }
        }
        nbt.func_74768_a("headPos", this.headPos());
        if (this.label() != null) {
            this.label().save(nbt);
        }
    }

    private int validateSector(int sector) {
        if (sector < 0 || sector >= this.sectorCount()) {
            throw new IllegalArgumentException("invalid offset, not in a usable sector");
        }
        return sector;
    }

    private int checkSector(int offset) {
        return this.validateSector(this.offsetSector(offset));
    }

    private int checkSector(Arguments args, int n) {
        return this.validateSector(args.checkInteger(n) - 1);
    }

    private int moveToSector(Context context, int sector) {
        int newHeadPos = this.sectorToHeadPos(sector);
        if (this.headPos() != newHeadPos) {
            int delta = scala.math.package$.MODULE$.abs(this.headPos() - newHeadPos);
            Object object = delta > Settings$.MODULE$.get().sectorSeekThreshold() ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().sectorSeekTime())) : BoxedUnit.UNIT;
            this.headPos_$eq(newHeadPos);
        }
        return sector;
    }

    private int sectorToHeadPos(int sector) {
        return sector % this.sectorsPerPlatter();
    }

    private int sectorOffset(int sector) {
        return sector * 512;
    }

    private int offsetSector(int offset) {
        return offset / 512;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void diskActivity() {
        Tuple2 tuple2 = new Tuple2(this.sound(), this.host);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String s = (String)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    EnvironmentHost h = (EnvironmentHost)some2.x();
                    PacketSender$.MODULE$.sendFileSystemActivity(this.node(), h, s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Drive(int capacity, int platterCount, Label label, Option<EnvironmentHost> host, Option<String> sound, int speed) {
        this.capacity = capacity;
        this.platterCount = platterCount;
        this.label = label;
        this.host = host;
        this.sound = sound;
        this.speed = speed;
        this.node = (ComponentConnector)Network.newNode(this, Visibility.Network).withComponent("drive", Visibility.Neighbors).withConnector().create();
        this.data = new byte[capacity];
        this.sectorCount = capacity / 512;
        this.sectorsPerPlatter = this.sectorCount() / platterCount;
        this.headPos = 0;
        this.readSectorCosts = new double[]{0.1, 0.05, 0.03333333333333333, 0.025, 0.02, 0.016666666666666666};
        this.writeSectorCosts = new double[]{0.2, 0.1, 0.06666666666666667, 0.05, 0.04, 0.03333333333333333};
        this.readByteCosts = new double[]{0.020833333333333332, 0.015625, 0.0125, 0.010416666666666666, 0.008928571428571428, 0.0078125};
        this.writeByteCosts = new double[]{0.041666666666666664, 0.03125, 0.025, 0.020833333333333332, 0.017857142857142856, 0.015625};
    }
}

