/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class Pos3D {
    public double xPos;
    public double yPos;
    public double zPos;

    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vec3 vec) {
        this.xPos = vec.field_72450_a;
        this.yPos = vec.field_72448_b;
        this.zPos = vec.field_72449_c;
    }

    public Pos3D(MovingObjectPosition mop) {
        this.xPos = mop.field_72311_b;
        this.yPos = mop.field_72312_c;
        this.zPos = mop.field_72309_d;
    }

    public Pos3D(double x, double y, double z) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
    }

    public Pos3D(Coord4D coord) {
        this.xPos = coord.xCoord;
        this.yPos = coord.yCoord;
        this.zPos = coord.zCoord;
    }

    public Pos3D(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Pos3D(TileEntity tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public static Pos3D read(NBTTagCompound tag) {
        return new Pos3D(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74780_a("x", this.xPos);
        nbtTags.func_74780_a("y", this.yPos);
        nbtTags.func_74780_a("z", this.zPos);
        return nbtTags;
    }

    public Pos3D diff(Pos3D pos) {
        return new Pos3D(this.xPos - pos.xPos, this.yPos - pos.yPos, this.zPos - pos.zPos);
    }

    public static Pos3D fromMotion(Entity entity) {
        return new Pos3D(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    public Coord4D getCoord(int dimensionId) {
        return new Coord4D((int)this.xPos, (int)this.yPos, (int)this.zPos, dimensionId);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        this.xPos += x;
        this.yPos += y;
        this.zPos += z;
        return this;
    }

    public Pos3D translate(Pos3D pos) {
        return this.translate(pos.xPos, pos.yPos, pos.zPos);
    }

    public Pos3D translate(ForgeDirection direction, double amount) {
        return this.translate((double)direction.offsetX * amount, (double)direction.offsetY * amount, (double)direction.offsetZ * amount);
    }

    public Pos3D translateExcludingSide(ForgeDirection direction, double amount) {
        if (direction.offsetX == 0) {
            this.xPos += amount;
        }
        if (direction.offsetY == 0) {
            this.yPos += amount;
        }
        if (direction.offsetZ == 0) {
            this.zPos += amount;
        }
        return this;
    }

    public double distance(Pos3D pos) {
        double subX = this.xPos - pos.xPos;
        double subY = this.yPos - pos.yPos;
        double subZ = this.zPos - pos.zPos;
        return MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public Pos3D rotateYaw(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = this.xPos;
        double z = this.zPos;
        if (yaw != 0.0) {
            this.xPos = x * Math.cos(yawRadians) - z * Math.sin(yawRadians);
            this.zPos = z * Math.cos(yawRadians) + x * Math.sin(yawRadians);
        }
        return this;
    }

    public Pos3D rotatePitch(double pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double y = this.yPos;
        double z = this.zPos;
        if (pitch != 0.0) {
            this.yPos = y * Math.cos(pitchRadians) - z * Math.sin(pitchRadians);
            this.zPos = z * Math.cos(pitchRadians) + y * Math.sin(pitchRadians);
        }
        return this;
    }

    public Pos3D rotate(double yaw, double pitch) {
        return this.rotate(yaw, pitch, 0.0);
    }

    public Pos3D rotate(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double x = this.xPos;
        double y = this.yPos;
        double z = this.zPos;
        this.xPos = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        this.zPos = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        this.yPos = -x * Math.sin(pitchRadians) + z * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return this;
    }

    public Pos3D multiply(Pos3D pos) {
        this.xPos *= pos.xPos;
        this.yPos *= pos.yPos;
        this.zPos *= pos.zPos;
        return this;
    }

    public Pos3D scale(double x, double y, double z) {
        this.xPos *= x;
        this.yPos *= y;
        this.zPos *= z;
        return this;
    }

    public Pos3D scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.clone().normalize();
        double x = axis.xPos;
        double y = axis.yPos;
        double z = axis.zPos;
        angle = (float)((double)angle * 0.0174532925);
        float cos = (float)Math.cos(angle);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angle);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.xPos * matrix[0] + translation.yPos * matrix[1] + translation.zPos * matrix[2] + matrix[3];
        double y = translation.xPos * matrix[4] + translation.yPos * matrix[5] + translation.zPos * matrix[6] + matrix[7];
        double z = translation.xPos * matrix[8] + translation.yPos * matrix[9] + translation.zPos * matrix[10] + matrix[11];
        translation.xPos = x;
        translation.yPos = y;
        translation.zPos = z;
        return translation;
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.dotProduct(pos2));
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.clone().dotProduct(pos2));
    }

    public double dotProduct(Pos3D pos) {
        return this.xPos * pos.xPos + this.yPos * pos.yPos + this.zPos * pos.zPos;
    }

    public Pos3D crossProduct(Pos3D compare) {
        return this.clone().toCrossProduct(compare);
    }

    public Pos3D toCrossProduct(Pos3D compare) {
        double newX = this.yPos * compare.zPos - this.zPos * compare.yPos;
        double newY = this.zPos * compare.xPos - this.xPos * compare.zPos;
        double newZ = this.xPos * compare.yPos - this.yPos * compare.xPos;
        this.xPos = newX;
        this.yPos = newY;
        this.zPos = newZ;
        return this;
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.zPos, -this.yPos);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.yPos, this.xPos, 0.0);
    }

    public Pos3D getPerpendicular() {
        if (this.zPos == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.xPos), Math.floor(this.yPos), Math.floor(this.zPos));
    }

    public double getMagnitude() {
        return Math.sqrt(this.xPos * this.xPos + this.yPos * this.yPos + this.zPos * this.zPos);
    }

    public Pos3D normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.scale(1.0 / d);
        }
        return this;
    }

    public static AxisAlignedBB getAABB(Pos3D pos1, Pos3D pos2) {
        return AxisAlignedBB.func_72330_a((double)Math.min(pos1.xPos, pos2.xPos), (double)Math.min(pos1.yPos, pos2.yPos), (double)Math.min(pos1.zPos, pos2.zPos), (double)Math.max(pos1.xPos, pos2.xPos), (double)Math.max(pos1.yPos, pos2.yPos), (double)Math.max(pos1.zPos, pos2.zPos));
    }

    public Pos3D clone() {
        return new Pos3D(this.xPos, this.yPos, this.zPos);
    }

    public String toString() {
        return "[Pos3D: " + this.xPos + ", " + this.yPos + ", " + this.zPos + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Pos3D && ((Pos3D)obj).xPos == this.xPos && ((Pos3D)obj).yPos == this.yPos && ((Pos3D)obj).zPos == this.zPos;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + new Double(this.xPos).hashCode();
        code = 31 * code + new Double(this.yPos).hashCode();
        code = 31 * code + new Double(this.zPos).hashCode();
        return code;
    }
}

