/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ElectrolyticSeparatorRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public GuiFluidGauge fluidInput;
    public GuiGasGauge leftGas;
    public GuiGasGauge rightGas;
    public static int xOffset = 5;
    public static int yOffset = 9;

    @Override
    public void addGuiElements() {
        this.fluidInput = GuiFluidGauge.getDummy(GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 5, 10);
        this.guiElements.add(this.fluidInput);
        this.leftGas = GuiGasGauge.getDummy(GuiGauge.Type.SMALL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 58, 18);
        this.guiElements.add(this.leftGas);
        this.rightGas = GuiGasGauge.getDummy(GuiGauge.Type.SMALL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 100, 18);
        this.guiElements.add(this.rightGas);
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return ElectrolyticSeparatorRecipeHandler.this.ticksPassed <= 20 ? (double)((float)ElectrolyticSeparatorRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 25, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 58, 51));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 100, 51));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return 1.0;
            }
        }, GuiProgress.ProgressBar.BI, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 78, 29));
    }

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock2.ElectrolyticSeparator.name");
    }

    public String getOverlayIdentifier() {
        return "electrolyticseparator";
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiElectrolyticSeparator.png";
    }

    public Class getGuiClass() {
        return GuiElectrolyticSeparator.class;
    }

    public String getRecipeId() {
        return "mekanism.electrolyticseparator";
    }

    public Collection<SeparatorRecipe> getRecipes() {
        return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-1, (int)0, (int)4, (int)yOffset, (int)167, (int)62);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -xOffset, -yOffset);
        }
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        if (recipe.fluidInput != null) {
            this.fluidInput.setDummyType(recipe.fluidInput.ingredient.getFluid());
            this.fluidInput.renderScale(0, 0, -xOffset, -yOffset);
        }
        if (recipe.outputPair.leftGas != null) {
            this.displayGauge(28, 59 - xOffset, 19 - yOffset, 176, 68, 28, null, recipe.outputPair.leftGas);
            this.leftGas.setDummyType(recipe.outputPair.leftGas.getGas());
            this.leftGas.renderScale(0, 0, -xOffset, -yOffset);
        }
        if (recipe.outputPair.rightGas != null) {
            this.displayGauge(28, 101 - xOffset, 19 - yOffset, 176, 68, 28, null, recipe.outputPair.rightGas);
            this.rightGas.setDummyType(recipe.outputPair.rightGas.getGas());
            this.rightGas.renderScale(0, 0, -xOffset, -yOffset);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(80 - xOffset, 30 - yOffset, 16, 6), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (SeparatorRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (SeparatorRecipe irecipe : this.getRecipes()) {
                if (!((ChemicalPairOutput)irecipe.recipeOutput).containsType((GasStack)results[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            for (SeparatorRecipe irecipe : this.getRecipes()) {
                if (!((FluidInput)irecipe.recipeInput).ingredient.isFluidEqual((FluidStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(LangUtils.localizeFluidStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput.ingredient));
        } else if (xAxis >= 59 && xAxis <= 75 && yAxis >= 26 && yAxis <= 54) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.leftGas.getGas().getLocalizedName());
        } else if (xAxis >= 101 && xAxis <= 117 && yAxis >= 26 && yAxis <= 54) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.rightGas.getGas().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            fluid = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput.ingredient;
        } else if (xAxis >= 59 && xAxis <= 75 && yAxis >= 26 && yAxis <= 54) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.leftGas;
        } else if (xAxis >= 101 && xAxis <= 117 && yAxis >= 26 && yAxis <= 54) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.rightGas;
        }
        if (gas != null ? (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(gas, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(gas, true)) : fluid != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(fluid, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            fluid = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput.ingredient;
        } else if (xAxis >= 59 && xAxis <= 75 && yAxis >= 26 && yAxis <= 54) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.leftGas;
        } else if (xAxis >= 101 && xAxis <= 117 && yAxis >= 26 && yAxis <= 54) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputPair.rightGas;
        }
        if (gas != null ? (button == 0 ? this.doGasLookup(gas, false) : button == 1 && this.doGasLookup(gas, true)) : fluid != null && (button == 0 ? this.doFluidLookup(fluid, false) : button == 1 && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public FluidInput fluidInput;
        public ChemicalPairOutput outputPair;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(FluidInput input, ChemicalPairOutput pair) {
            super((TemplateRecipeHandler)ElectrolyticSeparatorRecipeHandler.this);
            this.fluidInput = input;
            this.outputPair = pair;
        }

        public CachedIORecipe(SeparatorRecipe recipe) {
            this((FluidInput)recipe.recipeInput, (ChemicalPairOutput)recipe.recipeOutput);
        }
    }
}

