/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PartPressurizedTube
extends PartTransmitter<IGasHandler, GasNetwork>
implements IGasHandler {
    public Tier.TubeTier tier = Tier.TubeTier.BASIC;
    public static TransmitterIcons tubeIcons = new TransmitterIcons(4, 8);
    public float currentScale;
    public GasTank buffer = new GasTank(this.getCapacity());
    public GasStack lastWrite;

    public PartPressurizedTube(Tier.TubeTier tubeTier) {
        this.tier = tubeTier;
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            this.updateShare();
            IGasHandler[] connectedAcceptors = GasTransmission.getConnectedAcceptors((TileEntity)this.tile());
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                GasStack received;
                IGasHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drawGas(side.getOpposite(), this.tier.tubePullAmount, false)) == null || received.amount == 0) continue;
                container.drawGas(side.getOpposite(), this.takeGas(received, true), true);
            }
        } else {
            float targetScale;
            float f = targetScale = ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() ? ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).gasScale : (float)this.buffer.getStored() / (float)this.buffer.getMaxGas();
            if ((double)Math.abs(this.currentScale - targetScale) > 0.01) {
                this.currentScale = (9.0f * this.currentScale + targetScale) / 10.0f;
            }
        }
        super.update();
    }

    @Override
    public void updateShare() {
        GasStack last;
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((Transmitter)this.getTransmitter()).getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getGas() != last.getGas()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            MekanismUtils.saveChunk((TileEntity)this.tile());
        }
    }

    private GasStack getSaveShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            int remain = ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount % ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            int toSave = ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount / ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return new GasStack(((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.getGas(), toSave);
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K && ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && this.lastWrite != null && ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount <= 0) {
                ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.tier = Tier.TubeTier.values()[nbtTags.func_74762_e("tier")];
        this.buffer.setMaxGas(this.getCapacity());
        if (nbtTags.func_74764_b("cacheGas")) {
            this.buffer.setGas(GasStack.readFromNBT(nbtTags.func_74775_l("cacheGas")));
        } else {
            this.buffer.setGas(null);
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheGas", (NBTBase)this.lastWrite.write(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheGas");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:pressurized_tube_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        tubeIcons.registerCenterIcons(register, new String[]{"PressurizedTubeBasic", "PressurizedTubeAdvanced", "PressurizedTubeElite", "PressurizedTubeUltimate"});
        tubeIcons.registerSideIcons(register, new String[]{"PressurizedTubeVerticalBasic", "PressurizedTubeVerticalAdvanced", "PressurizedTubeVerticalElite", "PressurizedTubeVerticalUltimate", "PressurizedTubeHorizontalBasic", "PressurizedTubeHorizontalAdvanced", "PressurizedTubeHorizontalElite", "PressurizedTubeHorizontalUltimate"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return tubeIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return tubeIcons.getSideIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return tubeIcons.getSideIcon(4 + this.tier.ordinal());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return GasTransmission.canConnect(tile, side);
    }

    @Override
    public GasNetwork createNewNetwork() {
        return new GasNetwork();
    }

    @Override
    public GasNetwork createNetworkByMerging(Collection<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0 && !MekanismConfig.client.opaqueTransmitters) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public int getCapacity() {
        return this.tier.tubeCapacity;
    }

    @Override
    public GasStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getGas();
    }

    @Override
    public void takeShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setGas(this.lastWrite);
        }
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL) {
            return this.takeGas(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    public int takeGas(GasStack gasStack, boolean doEmit) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).emit(gasStack, doEmit);
        }
        return this.buffer.receive(gasStack, doEmit);
    }

    @Override
    public IGasHandler getCachedAcceptor(ForgeDirection side) {
        if (this.cachedAcceptors[side.ordinal()] instanceof IGasHandler) {
            return (IGasHandler)super.getCachedAcceptor(side);
        }
        return null;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.TubeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.tier = Tier.TubeTier.values()[packet.readInt()];
        super.readDesc(packet);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeDesc(packet);
    }
}

