/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.entity.EntityRobit;
import net.minecraft.entity.player.EntityPlayer;

public class PacketRobit
implements IMessageHandler<RobitMessage, IMessage> {
    public IMessage onMessage(RobitMessage message, MessageContext context) {
        EntityRobit robit;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.activeType == RobitPacketType.GUI) {
            if (message.guiType == 0) {
                player.openGui((Object)Mekanism.instance, 21, player.field_70170_p, message.entityId, 0, 0);
            } else if (message.guiType == 1) {
                player.openGui((Object)Mekanism.instance, 22, player.field_70170_p, message.entityId, 0, 0);
            } else if (message.guiType == 2) {
                player.openGui((Object)Mekanism.instance, 23, player.field_70170_p, message.entityId, 0, 0);
            } else if (message.guiType == 3) {
                player.openGui((Object)Mekanism.instance, 24, player.field_70170_p, message.entityId, 0, 0);
            } else if (message.guiType == 4) {
                player.openGui((Object)Mekanism.instance, 25, player.field_70170_p, message.entityId, 0, 0);
            }
        } else if (message.activeType == RobitPacketType.FOLLOW) {
            EntityRobit robit2 = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId);
            if (robit2 != null) {
                robit2.setFollowing(!robit2.getFollowing());
            }
        } else if (message.activeType == RobitPacketType.NAME) {
            EntityRobit robit3 = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId);
            if (robit3 != null) {
                robit3.setName(message.name);
            }
        } else if (message.activeType == RobitPacketType.GO_HOME) {
            EntityRobit robit4 = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId);
            if (robit4 != null) {
                robit4.goHome();
            }
        } else if (message.activeType == RobitPacketType.DROP_PICKUP && (robit = (EntityRobit)player.field_70170_p.func_73045_a(message.entityId)) != null) {
            robit.setDropPickup(!robit.getDropPickup());
        }
        return null;
    }

    public static enum RobitPacketType {
        GUI,
        FOLLOW,
        NAME,
        GO_HOME,
        DROP_PICKUP;

    }

    public static class RobitMessage
    implements IMessage {
        public RobitPacketType activeType;
        public int guiType;
        public int entityId;
        public String name;

        public RobitMessage() {
        }

        public RobitMessage(RobitPacketType type, int i1, int i2, String s) {
            this.activeType = type;
            switch (this.activeType) {
                case GUI: {
                    this.guiType = i1;
                    this.entityId = i2;
                    break;
                }
                case FOLLOW: {
                    this.entityId = i1;
                    break;
                }
                case NAME: {
                    this.name = s;
                    this.entityId = i1;
                    break;
                }
                case GO_HOME: {
                    this.entityId = i1;
                    break;
                }
                case DROP_PICKUP: {
                    this.entityId = i1;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.activeType.ordinal());
            switch (this.activeType) {
                case GUI: {
                    dataStream.writeInt(this.guiType);
                    dataStream.writeInt(this.entityId);
                    break;
                }
                case FOLLOW: {
                    dataStream.writeInt(this.entityId);
                    break;
                }
                case NAME: {
                    PacketHandler.writeString(dataStream, this.name);
                    dataStream.writeInt(this.entityId);
                    break;
                }
                case GO_HOME: {
                    dataStream.writeInt(this.entityId);
                    break;
                }
                case DROP_PICKUP: {
                    dataStream.writeInt(this.entityId);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.activeType = RobitPacketType.values()[dataStream.readInt()];
            if (this.activeType == RobitPacketType.GUI) {
                this.guiType = dataStream.readInt();
                this.entityId = dataStream.readInt();
            } else if (this.activeType == RobitPacketType.FOLLOW) {
                this.entityId = dataStream.readInt();
            } else if (this.activeType == RobitPacketType.NAME) {
                this.name = PacketHandler.readString(dataStream);
                this.entityId = dataStream.readInt();
            } else if (this.activeType == RobitPacketType.GO_HOME) {
                this.entityId = dataStream.readInt();
            } else if (this.activeType == RobitPacketType.DROP_PICKUP) {
                this.entityId = dataStream.readInt();
            }
        }
    }
}

