/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketScubaTankData
implements IMessageHandler<ScubaTankDataMessage, IMessage> {
    public IMessage onMessage(ScubaTankDataMessage message, MessageContext context) {
        ItemStack stack;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == ScubaTankPacket.UPDATE) {
            if (message.value) {
                Mekanism.gasmaskOn.add(message.username);
            } else {
                Mekanism.gasmaskOn.remove(message.username);
            }
            if (!player.field_70170_p.field_72995_K) {
                Mekanism.packetHandler.sendToDimension(new ScubaTankDataMessage(ScubaTankPacket.UPDATE, message.username, message.value), player.field_70170_p.field_73011_w.field_76574_g);
            }
        } else if (message.packetType == ScubaTankPacket.MODE && (stack = player.func_71124_b(3)) != null && stack.func_77973_b() instanceof ItemScubaTank) {
            ((ItemScubaTank)stack.func_77973_b()).toggleFlowing(stack);
        }
        return null;
    }

    public static enum ScubaTankPacket {
        UPDATE,
        FULL,
        MODE;

    }

    public static class ScubaTankDataMessage
    implements IMessage {
        public ScubaTankPacket packetType;
        public String username;
        public boolean value;

        public ScubaTankDataMessage() {
        }

        public ScubaTankDataMessage(ScubaTankPacket type, String name, boolean state) {
            this.packetType = type;
            if (this.packetType == ScubaTankPacket.UPDATE) {
                this.username = name;
                this.value = state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == ScubaTankPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.username);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == ScubaTankPacket.FULL) {
                dataStream.writeInt(Mekanism.gasmaskOn.size());
                Set<String> set = Mekanism.gasmaskOn;
                synchronized (set) {
                    for (String name : Mekanism.gasmaskOn) {
                        PacketHandler.writeString(dataStream, name);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ScubaTankPacket.values()[dataStream.readInt()];
            if (this.packetType == ScubaTankPacket.FULL) {
                Mekanism.gasmaskOn.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.gasmaskOn.add(PacketHandler.readString(dataStream));
                }
            } else if (this.packetType == ScubaTankPacket.UPDATE) {
                this.username = PacketHandler.readString(dataStream);
                this.value = dataStream.readBoolean();
            }
        }
    }
}

