/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.EnergyNetwork;
import mekanism.common.FluidNetwork;
import mekanism.common.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketTransmitterUpdate
implements IMessageHandler<TransmitterUpdateMessage, IMessage> {
    public IMessage onMessage(TransmitterUpdateMessage message, MessageContext context) {
        DynamicNetwork net;
        IGridTransmitter transmitter;
        TileEntity tileEntity;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == PacketType.UPDATE && (tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p)) instanceof ITransmitterTile) {
            transmitter = ((ITransmitterTile)tileEntity).getTransmitter();
            Object network = transmitter.hasTransmitterNetwork() && !message.newNetwork ? transmitter.getTransmitterNetwork() : transmitter.createEmptyNetwork();
            ((DynamicNetwork)network).register();
            transmitter.setTransmitterNetwork(network);
            for (Coord4D coord : message.transmitterCoords) {
                TileEntity tile = coord.getTileEntity((IBlockAccess)player.field_70170_p);
                if (!(tile instanceof ITransmitterTile)) continue;
                ((ITransmitterTile)tile).getTransmitter().setTransmitterNetwork(network);
            }
            ((DynamicNetwork)network).updateCapacity();
        }
        if (MekanismConfig.client.opaqueTransmitters) {
            return null;
        }
        if (message.packetType == PacketType.ENERGY) {
            tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity instanceof ITransmitterTile && (transmitter = ((ITransmitterTile)tileEntity).getTransmitter()).hasTransmitterNetwork() && transmitter.getTransmissionType() == TransmissionType.ENERGY) {
                ((EnergyNetwork)transmitter.getTransmitterNetwork()).clientEnergyScale = message.power;
            }
        } else if (message.packetType == PacketType.GAS) {
            tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity instanceof ITransmitterTile && (transmitter = ((ITransmitterTile)tileEntity).getTransmitter()).hasTransmitterNetwork() && transmitter.getTransmissionType() == TransmissionType.GAS) {
                net = (GasNetwork)transmitter.getTransmitterNetwork();
                if (message.gasType != null) {
                    net.refGas = message.gasType;
                }
                net.buffer = message.gasStack;
                net.didTransfer = message.didGasTransfer;
            }
        } else if (message.packetType == PacketType.FLUID && (tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p)) instanceof ITransmitterTile && (transmitter = ((ITransmitterTile)tileEntity).getTransmitter()).hasTransmitterNetwork() && ((ITransmitterTile)tileEntity).getTransmitter().getTransmissionType() == TransmissionType.FLUID) {
            net = (FluidNetwork)transmitter.getTransmitterNetwork();
            if (message.fluidType != null) {
                ((FluidNetwork)net).refFluid = message.fluidType;
            }
            ((FluidNetwork)net).buffer = message.fluidStack;
            ((FluidNetwork)net).didTransfer = message.didFluidTransfer;
        }
        return null;
    }

    public static enum PacketType {
        UPDATE,
        ENERGY,
        GAS,
        FLUID;

    }

    public static class TransmitterUpdateMessage
    implements IMessage {
        public PacketType packetType;
        public Coord4D coord4D;
        public double power;
        public GasStack gasStack;
        public Gas gasType;
        public boolean didGasTransfer;
        public FluidStack fluidStack;
        public Fluid fluidType;
        public float fluidScale;
        public boolean didFluidTransfer;
        public int amount;
        public boolean newNetwork;
        public Collection<IGridTransmitter> transmittersAdded;
        public Collection<Coord4D> transmitterCoords;

        public TransmitterUpdateMessage() {
        }

        public TransmitterUpdateMessage(PacketType type, Coord4D coord, Object ... data) {
            this.packetType = type;
            this.coord4D = coord;
            switch (this.packetType) {
                case UPDATE: {
                    this.newNetwork = (Boolean)data[0];
                    this.transmittersAdded = (Collection)data[1];
                    break;
                }
                case ENERGY: {
                    this.power = (Double)data[0];
                    break;
                }
                case GAS: {
                    this.gasStack = (GasStack)data[0];
                    this.didGasTransfer = (Boolean)data[1];
                    break;
                }
                case FLUID: {
                    this.fluidStack = (FluidStack)data[0];
                    this.didFluidTransfer = (Boolean)data[1];
                    break;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            PacketHandler.log("Sending '" + (Object)((Object)this.packetType) + "' update message from coordinate " + this.coord4D);
            switch (this.packetType) {
                case UPDATE: {
                    dataStream.writeBoolean(this.newNetwork);
                    dataStream.writeInt(this.transmittersAdded.size());
                    for (IGridTransmitter transmitter : this.transmittersAdded) {
                        transmitter.coord().write(dataStream);
                    }
                    break;
                }
                case ENERGY: {
                    dataStream.writeDouble(this.power);
                    break;
                }
                case GAS: {
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.getGas().getID() : -1);
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.amount : 0);
                    dataStream.writeBoolean(this.didGasTransfer);
                    break;
                }
                case FLUID: {
                    dataStream.writeInt(this.fluidStack != null ? this.fluidStack.getFluid().getID() : -1);
                    dataStream.writeInt(this.fluidStack != null ? this.fluidStack.amount : 0);
                    dataStream.writeBoolean(this.didFluidTransfer);
                    break;
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = PacketType.values()[dataStream.readInt()];
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            if (this.packetType == PacketType.UPDATE) {
                this.newNetwork = dataStream.readBoolean();
                this.transmitterCoords = new HashSet<Coord4D>();
                int numTransmitters = dataStream.readInt();
                for (int i = 0; i < numTransmitters; ++i) {
                    this.transmitterCoords.add(Coord4D.read(dataStream));
                }
            } else if (this.packetType == PacketType.ENERGY) {
                this.power = dataStream.readDouble();
            } else if (this.packetType == PacketType.GAS) {
                this.gasType = GasRegistry.getGas(dataStream.readInt());
                this.amount = dataStream.readInt();
                this.didGasTransfer = dataStream.readBoolean();
                if (this.gasType != null) {
                    this.gasStack = new GasStack(this.gasType, this.amount);
                }
            } else if (this.packetType == PacketType.FLUID) {
                int type = dataStream.readInt();
                this.fluidType = type != -1 ? FluidRegistry.getFluid((int)type) : null;
                this.amount = dataStream.readInt();
                this.didFluidTransfer = dataStream.readBoolean();
                if (this.fluidType != null) {
                    this.fluidStack = new FluidStack(this.fluidType, this.amount);
                }
            }
        }
    }
}

