/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityResistiveHeater
extends TileEntityNoisyElectricBlock
implements IHeatTransfer,
IComputerIntegration,
IRedstoneControl,
ISecurityTile {
    public double energyUsage = 100.0;
    public double temperature;
    public double heatToAbsorb = 0.0;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public float soundScale = 1.0f;
    public double lastEnvironmentLoss;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    private static final String[] methods = new String[]{"getEnergy", "getMaxEnergy", "getTemperature", "setEnergyUsage"};

    public TileEntityResistiveHeater() {
        super("machine.resistiveheater", "ResistiveHeater", BlockMachine.MachineType.RESISTIVE_HEATER.baseEnergy);
        this.inventory = new ItemStack[1];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean packet = false;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    packet = true;
                }
            }
            ChargeUtils.discharge(0, this);
            double toUse = 0.0;
            if (MekanismUtils.canFunction(this)) {
                toUse = Math.min(this.getEnergy(), this.energyUsage);
                this.heatToAbsorb += toUse / MekanismConfig.general.energyPerHeat;
                this.setEnergy(this.getEnergy() - toUse);
            }
            this.setActive(toUse > 0.0);
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastEnvironmentLoss = loss[1];
            float newSoundScale = (float)Math.max(0.0, toUse / 100000.0);
            if ((double)Math.abs(newSoundScale - this.soundScale) > 0.01) {
                packet = true;
            }
            this.soundScale = newSoundScale;
            if (packet) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(MekanismUtils.getLeft(this.facing), MekanismUtils.getRight(this.facing));
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * Math.max(0.001f, this.soundScale);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.energyUsage = nbtTags.func_74769_h("energyUsage");
        this.temperature = nbtTags.func_74769_h("temperature");
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.maxEnergy = this.energyUsage * 400.0;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74780_a("energyUsage", this.energyUsage);
        nbtTags.func_74780_a("temperature", this.temperature);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            this.energyUsage = MekanismUtils.convertToJoules(dataStream.readInt());
            this.maxEnergy = this.energyUsage * 400.0;
            return;
        }
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.energyUsage = dataStream.readDouble();
            this.temperature = dataStream.readDouble();
            this.clientActive = dataStream.readBoolean();
            this.maxEnergy = dataStream.readDouble();
            this.soundScale = dataStream.readFloat();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.lastEnvironmentLoss = dataStream.readDouble();
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.energyUsage);
        data.add(this.temperature);
        data.add(this.isActive);
        data.add(this.maxEnergy);
        data.add(Float.valueOf(this.soundScale));
        data.add(this.controlType.ordinal());
        data.add(this.lastEnvironmentLoss);
        return data;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 1000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (adj instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 2: {
                return new Object[]{this.temperature};
            }
            case 3: {
                if (arguments.length == 1 && arguments[0] instanceof Double) {
                    this.temperature = (Double)arguments[0];
                }
                return new Object[]{"Invalid parameters."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

