/*
 * Decompiled with CFR 0.152.
 */
package gravigun.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.relauncher.Side;
import gravigun.common.core.CommonProxy;
import gravigun.common.core.EventHandler;
import gravigun.common.core.Settings;
import gravigun.common.packet.PacketGrabEntity;
import gravigun.common.packet.PacketKeybindId;
import gravigun.common.packet.PacketWorldProps;
import ichun.common.core.network.ChannelHandler;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import portalgun.common.PortalGun;

@Mod(modid="GraviGun", name="GraviGun", version="4.0.0-beta", dependencies="required-after:iChunUtil@[4.2.2,)")
public class GraviGun {
    public static final String version = "4.0.0-beta";
    public static Item itemGraviGun;
    @Mod.Instance(value="GraviGun")
    public static GraviGun instance;
    @SidedProxy(clientSide="gravigun.client.core.ClientProxy", serverSide="gravigun.common.core.CommonProxy")
    public static CommonProxy proxy;
    private static final Logger logger;
    public static boolean hasPortalGun;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        proxy.setupAndLoadProperties(event.getModConfigurationDirectory());
        proxy.initSounds();
        channels = ChannelHandler.getChannelHandlers((String)"GraviGun", (Class[])new Class[]{PacketKeybindId.class, PacketGrabEntity.class, PacketWorldProps.class});
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("GravityGun", "1.7.10", version, false));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.initMod();
        proxy.initTickHandlers();
        EventHandler handler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
        proxy.initRenderersAndTextures();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.clearMaps();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.clearMaps();
    }

    public void clearMaps() {
        GraviGun.proxy.tickHandlerServer.grabMap.clear();
        GraviGun.proxy.tickHandlerServer.tossedEntities.clear();
        GraviGun.proxy.tickHandlerServer.tosser.clear();
        GraviGun.proxy.tickHandlerServer.chargedThrow.clear();
        GraviGun.proxy.tickHandlerServer.holdingKey.clear();
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equals("addBlockIDToGrabList")) {
                GraviGun.console("Received mod blacklist request from: " + m.getSender());
                Settings.setBlockIdsToMap(Settings.modBlockIds, m.getStringValue(), false);
            }
            if (!m.key.equals("PortalGun")) continue;
            GraviGun.proxy.tickHandlerServer.grabMap = PortalGun.proxy.tickHandlerServer.grabMap;
            if (GraviGun.proxy.tickHandlerClient != null) {
                GraviGun.proxy.tickHandlerClient.grabMap = PortalGun.proxy.tickHandlerClient.grabMap;
            }
            hasPortalGun = true;
        }
    }

    public static void addBlockIDToGrabList(int i, int[] i1) {
        if (i1 == null) {
            Settings.modBlockIds.remove(i);
            GraviGun.console("Removed Block ID " + i + " from grabbing blacklist.");
        } else {
            Settings.modBlockIds.put(i, i1);
            GraviGun.console("Added Block ID " + i + " to grabbing blacklist. " + (i1.length != 0 && i1[0] == -1 ? "Not metadata specific." : "Metadata specific: " + Settings.intArrayToString(i1)));
        }
    }

    public static int getSettings(String s) {
        return Settings.getSettings(s);
    }

    public static int[] getBlockMetaInMap(Map map, Block i) {
        return Settings.getBlockMetaInMap(map, i);
    }

    public static boolean isGrabbed(Entity ent) {
        if (ent.field_70170_p.field_72995_K) {
            return GraviGun.proxy.tickHandlerClient.grabMap.containsValue(ent.func_145782_y());
        }
        return GraviGun.proxy.tickHandlerServer.grabMap.containsValue(ent);
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }

    public static void console(String s) {
        GraviGun.console(s, false);
    }

    public static void console(int i) {
        GraviGun.console(new Integer(i).toString());
    }

    public static void console(boolean b) {
        GraviGun.console(new Boolean(b).toString());
    }

    public static void console(float f) {
        GraviGun.console(new Float(f).toString());
    }

    public static void console(double d) {
        GraviGun.console(new Double(d).toString());
    }

    static {
        logger = LogManager.getLogger((String)"GraviGun");
        hasPortalGun = false;
    }
}

