/*
 * Decompiled with CFR 0.152.
 */
package gravigun.common.core;

import gravigun.common.GraviGun;
import gravigun.common.core.Settings;
import gravigun.common.entity.EntityBlock;
import ichun.common.core.EntityHelperBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.MovingObjectPosition;

public class EntityHelper
extends EntityHelperBase {
    public static boolean canGrab(Entity ent) {
        boolean grabable = false;
        if (!(ent instanceof EntityPainting) && !(ent instanceof EntityPlayer) && !(ent instanceof EntityDragon) && !(ent instanceof EntityDragonPart) || ent instanceof EntityPlayer && GraviGun.getSettings("grabablePlayers") == 1) {
            if (ent instanceof EntityBlock && !((EntityBlock)ent).dummy) {
                grabable = true;
            } else if (GraviGun.getSettings("grabEntityMode") == 1) {
                grabable = true;
            } else if (GraviGun.getSettings("grabEntityMode") == 2 && ent instanceof EntityLivingBase) {
                grabable = true;
            }
        }
        return grabable;
    }

    public static void tryGrab(EntityLivingBase ent, boolean isGun) {
        MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)ent, (double)4.0);
        boolean grabSuccess = false;
        if (isGun) {
            if (mop != null && mop.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
                if (mop.field_72308_g == null) {
                    Block bId = ent.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    if (bId != Blocks.field_150350_a && bId.func_149712_f(ent.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) >= 0.0f) {
                        int[] modMeta;
                        boolean grabable = true;
                        int[] meta = GraviGun.getBlockMetaInMap(Settings.grabBlockIds, bId);
                        if (GraviGun.getSettings("grabBlockWhitelist") == 1) {
                            grabable = false;
                        }
                        if (meta != null) {
                            int j1;
                            int blockMeta = ent.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            if (GraviGun.getSettings("grabBlockWhitelist") == 1) {
                                if (meta.length != 0 && meta[0] == -1) {
                                    grabable = true;
                                }
                                for (j1 = 0; j1 < meta.length; ++j1) {
                                    if (blockMeta != meta[j1]) continue;
                                    grabable = true;
                                    break;
                                }
                            } else if (meta.length != 0 && meta[0] == -1) {
                                grabable = false;
                            } else {
                                for (j1 = 0; j1 < meta.length; ++j1) {
                                    if (blockMeta != meta[j1]) continue;
                                    grabable = false;
                                    break;
                                }
                            }
                        }
                        if ((modMeta = GraviGun.getBlockMetaInMap(Settings.modBlockIds, bId)) != null) {
                            int blockMeta = ent.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            if (modMeta.length != 0 && modMeta[0] == -1) {
                                grabable = false;
                            } else {
                                for (int j1 = 0; j1 < modMeta.length; ++j1) {
                                    if (blockMeta != modMeta[j1]) continue;
                                    grabable = false;
                                    break;
                                }
                            }
                        }
                        if (grabable && (!(ent instanceof EntityZombie) || ent instanceof EntityZombie && ent.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) && (ent.field_70170_p.func_147445_c(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false) || bId.func_149645_b() == 22 && GraviGun.getSettings("grabChestTypeAllowed") == 1 || bId == Blocks.field_150359_w || bId == Blocks.field_150426_aN || bId == Blocks.field_150414_aQ || bId == Blocks.field_150335_W || bId == Blocks.field_150432_aD || bId instanceof BlockSlab || bId == Blocks.field_150467_bQ) && (ent instanceof EntityZombie || GraviGun.getSettings("graviGunFuel") == 1 || GraviGun.getSettings("graviGunFuel") != 1)) {
                            EntityBlock entBlock = new EntityBlock(ent.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
                            ent.field_70170_p.func_72838_d((Entity)entBlock);
                            GraviGun.proxy.tickHandlerServer.setGrabbed(ent, entBlock);
                            grabSuccess = true;
                        }
                    }
                } else if (ent.field_70154_o != mop.field_72308_g && ent.field_70153_n != mop.field_72308_g && EntityHelper.canGrab(mop.field_72308_g) && (ent instanceof EntityZombie || GraviGun.getSettings("graviGunFuel") == 1 || GraviGun.getSettings("graviGunFuel") != 1)) {
                    if (mop.field_72308_g.field_70154_o != null) {
                        GraviGun.proxy.tickHandlerServer.setGrabbed(ent, mop.field_72308_g.field_70154_o);
                    } else {
                        GraviGun.proxy.tickHandlerServer.setGrabbed(ent, mop.field_72308_g);
                    }
                    grabSuccess = true;
                }
            } else if (ent instanceof EntityPlayer && !GraviGun.proxy.tickHandlerServer.holdingKey.contains(ent)) {
                GraviGun.proxy.tickHandlerServer.holdingKey.add((EntityPlayer)ent);
            }
            if (grabSuccess) {
                ent.field_70170_p.func_72956_a((Entity)ent, "gravigun:pickup", 0.3f, 1.0f);
            }
        }
    }

    public static void tryThrow(EntityLivingBase ent, boolean isGun) {
        if (isGun && (ent instanceof EntityZombie || GraviGun.getSettings("graviGunFuel") == 1 || GraviGun.getSettings("graviGunFuel") != 1)) {
            Entity grabbed = GraviGun.proxy.tickHandlerServer.getGrabbed(ent);
            if (grabbed == null) {
                MovingObjectPosition mop = EntityHelper.getEntityLook((EntityLivingBase)ent, (double)(ent instanceof EntityPlayer ? (((EntityPlayer)ent).func_71045_bC().func_77960_j() == 0 ? 10.0 : 15.0) : (((EntityZombie)ent).func_70694_bm().func_77960_j() == 0 ? 10.0 : 15.0)));
                if (mop != null && mop.field_72308_g != null && EntityHelper.canGrab(mop.field_72308_g)) {
                    grabbed = mop.field_72308_g;
                }
            } else {
                GraviGun.proxy.tickHandlerServer.setGrabbed(ent, null);
            }
            ent.field_70170_p.func_72956_a((Entity)ent, "gravigun:fire", 0.3f, 1.0f);
            if (grabbed != null) {
                double dist = ent.func_70032_d(grabbed);
                if (dist < 3.0) {
                    dist = 3.0;
                }
                double distX = grabbed.field_70165_t - ent.field_70165_t;
                double distY = (grabbed.field_70121_D.field_72337_e + grabbed.field_70121_D.field_72338_b) / 2.0 - (ent.field_70163_u + (double)ent.func_70047_e());
                double distZ = grabbed.field_70161_v - ent.field_70161_v;
                double amp = (ent instanceof EntityPlayer ? (((EntityPlayer)ent).func_71045_bC().func_77960_j() == 0 ? 10.0 : 12.0) : (((EntityZombie)ent).func_70694_bm().func_77960_j() == 0 ? 10.0 : 12.0)) / dist;
                grabbed.func_70024_g(distX *= (amp *= 0.3), distY *= 0.52, distZ *= amp);
                if (grabbed instanceof EntityPlayerMP) {
                    EntityPlayerMP player1 = (EntityPlayerMP)grabbed;
                    player1.field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(player1.func_145782_y(), player1.field_70159_w, player1.field_70181_x, player1.field_70179_y));
                } else if (grabbed instanceof EntityCreeper) {
                    GraviGun.proxy.tickHandlerServer.chargedThrow.put((EntityCreeper)grabbed, ent instanceof EntityPlayer ? ((EntityPlayer)ent).func_71045_bC().func_77960_j() != 0 : ((EntityZombie)ent).func_70694_bm().func_77960_j() != 0);
                } else if (grabbed instanceof EntityFireball) {
                    EntityFireball fireball = (EntityFireball)grabbed;
                    fireball.field_70232_b = fireball.field_70159_w / 8.0;
                    fireball.field_70233_c = fireball.field_70181_x / 8.0 - 0.03;
                    fireball.field_70230_d = fireball.field_70179_y / 8.0;
                }
                if (!grabbed.field_70132_H) {
                    GraviGun.proxy.tickHandlerServer.tossedEntities.put(grabbed, Math.sqrt(grabbed.field_70159_w * grabbed.field_70159_w + grabbed.field_70181_x * grabbed.field_70181_x + grabbed.field_70179_y * grabbed.field_70179_y));
                    GraviGun.proxy.tickHandlerServer.tosser.put(grabbed, ent);
                }
            }
        }
    }
}

