/*
 * Decompiled with CFR 0.152.
 */
package gravigun.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import gravigun.common.GraviGun;
import gravigun.common.core.Settings;
import gravigun.common.item.ItemGraviGun;
import gravigun.common.packet.PacketGrabEntity;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class EventHandler {
    @SubscribeEvent
    public void onEntitySpawned(EntityJoinWorldEvent event) {
        EntityLivingBase grabber;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (grabber = GraviGun.proxy.tickHandlerServer.watchingSpawnFor) != null && grabber.field_71093_bK == event.entity.field_71093_bK && event.entity.getEntityData().func_74762_e("graviGunGrabber") == grabber.func_145782_y()) {
            GraviGun.proxy.tickHandlerServer.setGrabbed(GraviGun.proxy.tickHandlerServer.watchingSpawnFor, event.entity);
        }
    }

    @SubscribeEvent
    public void onInteract(EntityInteractEvent event) {
        if (this.holdingGraviGun(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    public boolean holdingGraviGun(EntityPlayer player) {
        ItemStack is = player.func_71045_bC();
        return is != null && is.func_77973_b() instanceof ItemGraviGun;
    }

    @SubscribeEvent
    public void clientLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        GraviGun.proxy.tickHandlerClient.grabMap.clear();
        Settings.map.put("oriGraviGunFuel", Settings.getSettings("graviGunFuel"));
    }

    @SubscribeEvent
    public void connectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            try {
                int i = Integer.parseInt(Settings.map.get("oriGraviGunFuel".trim()).toString());
                Settings.map.put("graviGunFuel", i);
            }
            catch (Exception e) {
                GraviGun.console("Failed to restore setting, probably due to unsuccessful connection to a server.");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.sendToPlayer(GraviGun.channels, (AbstractPacket)Settings.getWorldPropsAsPacket(), (EntityPlayer)event.player);
        this.updateGrabbed((EntityPlayerMP)event.player);
    }

    public void updateGrabbed(EntityPlayerMP player) {
        int[] grabber = new int[GraviGun.proxy.tickHandlerServer.grabMap.entrySet().size()];
        int[] grabbing = new int[GraviGun.proxy.tickHandlerServer.grabMap.entrySet().size()];
        int i = 0;
        for (Map.Entry<EntityLivingBase, Entity> e : GraviGun.proxy.tickHandlerServer.grabMap.entrySet()) {
            grabber[i] = e.getKey().func_145782_y();
            grabbing[i] = e.getValue().func_145782_y();
            ++i;
        }
        PacketHandler.sendToPlayer(GraviGun.channels, (AbstractPacket)new PacketGrabEntity(GraviGun.proxy.tickHandlerServer.grabMap.entrySet().size(), grabber, grabbing), (EntityPlayer)player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        GraviGun.proxy.tickHandlerServer.setGrabbed((EntityLivingBase)event.player, null);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Entity grabbed;
        EntityPlayer player = event.player;
        if (!GraviGun.hasPortalGun && (grabbed = GraviGun.proxy.tickHandlerServer.getGrabbed((EntityLivingBase)player)) != null) {
            try {
                double pX = player.field_70165_t - 3.5 * Math.sin(Math.toRadians(player.field_70177_z)) * Math.cos(Math.toRadians(player.field_70125_A));
                double pY = player.field_70163_u + (double)player.func_70047_e() - 3.5 * Math.sin(Math.toRadians(player.field_70125_A));
                double pZ = player.field_70161_v + 3.5 * Math.cos(Math.toRadians(player.field_70177_z)) * Math.cos(Math.toRadians(player.field_70125_A));
                grabbed.field_71088_bW = 0;
                grabbed.func_70063_aa();
                grabbed.getEntityData().func_74768_a("graviGunGrabber", player.func_145782_y());
                grabbed.func_70012_b(pX, pY, pZ, grabbed.field_70177_z, grabbed.field_70125_A);
                GraviGun.proxy.tickHandlerServer.watchingSpawnFor = player;
                grabbed.func_71027_c(player.field_71093_bK);
                GraviGun.proxy.tickHandlerServer.watchingSpawnFor = null;
            }
            catch (Exception e) {
                GraviGun.proxy.tickHandlerServer.setGrabbed((EntityLivingBase)player, null);
                player.field_70170_p.func_72956_a((Entity)player, "gravigun:drop", 0.3f, 1.0f);
            }
        }
    }
}

