/*
 * Decompiled with CFR 0.152.
 */
package gravigun.common.core;

import gravigun.common.GraviGun;
import gravigun.common.packet.PacketWorldProps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Settings {
    public static Map map = new HashMap();
    public static Map<String, String> mapInfo = new HashMap<String, String>();
    public static Map<Integer, int[]> modBlockIds = new HashMap<Integer, int[]>();
    public static Map<Integer, int[]> grabBlockIds = new HashMap<Integer, int[]>();
    public static String[] settingsMap;

    public static void setInt(String s, int i) {
        map.put(s, i);
    }

    public static void setupInt(String s, Configuration config, String cat, int defaultInt) {
        Settings.setInt(s, Settings.addCommentAndReturnInt(config, cat, s, Settings.getSettingsInfo(s), defaultInt));
    }

    public static int addCommentAndReturnInt(Configuration config, String cat, String s, String comment, int i) {
        return Settings.addCommentAndReturnInt(config, cat, s, comment, i, false);
    }

    public static int addCommentAndReturnInt(Configuration config, String cat, String s, String comment, int i, boolean override) {
        Property prop = config.get(cat, s, i);
        if (override) {
            prop.set(i);
        }
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getInt();
    }

    public static String addCommentAndReturnString(Configuration config, String cat, String s, String comment, String value) {
        return Settings.addCommentAndReturnString(config, cat, s, comment, value, false);
    }

    public static String addCommentAndReturnString(Configuration config, String cat, String s, String comment, String value, boolean override) {
        Property prop = config.get(cat, s, value);
        if (override) {
            prop.set(value);
        }
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getString();
    }

    public static void setBlockIdsToMap(Map map, String s, boolean clear) {
        if (clear) {
            map.clear();
        }
        if (s.equalsIgnoreCase("")) {
            return;
        }
        String[] split = s.split(", *");
        if (split.length > 0 && !split[0].equalsIgnoreCase("")) {
            int[] list = new int[split.length];
            for (int i1 = 0; i1 < split.length; ++i1) {
                String[] split1 = split[i1].split(": *");
                if (split1.length <= 0 || split1[0].equalsIgnoreCase("")) continue;
                if (split1.length == 1) {
                    try {
                        if (Integer.parseInt(split1[0].trim()) == 0) continue;
                        map.put(Integer.parseInt(split1[0].trim()), new int[]{-1});
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (split1[1].equalsIgnoreCase("null")) {
                    try {
                        if (Integer.parseInt(split1[0].trim()) == 0) continue;
                        map.remove(Integer.parseInt(split1[0].trim()));
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                int[] list1 = new int[split1.length - 1];
                for (int j = 1; j < split1.length; ++j) {
                    try {
                        list1[j - 1] = Integer.parseInt(split1[j].trim());
                        continue;
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    map.put(Integer.parseInt(split1[0].trim()), list1);
                    continue;
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static int getSettings(String s) {
        try {
            return Integer.parseInt(map.get(s.trim()).toString());
        }
        catch (NumberFormatException e) {
            GraviGun.console("Failed to read settings [NaN]: " + s);
            return -2;
        }
        catch (NullPointerException e) {
            GraviGun.console("Failed to read settings [Null]: " + s);
            return -2;
        }
    }

    public static int[] getSettingsInt(String s) {
        try {
            int[] setting = (int[])map.get(s);
            if (setting == null) {
                GraviGun.console("Failed to read settings: " + s);
                setting = new int[]{};
            }
            return setting;
        }
        catch (NullPointerException e) {
            GraviGun.console("Failed to read settings: " + s);
            int[] empty = new int[]{};
            return empty;
        }
    }

    public static int[] getBlockMetaInMap(Map map, Block i) {
        return (int[])map.get(Block.func_149682_b((Block)i));
    }

    public static String intArrayToString(int[] list) {
        StringBuilder sb = new StringBuilder();
        for (int i1 = 0; i1 < list.length; ++i1) {
            sb.append(list[i1]);
            if (i1 == list.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getSettingsInfo(String s) {
        try {
            return mapInfo.get(s).trim();
        }
        catch (NullPointerException e) {
            GraviGun.console("Settings has no info mapped: " + s);
            return "";
        }
    }

    public static String mapToString(Map<Integer, int[]> map) {
        StringBuilder sb = new StringBuilder();
        if (!map.isEmpty()) {
            for (Map.Entry<Integer, int[]> e : map.entrySet()) {
                if (!sb.toString().equalsIgnoreCase("")) {
                    sb.append(", ");
                }
                sb.append(e.getKey());
                int[] metaList = e.getValue();
                if (metaList.length != 0 && metaList[0] == -1) continue;
                for (int j = 0; j < metaList.length; ++j) {
                    sb.append(": ").append(metaList[j]);
                }
            }
        } else {
            sb.append(0);
        }
        return sb.toString();
    }

    public static PacketWorldProps getWorldPropsAsPacket() {
        return new PacketWorldProps(settingsMap, Settings.mapToString(grabBlockIds), Settings.getSettings("graviGunFuel"));
    }

    private static void mapInfo() {
        mapInfo.put("grabablePlayers", "Boolean:\nCan players be grabbed by the gravigun?");
        mapInfo.put("grabBlockMode", "Block grabbing mode (How a grabbed block turns into a block again)\n1 = Blocks fall to the ground\n2 = Blocks snap to surroundings\n3 = Blocks float when released");
        mapInfo.put("grabEntityMode", "Entity grabbing mode\n1 = Most entities\n2 = Living entities");
        mapInfo.put("grabBlockWhitelist", "Boolean:\nBlock grabbing whitelist enabled?");
        mapInfo.put("grabBlockListIDs", "Block grabbing black/whitelist IDs + metadata\nFormat: id: meta: meta, id: meta, id, id ...\nExample: You don't want ID 1, 2, 3 and 4 to be grabbed, but only metadata 5 and 7 for ID 1, and only metadata 9 for ID 2.\nExample: grabBlockListIDs = 1: 5: 7, 2: 9, 3, 4\nIf you need a more proper explanation visit: http://www.minecraftforum.net/topic/199391-/page__view__findpost__p__13392100");
        mapInfo.put("grabChestTypeAllowed", "Boolean:\nAllow grabbing of chest-like blocks (Render ID 22)?\nWarning! I am not responsible for any loss of items due to invalid block placement, etc.");
        mapInfo.put("enableChargedGrabbing", "Boolean:\nAllow the charged gravity gun to grab blocks?");
        mapInfo.put("creeperExplosion", "Tossed Creepers when they hit something? \n0 = No, \n1 = Yes, both guns, \n2 = Yes, charged gun only.");
        mapInfo.put("forceCustomModel", "Force use a custom model?\n0 = Default.\n1 = Simple model.\n2 = Fancy model.");
        mapInfo.put("enableSounds", "Boolean:\nEnable mod sounds?");
        mapInfo.put("equipGraviGunSound", "Boolean:\nDoes the a sound play when you equip the gravity gun?");
        mapInfo.put("itemId", "Item ID base\nDefault: 13190");
        mapInfo.put("graviGunFuel", "Boolean:\nEnable Fuel (glowstone) for the gravity gun?\nCustom fuel is also possible below, but this has to be enabled.");
        mapInfo.put("customFuel", "Boolean:\nEnable custom portal gun fuel?");
        mapInfo.put("customFuelId", "Block/Item ID (after shifting) to use as fuel.");
        mapInfo.put("customFuelMetadata", "Damage/Metadata to use for the fuel.");
        mapInfo.put("customFuelAmount", "Amount of items used.");
        mapInfo.put("customModel", "Boolean:\nEnable custom model created by mr_hazard|d95?");
    }

    static {
        Settings.mapInfo();
    }
}

