/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import exnihilo.network.ENPacketHandler;
import exnihilo.network.MessageCrucible;
import exnihilo.network.VanillaPacket;
import exnihilo.registries.CrucibleRegistry;
import exnihilo.registries.HeatRegistry;
import exnihilo.registries.helpers.Meltable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCrucible
extends TileEntity
implements IFluidHandler,
ISidedInventory {
    private static final float MIN_RENDER_CAPACITY = 0.2f;
    private static final float MAX_RENDER_CAPACITY = 0.95f;
    private static final int MAX_FLUID = 10000;
    private static final int UPDATE_INTERVAL = 10;
    private boolean needsUpdate = false;
    private int updateTimer = 0;
    public FluidStack fluid;
    private Block content;
    private int contentMeta = 0;
    private float solidVolume = 0.0f;
    private float airVolume = 0.0f;
    private float fluidVolume = 0.0f;
    public CrucibleMode mode = CrucibleMode.EMPTY;

    public TileEntityCrucible() {
        this.fluid = new FluidStack(FluidRegistry.WATER, 0);
    }

    public float getAdjustedVolume() {
        float volume = (this.solidVolume + this.fluidVolume + this.airVolume) / 10000.0f;
        float capacity = 0.75f;
        float adjusted = volume * capacity;
        return adjusted += 0.2f;
    }

    public IIcon getContentIcon() {
        if (this.field_145850_b.field_72995_K) {
            Meltable meltable = CrucibleRegistry.getItem(this.content, this.contentMeta);
            if (meltable != null && meltable.getIcon() != null) {
                return meltable.getIcon();
            }
            return Blocks.field_150348_b.func_149691_a(0, 0);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = CrucibleMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = CrucibleMode.USED;
            }
        }
        this.solidVolume = compound.func_74760_g("solidVolume");
        this.fluidVolume = compound.func_74760_g("fluidVolume");
        this.airVolume = compound.func_74760_g("airVolume");
        this.content = !compound.func_74779_i("content").equals("") ? (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("content")) : null;
        this.contentMeta = compound.func_74762_e("contentMeta");
        this.fluid = new FluidStack(FluidRegistry.getFluid((int)compound.func_74765_d("fluid")), Math.round(this.fluidVolume));
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        compound.func_74776_a("solidVolume", this.solidVolume);
        compound.func_74776_a("fluidVolume", this.fluidVolume);
        compound.func_74776_a("airVolume", this.airVolume);
        if (this.content == null) {
            compound.func_74778_a("content", "");
        } else {
            compound.func_74778_a("content", Block.field_149771_c.func_148750_c((Object)this.content));
        }
        compound.func_74768_a("contentMeta", this.contentMeta);
        compound.func_74777_a("fluid", (short)this.fluid.getFluidID());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean addItem(ItemStack item) {
        if (!CrucibleRegistry.containsItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j())) {
            return false;
        }
        Meltable meltable = CrucibleRegistry.getItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j());
        if (!this.field_145850_b.field_72995_K && this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
            this.content = Block.func_149634_a((Item)item.func_77973_b());
            this.contentMeta = item.func_77960_j();
            this.solidVolume += meltable.fluidVolume;
            this.airVolume += meltable.solidVolume - meltable.fluidVolume;
        } else {
            return false;
        }
        this.mode = CrucibleMode.USED;
        this.fluid = new FluidStack(meltable.fluid, (int)this.fluidVolume);
        VanillaPacket.sendTileEntityUpdate(this);
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            float speed = this.getMeltSpeed();
            if (this.airVolume > 0.0f) {
                this.airVolume -= this.airVolume * (speed / this.solidVolume);
                if (this.airVolume < 0.0f) {
                    this.airVolume = 0.0f;
                }
            }
            if (this.solidVolume > 0.0f) {
                if (this.solidVolume - speed >= 0.0f) {
                    this.fluidVolume += speed;
                    this.solidVolume -= speed;
                } else {
                    this.fluidVolume += this.solidVolume;
                    this.solidVolume = 0.0f;
                }
                this.fluid.amount = Math.round(this.fluidVolume);
                this.needsUpdate = true;
            } else if (Math.round(this.solidVolume + this.fluidVolume + this.airVolume) == 0 && this.mode != CrucibleMode.EMPTY) {
                this.mode = CrucibleMode.EMPTY;
                this.needsUpdate = true;
            }
            if (this.updateTimer >= 10) {
                this.updateTimer = 0;
                if (this.needsUpdate) {
                    this.needsUpdate = false;
                    ENPacketHandler.sendToAllAround(new MessageCrucible(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.fluidVolume, this.solidVolume), this);
                    VanillaPacket.sendTileEntityUpdate(this);
                }
            } else {
                ++this.updateTimer;
            }
        }
    }

    public float getCapacity() {
        return 10000.0f - (this.solidVolume + this.fluidVolume + this.airVolume);
    }

    public float getMeltSpeed() {
        int targetMeta;
        Block targetBlock = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (HeatRegistry.containsItem(targetBlock, targetMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e))) {
            return HeatRegistry.getSpeed(targetBlock, targetMeta);
        }
        return 0.0f;
    }

    public boolean hasSolids() {
        return this.solidVolume > 0.0f;
    }

    public boolean renderFluid() {
        return this.solidVolume < this.fluidVolume && this.fluid.getFluid().getID() != FluidRegistry.WATER.getID();
    }

    private boolean isFluidValid(Fluid fluid) {
        if (this.mode == CrucibleMode.EMPTY) {
            return true;
        }
        return this.mode == CrucibleMode.USED && fluid.getID() == this.fluid.getFluidID();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int capacity = (int)this.getCapacity();
        if (!doFill) {
            if (this.mode == CrucibleMode.EMPTY) {
                return resource.amount;
            }
            if (this.mode == CrucibleMode.USED && resource.getFluidID() == this.fluid.getFluidID()) {
                if (capacity >= resource.amount) {
                    return resource.amount;
                }
                return capacity;
            }
        } else {
            if (this.mode == CrucibleMode.EMPTY) {
                if (resource.getFluidID() != this.fluid.getFluidID()) {
                    this.fluid = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), resource.amount);
                } else {
                    this.fluid.amount = resource.amount;
                }
                this.mode = CrucibleMode.USED;
                this.fluidVolume += (float)this.fluid.amount;
                this.needsUpdate = true;
                return resource.amount;
            }
            if (this.mode == CrucibleMode.USED && resource.getFluidID() == this.fluid.getFluidID()) {
                if (capacity >= resource.amount) {
                    this.fluidVolume += (float)resource.amount;
                    this.fluid.amount = (int)this.fluidVolume;
                    this.needsUpdate = true;
                    return resource.amount;
                }
                this.fluidVolume += (float)capacity;
                this.fluid.amount = (int)this.fluidVolume;
                this.needsUpdate = true;
                return capacity;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.mode != CrucibleMode.USED || !resource.isFluidEqual(this.fluid)) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= resource.amount) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), resource.amount);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > resource.amount) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), resource.amount);
            this.fluidVolume -= (float)resource.amount;
            this.fluid.amount = (int)this.fluidVolume;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)resource.getFluidID()), this.fluid.amount);
        this.fluidVolume -= (float)this.fluid.amount;
        this.fluid.amount = 0;
        this.needsUpdate = true;
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.mode != CrucibleMode.USED) {
            return null;
        }
        if (!doDrain) {
            if (this.fluid.amount >= maxDrain) {
                FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), maxDrain);
                return simulated;
            }
            FluidStack simulated = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), this.fluid.amount);
            return simulated;
        }
        if (this.fluid.amount > maxDrain) {
            FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), maxDrain);
            this.fluidVolume -= (float)maxDrain;
            this.fluid.amount = (int)this.fluidVolume;
            this.needsUpdate = true;
            return drained;
        }
        FluidStack drained = new FluidStack(FluidRegistry.getFluid((int)this.fluid.getFluidID()), this.fluid.amount);
        this.fluidVolume -= (float)this.fluid.amount;
        this.fluid.amount = 0;
        this.needsUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo info = new FluidTankInfo(this.fluid, 10000);
        FluidTankInfo[] array = new FluidTankInfo[]{info};
        return array;
    }

    public int getLightLevel() {
        if (this.mode == CrucibleMode.USED) {
            float lumens = (float)this.fluid.getFluid().getLuminosity() * (this.fluidVolume / 10000.0f);
            return Math.round(lumens);
        }
        return 0;
    }

    public void setVolumes(float newFluidVolume, float newSolidVolume) {
        this.fluidVolume = newFluidVolume;
        this.fluid.amount = Math.round(newFluidVolume);
        this.solidVolume = newSolidVolume;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        if (slot == 0 && CrucibleRegistry.containsItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                this.addItem(item);
            }
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 0 && CrucibleRegistry.containsItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (side == 1 && slot == 0 && CrucibleRegistry.containsItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j())) {
            Meltable meltable = CrucibleRegistry.getItem(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j());
            if (this.getCapacity() >= meltable.solidVolume && this.isFluidValid(meltable.fluid)) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public float getSolidVolume() {
        return this.solidVolume;
    }

    public float getFluidVolume() {
        return this.fluidVolume;
    }

    public static enum CrucibleMode {
        EMPTY(0),
        USED(1);

        public int value;

        private CrucibleMode(int v) {
            this.value = v;
        }
    }
}

