/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.network.VanillaPacket;
import exnihilo.particles.ParticleSieve;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftingResult;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileEntitySieve
extends TileEntity {
    private static final float MIN_RENDER_CAPACITY = 0.7f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 20;
    public Block content;
    public int contentMeta = 0;
    private float volume = 0.0f;
    public SieveMode mode = SieveMode.EMPTY;
    private int timer = 0;
    private boolean update = false;
    private boolean particleMode = false;
    private int timesClicked = 0;

    public void addSievable(Block block, int blockMeta) {
        this.content = block;
        this.contentMeta = blockMeta;
        this.mode = SieveMode.FILLED;
        this.volume = 1.0f;
        VanillaPacket.sendTileEntityUpdate(this);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.particleMode) {
            this.spawnFX(this.content, this.contentMeta);
        }
        ++this.timer;
        if (this.timer >= 20) {
            this.timesClicked = 0;
            this.timer = 0;
            this.disableParticles();
            if (this.update) {
                this.update();
            }
        }
    }

    public void ProcessContents(boolean creative) {
        if (creative) {
            this.volume = 0.0f;
        } else {
            ++this.timesClicked;
            if (this.timesClicked <= 6) {
                this.volume -= 0.075f;
            }
        }
        if (this.volume <= 0.0f) {
            ArrayList<SiftingResult> rewards;
            this.mode = SieveMode.EMPTY;
            if (!this.field_145850_b.field_72995_K && (rewards = SieveRegistry.getSiftingOutput(this.content, this.contentMeta)) != null && rewards.size() > 0) {
                for (SiftingResult reward : rewards) {
                    if (this.field_145850_b.field_73012_v.nextInt(reward.rarity) != 0) continue;
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, new ItemStack(reward.item, 1, reward.meta));
                    double f3 = 0.05f;
                    entityitem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = 0.2;
                    entityitem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * f3;
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
            }
        } else {
            this.particleMode = true;
        }
        this.update = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX(Block block, int blockMeta) {
        if (block != null) {
            IIcon icon = block.func_149691_a(0, blockMeta);
            for (int x = 0; x < 4; ++x) {
                ParticleSieve dust = new ParticleSieve(this.field_145850_b, (double)this.field_145851_c + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, (double)this.field_145848_d + 0.69, (double)this.field_145849_e + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, 0.0, 0.0, 0.0, icon);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)dust);
            }
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public float getAdjustedVolume() {
        float capacity = 0.19999999f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.7f;
    }

    private void update() {
        this.update = false;
        VanillaPacket.sendTileEntityUpdate(this);
    }

    private void disableParticles() {
        this.particleMode = false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = SieveMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = SieveMode.FILLED;
            }
        }
        this.content = !compound.func_74779_i("content").equals("") ? (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("content")) : null;
        this.contentMeta = compound.func_74762_e("contentMeta");
        this.volume = compound.func_74760_g("volume");
        this.particleMode = compound.func_74767_n("particles");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        if (this.content == null) {
            compound.func_74778_a("content", "");
        } else {
            compound.func_74778_a("content", Block.field_149771_c.func_148750_c((Object)this.content));
        }
        compound.func_74768_a("contentMeta", this.contentMeta);
        compound.func_74776_a("volume", this.volume);
        compound.func_74757_a("particles", this.particleMode);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public static enum SieveMode {
        EMPTY(0),
        FILLED(1);

        public int value;

        private SieveMode(int v) {
            this.value = v;
        }
    }
}

