/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.foresty;

import exnihilo.compatibility.foresty.FlowerType;
import forestry.api.apiculture.FlowerManager;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Surrounding {
    private static final EnumSet<FlowerType> addedFlowerTypes = EnumSet.of(FlowerType.Normal, new FlowerType[]{FlowerType.Nether, FlowerType.End, FlowerType.Jungle, FlowerType.Mushroom, FlowerType.Cactus, FlowerType.Gourd});
    public Map<String, Integer> blocks = new HashMap<String, Integer>();
    public Map<String, Integer> flowers = new HashMap<String, Integer>();
    public int leafCount;
    public String blockAbove;

    public void addBlock(World world, int x, int y, int z) {
        String key;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null && block.isLeaves((IBlockAccess)world, x, y, z)) {
            ++this.leafCount;
        }
        if (this.blocks.containsKey(key = block + ":" + meta)) {
            int count = this.blocks.get(key);
            this.blocks.put(key, count + 1);
        } else {
            this.blocks.put(key, 1);
        }
        this.tryAddFlower(world, x, y, z);
    }

    public void setBlockAbove(Block block, int meta) {
        this.blockAbove = block + ":" + meta;
    }

    public void tryAddFlower(World world, int x, int y, int z) {
        for (FlowerType flowerType : addedFlowerTypes) {
            if (!FlowerManager.flowerRegistry.isAcceptedFlower(flowerType.getForestryKey(), world, x, y, z)) continue;
            this.addFlower(flowerType);
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150392_bi) {
            this.addFlower(FlowerType.Water);
        }
    }

    private void addFlower(FlowerType type) {
        String key = type.name();
        if (this.flowers.containsKey(key)) {
            int count = this.flowers.get(key);
            this.flowers.put(key, count + 1);
        } else {
            this.flowers.put(key, 1);
        }
    }

    public int getFlowerCount(FlowerType type) {
        String key = type.name();
        switch (type) {
            case None: {
                return 0;
            }
        }
        if (this.flowers.containsKey(key)) {
            return this.flowers.get(key);
        }
        return 0;
    }
}

