/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftingResult;
import exnihilo.utils.ItemInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RecipeHandlerSieve
extends TemplateRecipeHandler {
    private static final int SLOTS_PER_PAGE = 45;

    public String getRecipeName() {
        return "Ex Nihilo Sieve";
    }

    public String getGuiTexture() {
        return "exnihilo:textures/sieveNEI.png";
    }

    private void addCached(List<ItemStack> variations, ItemStack base, ItemStack focus) {
        if (variations.size() > 45) {
            ArrayList<ArrayList<ItemStack>> parts = new ArrayList<ArrayList<ItemStack>>();
            int size = variations.size();
            for (int i = 0; i < size; i += 45) {
                parts.add(new ArrayList<ItemStack>(variations.subList(i, Math.min(size, i + 45))));
            }
            for (List list : parts) {
                this.arecipes.add(new CachedSieveRecipe(list, base, focus));
            }
        } else {
            this.arecipes.add(new CachedSieveRecipe(variations, base, focus));
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)130);
        Point focus = ((CachedSieveRecipe)((Object)this.arecipes.get((int)recipeIndex))).focus;
        if (focus != null) {
            GuiDraw.drawTexturedModalRect((int)focus.x, (int)focus.y, (int)166, (int)0, (int)18, (int)18);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), "exnihilo.sieve", new Object[0]));
    }

    public void loadCraftingRecipes(String outputID, Object ... results) {
        if (outputID.equals("exnihilo.sieve")) {
            for (ItemInfo ii : SieveRegistry.getSiftables().keySet()) {
                ItemStack inputStack = ii.getStack();
                ArrayList<ItemStack> resultStack = new ArrayList<ItemStack>();
                for (SiftingResult s : SieveRegistry.getSiftingOutput(ii)) {
                    resultStack.add(new ItemStack(s.item, 1, s.meta));
                }
                this.addCached(resultStack, inputStack, null);
            }
        } else {
            super.loadCraftingRecipes(outputID, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashSet<ItemInfo> completed = new HashSet<ItemInfo>();
        for (ItemInfo ii : SieveRegistry.getSources(result)) {
            if (completed.contains(ii)) continue;
            HashMap<ItemInfo, Integer> stored = new HashMap<ItemInfo, Integer>();
            for (SiftingResult results : SieveRegistry.getSiftingOutput(Block.func_149634_a((Item)ii.getItem()), ii.getMeta())) {
                ItemInfo current = new ItemInfo(results.item, results.meta);
                if (stored.containsKey(current)) {
                    stored.put(current, (Integer)stored.get(current) + 1);
                    continue;
                }
                stored.put(current, 1);
            }
            ArrayList<ItemStack> resultVars = new ArrayList<ItemStack>();
            for (ItemInfo info : stored.keySet()) {
                ItemStack stack = info.getStack();
                stack.field_77994_a = (Integer)stored.get(info);
                resultVars.add(stack);
            }
            this.addCached(resultVars, ii.getStack(), result);
            completed.add(ii);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<ItemInfo, Integer> stored = new HashMap<ItemInfo, Integer>();
        if (Block.func_149634_a((Item)ingredient.func_77973_b()) == Blocks.field_150350_a) {
            return;
        }
        if (!SieveRegistry.registered(Block.func_149634_a((Item)ingredient.func_77973_b()), ingredient.func_77960_j())) {
            return;
        }
        for (SiftingResult results : SieveRegistry.getSiftingOutput(Block.func_149634_a((Item)ingredient.func_77973_b()), ingredient.func_77960_j())) {
            ItemInfo current = new ItemInfo(results.item, results.meta);
            if (stored.containsKey(current)) {
                stored.put(current, (Integer)stored.get(current) + 1);
                continue;
            }
            stored.put(current, 1);
        }
        ArrayList<ItemStack> resultVars = new ArrayList<ItemStack>();
        for (ItemInfo info : stored.keySet()) {
            ItemStack stack = info.getStack();
            stack.field_77994_a = (Integer)stored.get(info);
            resultVars.add(stack);
        }
        this.addCached(resultVars, ingredient, ingredient);
    }

    private void addCached(List<ItemStack> variations) {
        this.addCached(variations, null, null);
    }

    public List<String> handleItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, int recipe) {
        super.handleItemTooltip(guiRecipe, itemStack, currenttip, recipe);
        CachedSieveRecipe crecipe = (CachedSieveRecipe)((Object)this.arecipes.get(recipe));
        Point mouse = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
        if (itemStack != null && relMouse.y > 34) {
            currenttip.add("Drop Chance:");
            ItemStack sourceStack = ((PositionedStack)((CachedSieveRecipe)crecipe).input.get((int)0)).item;
            Block inBlock = Block.func_149634_a((Item)sourceStack.func_77973_b());
            int meta = sourceStack.func_77960_j();
            for (SiftingResult smash : SieveRegistry.getSiftingOutput(inBlock, meta)) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)new ItemStack(smash.item, 1, smash.meta))) continue;
                int chance = (int)Math.round(100.0 * (1.0 / (double)smash.rarity));
                currenttip.add("  * " + Integer.toString(chance) + "%");
            }
        }
        return currenttip;
    }

    public class CachedSieveRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> input;
        private List<PositionedStack> outputs;
        public Point focus;

        public CachedSieveRecipe(List<ItemStack> variations, ItemStack base, ItemStack focus) {
            super((TemplateRecipeHandler)RecipeHandlerSieve.this);
            this.input = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            PositionedStack pstack = new PositionedStack(base != null ? base : variations, 74, 4);
            pstack.setMaxSize(1);
            this.input.add(pstack);
            int row = 0;
            int col = 0;
            for (ItemStack v : variations) {
                this.outputs.add(new PositionedStack((Object)v, 3 + 18 * col, 37 + 18 * row));
                if (focus != null && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)focus, (ItemStack)v)) {
                    this.focus = new Point(2 + 18 * col, 36 + 18 * row);
                }
                if (++col <= 8) continue;
                col = 0;
                ++row;
            }
        }

        public CachedSieveRecipe(List<ItemStack> variations) {
            this(variations, null, null);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerSieve.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

