/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import info.loenwind.autosave.IHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.handlers.endercore.HandleBlockCoord;
import info.loenwind.autosave.handlers.enderio.HandleIMachineRecipe;
import info.loenwind.autosave.handlers.enderio.HandleSmartTank;
import info.loenwind.autosave.handlers.enderioaddons.HandleNotifSet;
import info.loenwind.autosave.handlers.enderioaddons.HandleStash;
import info.loenwind.autosave.handlers.enderioaddons.HandleStatCollector;
import info.loenwind.autosave.handlers.forge.HandleFluid;
import info.loenwind.autosave.handlers.forge.HandleFluidStack;
import info.loenwind.autosave.handlers.internal.HandleStorable;
import info.loenwind.autosave.handlers.java.HandleBoolean;
import info.loenwind.autosave.handlers.java.HandleEnum;
import info.loenwind.autosave.handlers.java.HandleFloat;
import info.loenwind.autosave.handlers.java.HandleFloatArray;
import info.loenwind.autosave.handlers.java.HandleInteger;
import info.loenwind.autosave.handlers.minecraft.HandleItem;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Registry {
    @Nonnull
    public static final Registry GLOBAL_REGISTRY = new Registry(true);
    @Nonnull
    private final List<IHandler> handlers = new ArrayList<IHandler>();
    @Nullable
    private final Registry parent;

    private Registry(boolean root) {
        this.parent = root ? null : null;
    }

    public Registry() {
        this(GLOBAL_REGISTRY);
    }

    public Registry(@Nonnull Registry parent) {
        this.parent = parent;
    }

    public void register(@Nonnull IHandler handler) {
        this.handlers.add(handler);
    }

    @Nonnull
    public List<IHandler> findHandlers(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        ArrayList<IHandler> result = new ArrayList<IHandler>();
        Storable annotation = clazz.getAnnotation(Storable.class);
        while (annotation != null) {
            Class<?> superclass;
            if (annotation.handler() != HandleStorable.class) {
                result.add(annotation.handler().newInstance());
            }
            if ((superclass = clazz.getSuperclass()) == null) continue;
            annotation = superclass.getAnnotation(Storable.class);
        }
        this.findRegisteredHandlers(clazz, result);
        return result;
    }

    private void findRegisteredHandlers(Class<?> clazz, List<IHandler> result) {
        for (IHandler handler : this.handlers) {
            if (!handler.canHandle(clazz)) continue;
            result.add(handler);
        }
        Registry thisParent = this.parent;
        if (thisParent != null) {
            thisParent.findRegisteredHandlers(clazz, result);
        }
    }

    static {
        GLOBAL_REGISTRY.register(new HandleStash());
        GLOBAL_REGISTRY.register(new HandleStatCollector());
        GLOBAL_REGISTRY.register(new HandleNotifSet());
        GLOBAL_REGISTRY.register(new HandleSmartTank());
        GLOBAL_REGISTRY.register(new HandleIMachineRecipe());
        GLOBAL_REGISTRY.register(new HandleBlockCoord());
        GLOBAL_REGISTRY.register(new HandleFloat());
        GLOBAL_REGISTRY.register(new HandleInteger());
        GLOBAL_REGISTRY.register(new HandleBoolean());
        GLOBAL_REGISTRY.register(new HandleFloatArray());
        GLOBAL_REGISTRY.register(new HandleEnum());
        GLOBAL_REGISTRY.register(new HandleFluidStack());
        GLOBAL_REGISTRY.register(new HandleFluid());
        GLOBAL_REGISTRY.register(new HandleItemStack());
        GLOBAL_REGISTRY.register(new HandleItem());
        GLOBAL_REGISTRY.register(new HandleStorable());
    }
}

