/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.common;

import com.enderio.core.common.util.BlockCoord;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldHelper {
    private final IBlockAccess world;

    public WorldHelper(IBlockAccess world) {
        this.world = world;
    }

    public static boolean isInWorld(World world, BlockCoord bc) {
        return world.func_72899_e(bc.x, bc.y, bc.z);
    }

    public boolean isInWorld(BlockCoord bc) {
        if (this.world instanceof World) {
            return bc != null && ((World)this.world).func_72899_e(bc.x, bc.y, bc.z);
        }
        return bc != null && bc.y > 0 && bc.y <= 255;
    }

    @Nullable
    public static Block getBlock(World world, BlockCoord bc) {
        if (bc != null && world.func_72899_e(bc.x, bc.y, bc.z)) {
            return world.func_147439_a(bc.x, bc.y, bc.z);
        }
        return null;
    }

    @Nullable
    public static Block getBlock(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            return world.func_147439_a(x, y, z);
        }
        return null;
    }

    @Nullable
    public static Block getBlock(IBlockAccess world, BlockCoord bc) {
        if (world instanceof World) {
            return WorldHelper.getBlock((World)world, bc);
        }
        return bc != null ? world.func_147439_a(bc.x, bc.y, bc.z) : null;
    }

    @Nullable
    public static Block getBlock(IBlockAccess world, int x, int y, int z) {
        if (world instanceof World) {
            return WorldHelper.getBlock((World)world, x, y, z);
        }
        return world.func_147439_a(x, y, z);
    }

    @Nullable
    public Block getBlock(BlockCoord bc) {
        if (this.world instanceof World) {
            return WorldHelper.getBlock((World)this.world, bc);
        }
        return bc != null ? this.world.func_147439_a(bc.x, bc.y, bc.z) : null;
    }

    @Nullable
    public Block getBlock(int x, int y, int z) {
        if (this.world instanceof World) {
            return WorldHelper.getBlock((World)this.world, x, y, z);
        }
        return this.world.func_147439_a(x, y, z);
    }

    public static int getMeta(World world, BlockCoord bc) {
        if (bc != null && world.func_72899_e(bc.x, bc.y, bc.z)) {
            return world.func_72805_g(bc.x, bc.y, bc.z);
        }
        return 0;
    }

    public static int getMeta(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            return world.func_72805_g(x, y, z);
        }
        return 0;
    }

    public static int getMeta(IBlockAccess world, BlockCoord bc) {
        if (world instanceof World) {
            return WorldHelper.getMeta((World)world, bc);
        }
        return bc != null ? world.func_72805_g(bc.x, bc.y, bc.z) : 0;
    }

    public static int getMeta(IBlockAccess world, int x, int y, int z) {
        if (world instanceof World) {
            return WorldHelper.getMeta((World)world, x, y, z);
        }
        return world.func_72805_g(x, y, z);
    }

    public int getMeta(BlockCoord bc) {
        if (this.world instanceof World) {
            return WorldHelper.getMeta((World)this.world, bc);
        }
        return bc != null ? this.world.func_72805_g(bc.x, bc.y, bc.z) : 0;
    }

    public int getMeta(int x, int y, int z) {
        if (this.world instanceof World) {
            return WorldHelper.getMeta((World)this.world, x, y, z);
        }
        return this.world.func_72805_g(x, y, z);
    }

    public static boolean isAir(World world, BlockCoord bc) {
        if (bc != null && world.func_72899_e(bc.x, bc.y, bc.z)) {
            return world.func_147437_c(bc.x, bc.y, bc.z);
        }
        return false;
    }

    public static boolean isAir(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            return world.func_147437_c(x, y, z);
        }
        return false;
    }

    public static boolean isAir(IBlockAccess world, BlockCoord bc) {
        if (world instanceof World) {
            return WorldHelper.isAir((World)world, bc);
        }
        return bc != null ? world.func_147437_c(bc.x, bc.y, bc.z) : false;
    }

    public static boolean isAir(IBlockAccess world, int x, int y, int z) {
        if (world instanceof World) {
            return WorldHelper.isAir((World)world, x, y, z);
        }
        return world.func_147437_c(x, y, z);
    }

    public boolean isAir(BlockCoord bc) {
        if (this.world instanceof World) {
            return WorldHelper.isAir((World)this.world, bc);
        }
        return bc != null ? this.world.func_147437_c(bc.x, bc.y, bc.z) : false;
    }

    public boolean isAir(int x, int y, int z) {
        if (this.world instanceof World) {
            return WorldHelper.isAir((World)this.world, x, y, z);
        }
        return this.world.func_147437_c(x, y, z);
    }
}

