/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.enderioaddons.common.InitAware;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.config.PacketConfigSync;
import io.netty.buffer.ByteBuf;
import java.io.File;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler
implements InitAware {
    public static Configuration configuration;
    public static File configDirectory;
    public static boolean configLockedByServer;
    public static boolean iAmTheServer;

    @Override
    public void init(FMLPreInitializationEvent event) {
        PacketHandler.INSTANCE.registerMessage(PacketConfigSync.class, PacketConfigSync.class, PacketHandler.nextID(), Side.CLIENT);
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        configDirectory = new File(event.getModConfigurationDirectory(), "enderioaddons".toLowerCase());
        if (!configDirectory.exists()) {
            configDirectory.mkdir();
        }
        File configFile = new File(configDirectory, "enderioaddons.cfg");
        configuration = new Configuration(configFile);
        ConfigHandler.syncConfig(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncConfig(boolean load) {
        try {
            if (load) {
                configuration.load();
            }
            ConfigHandler.processConfig();
        }
        catch (Exception e) {
            Log.error("EnderIOAddons has a problem loading it's configuration");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("enderioaddons")) {
            Log.info("Updating config...");
            ConfigHandler.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.modID.equals("enderioaddons")) {
            Log.info("Updating config...");
            ConfigHandler.syncConfig(true);
            event.setSuccessful();
        }
    }

    private static void processConfig() {
        ConfigHandler.loadAll(configuration);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void toBytes(ByteBuf buf) {
        for (Config value : Config.values()) {
            if (!value.getSection().sync) continue;
            value.store(buf);
        }
    }

    public static void fromBytes(ByteBuf buf) {
        if (iAmTheServer) {
            return;
        }
        for (Config value : Config.values()) {
            if (!value.getSection().sync) continue;
            value.read(buf);
        }
        configLockedByServer = true;
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        iAmTheServer = true;
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketConfigSync(), (EntityPlayerMP)evt.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ConfigHandler.syncConfig(false);
        configLockedByServer = false;
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void init(FMLPostInitializationEvent event) {
    }

    public static void loadAll(Configuration config) {
        for (Config value : Config.values()) {
            value.load(config);
        }
    }

    public static void loadAll() {
        for (Config value : Config.values()) {
            value.resetToDefault();
        }
    }

    static {
        ConfigHandler.loadAll();
        configLockedByServer = false;
        iAmTheServer = false;
    }
}

