/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.drain;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.Scheduler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.GuiIds;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.drain.BlockItemDrain;
import info.loenwind.enderioaddons.machine.drain.ContainerDrain;
import info.loenwind.enderioaddons.machine.drain.GuiDrain;
import info.loenwind.enderioaddons.machine.drain.PacketDrain;
import info.loenwind.enderioaddons.machine.drain.TileDrain;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockDrain
extends AbstractMachineBlock<TileDrain>
implements IAdvancedTooltipProvider {
    public static final ModObject ModObject_blockDrain = (ModObject)EnumHelper.addEnum(ModObject.class, (String)"blockDrain", (Class[])new Class[0], (Object[])new Object[0]);
    public static BlockDrain blockDrain;
    public int localRenderId;

    public static BlockDrain create() {
        PacketHandler.INSTANCE.registerMessage(PacketDrain.class, PacketDrain.class, PacketHandler.nextID(), Side.CLIENT);
        blockDrain = new BlockDrain();
        blockDrain.init();
        return blockDrain;
    }

    protected BlockDrain() {
        super(ModObject_blockDrain, TileDrain.class);
        this.func_149672_a(Block.field_149778_k);
        this.func_149713_g(0);
        this.func_149663_c(this.name);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemDrain.class, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), (IGuiHandler)this);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs p_149666_2_, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileDrain();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileDrain)) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        TileDrain drain = (TileDrain)te;
        ItemStack item = entityPlayer.field_71071_by.func_70448_g();
        if (item == null) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        if (FluidUtil.fillPlayerHandItemFromInternalTank((World)world, (int)x, (int)y, (int)z, (EntityPlayer)entityPlayer, (ITankAccess)drain)) {
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileDrain)) {
            return null;
        }
        return new ContainerDrain(player.field_71071_by, (TileDrain)te);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        InventoryPlayer inventory = player.field_71071_by;
        if (te instanceof TileDrain && inventory != null) {
            return new GuiDrain(inventory, (TileDrain)te);
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    protected int getGuiId() {
        return GuiIds.GUI_ID_DRAIN;
    }

    public static boolean isFoodDrain(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        short facing = 0;
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            facing = me.facing;
        }
        int side = blockSide;
        int meta = world.func_72805_g(x, y, z);
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)1);
        if (blockSide == 6) {
            side = 0;
        } else if (blockSide == 0) {
            meta = 0;
        }
        if (meta == 1) {
            return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[side][facing] + 6];
        }
        return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[side][facing]];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int blockSide, int blockMeta) {
        int offset = MathHelper.func_76125_a((int)blockMeta, (int)0, (int)1) == 0 ? 0 : 6;
        return this.iconBuffer[0][blockSide + offset];
    }

    protected String getMachineFrontIconKey(boolean active) {
        return active ? EnderIOAddons.DOMAIN + ":blockFoodDrainSide" : EnderIOAddons.DOMAIN + ":blockDrainSide";
    }

    protected String getSideIconKey(boolean active) {
        return this.getMachineFrontIconKey(active);
    }

    protected String getBackIconKey(boolean active) {
        return this.getMachineFrontIconKey(active);
    }

    protected String getTopIconKey(boolean active) {
        return active ? EnderIOAddons.DOMAIN + ":blockFoodDrain" : EnderIOAddons.DOMAIN + ":blockDrain";
    }

    protected String getBottomIconKey(boolean active) {
        return active ? EnderIOAddons.DOMAIN + ":blockFoodDrainBottom" : "enderio:machineTemplate";
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (!Config.drainAllowOnDedicatedServer.getBoolean() && !Minecraft.func_71410_x().func_71356_B()) {
            list.add(EnderIO.lang.localize("blockDrain.tooltip.disabledMessage"));
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileDrain) {
            return ((TileDrain)te).getComparatorOutput();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        FluidStack fl;
        if (itemstack.field_77990_d != null && itemstack.field_77990_d.func_74764_b("tankContents") && (fl = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)itemstack.field_77990_d.func_74781_a("tankContents")))) != null && fl.getFluid() != null) {
            String str = fl.amount + " " + EnderIO.lang.localize("fluid.millibucket.abr") + " " + PowerDisplayUtil.ofStr() + " " + fl.getFluid().getLocalizedName(fl);
            list.add(str);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (ItemStack)itemstack);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return stack.func_77977_a();
    }

    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileDrain) {
            TileDrain tank = (TileDrain)te;
            FluidStack stored = tank.tank.getFluid();
            String fluid = stored == null ? EnderIO.lang.localize("tooltip.none") : stored.getFluid().getLocalizedName(stored);
            int amount = stored == null ? 0 : stored.amount;
            tooltip.add(String.format("%s%s : %s (%d %s)", EnumChatFormatting.WHITE, EnderIO.lang.localize("tooltip.fluidStored"), fluid, amount, EnderIO.lang.localize("fluid.millibucket.abr")));
        }
    }

    public int func_149645_b() {
        return this.localRenderId;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
    }

    public boolean isFireSource(final World world, final int x, final int y, final int z, ForgeDirection side) {
        FluidStack fluidStack;
        SmartTank tank;
        TileEntityEnder te;
        if (side == ForgeDirection.UP && (te = this.getTileEntityEio((IBlockAccess)world, x, y, z)) instanceof TileDrain && (tank = ((TileDrain)te).tank).getFluidAmount() > 0 && (fluidStack = tank.getFluid()) != null && fluidStack.getFluid() != null) {
            if (fluidStack.getFluid() == EnderIO.fluidHootch) {
                tank.addFluidAmount(-5);
                ((TileDrain)te).setTanksDirty();
                return true;
            }
            if (fluidStack.getFluid() == EnderIO.fluidFireWater) {
                tank.addFluidAmount(-2);
                ((TileDrain)te).setTanksDirty();
                return true;
            }
            if (fluidStack.getFluid() == EnderIO.fluidRocketFuel) {
                tank.setFluid(null);
                world.func_147468_f(x, y, z);
                world.func_72885_a(null, (double)((float)x + 0.5f), (double)((float)y + 1.5f), (double)((float)z + 0.5f), 3.0f, true, true);
                float range = 1.5f;
                int delay = 0;
                for (int power = tank.getFluidAmount(); power > 0; power -= 333) {
                    final float range2 = range += 1.5f * (float)power / 500.0f;
                    final float kaboom = (float)power / 300.3003f;
                    delay += 7;
                    if (!((float)y + range2 < 255.0f)) continue;
                    Scheduler.instance().schedule(delay, new Runnable(){

                        @Override
                        public void run() {
                            world.func_72885_a(null, (double)((float)x + 0.5f), (double)((float)y + range2), (double)((float)z + 0.5f), kaboom, true, true);
                        }
                    });
                }
                return true;
            }
            if (fluidStack.getFluid() == FluidRegistry.WATER) {
                for (BlockCoord bc1 : BlockDrain.getAround(te.getLocation())) {
                    if (!world.func_72899_e(bc1.x, bc1.y, bc1.z) || bc1.getBlock((IBlockAccess)world) != Blocks.field_150480_ab) continue;
                    world.func_147468_f(bc1.x, bc1.y, bc1.z);
                    world.func_72908_a((double)((float)bc1.x + 0.5f), (double)((float)bc1.y + 0.1f), (double)((float)bc1.z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    tank.addFluidAmount(-20);
                }
                ((TileDrain)te).setTanksDirty();
                return false;
            }
            if (fluidStack.getFluid() == FluidRegistry.LAVA) {
                return world.field_73012_v.nextInt(5) != 0;
            }
        }
        return false;
    }

    private static List<BlockCoord> getAround(BlockCoord bc0) {
        ArrayList<BlockCoord> result = new ArrayList<BlockCoord>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    result.add(new BlockCoord(bc0.x + x, bc0.y + y, bc0.z + z));
                }
            }
        }
        return result;
    }
}

