/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.drain;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderioaddons.HandleSetBlockCoord;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.baseclass.TileEnderIOAddons;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.fluid.Fluids;
import info.loenwind.enderioaddons.machine.drain.BlockDrain;
import info.loenwind.enderioaddons.machine.drain.FluidHelper;
import info.loenwind.enderioaddons.machine.drain.IDrainingCallback;
import info.loenwind.enderioaddons.machine.drain.IWaterSensitive;
import info.loenwind.enderioaddons.machine.drain.InfiniteWaterSourceStopper;
import info.loenwind.enderioaddons.machine.drain.PacketDrain;
import info.loenwind.enderioaddons.machine.drain.filter.FoodFluidFilter;
import info.loenwind.enderioaddons.machine.drain.filter.NoFilter;
import info.loenwind.enderioaddons.machine.drain.filter.TankFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

@Storable
public class TileDrain
extends TileEnderIOAddons
implements IFluidHandler,
IWaterSensitive,
IDrainingCallback,
ITankAccess {
    private static final int ONE_BLOCK_OF_LIQUID = 1000;
    @Nonnull
    private static final FoodFluidFilter filter = new FoodFluidFilter();
    private static int IO_MB_TICK = 100;
    @Nonnull
    @Store
    protected SmartTank tank = new SmartTank(2000);
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    @Store(value={Store.StoreFor.SAVE}, handler=HandleSetBlockCoord.class)
    protected Set<BlockCoord> nowater = new HashSet<BlockCoord>();
    protected boolean registered = false;
    protected int dryruncount = 0;

    public TileDrain() {
        super(new SlotDefinition(1, 1, 1));
    }

    public boolean isFoodDrain() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1;
    }

    protected boolean doPush(@Nullable ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (dir == null || this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.tank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && target.canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
            FluidStack push = this.tank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.getOpposite(), push, true);
            if (filled > 0) {
                this.tank.drain(filled, true);
                this.tankDirty = true;
                return res;
            }
        }
        return res;
    }

    public int fill(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doFill) {
        return 0;
    }

    protected int fillInternal(@Nonnull FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from) || resource == null) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    protected FluidStack drainInternal(@Nonnull FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(@Nullable ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    protected FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        return false;
    }

    public boolean canDrain(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        return this.canDrain(from) && this.tank.canDrainFluidType(fluid);
    }

    private boolean canDrain(@Nullable ForgeDirection from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PULL && mode != IoMode.DISABLED;
    }

    public FluidTankInfo[] getTankInfo(@Nullable ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public String getMachineName() {
        return BlockDrain.ModObject_blockDrain.unlocalisedName;
    }

    protected boolean isMachineItemValidForSlot(int i, @Nullable ItemStack item) {
        if (i == 0 && item != null) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)item) || item.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.canTick(redstoneChecksPassed) && redstoneChecksPassed) {
            return this.doTick();
        }
        return false;
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        int curScaled;
        if (redstoneChecksPassed) {
            if (this.getEnergyStored() < this.getPowerUsePerTick() && !EnderIOAddons.mode24) {
                return false;
            }
            this.usePower();
        }
        if ((curScaled = this.getProgressScaled(16)) != this.lastProgressScaled) {
            this.sendTaskProgressPacket();
            this.lastProgressScaled = curScaled;
        }
        return true;
    }

    protected boolean doTick() {
        int filledLevel;
        if (this.shouldDoWorkThisTick(20)) {
            this.fillEmptyContainer();
        }
        if (this.lastUpdateLevel != (filledLevel = this.getFilledLevel())) {
            this.lastUpdateLevel = filledLevel;
            this.tankDirty = true;
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketDrain(this), (TileEntity)this);
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.tankDirty = false;
        }
        int modulo = 10;
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                modulo = 20;
                break;
            }
            case ACTIVATED_CAPACITOR: {
                modulo = 10;
                break;
            }
            case ENDER_CAPACITOR: {
                modulo = 2;
            }
        }
        if (this.shouldDoWorkThisTick(modulo) && this.tank.getAvailableSpace() >= 1000) {
            FluidHelper instance = null;
            FluidStack tankfluid = this.tank.getFluid();
            if (this.isFoodDrain()) {
                if (Config.foodDrainCollectsFlowingMilk.getBoolean()) {
                    instance = tankfluid != null ? FluidHelper.getInstance(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), NullHelper.notnull(this.getLocation(), "Invalid game state: TE location is missing"), new TankFilter(this.tank), new NoFilter(false)) : FluidHelper.getInstance(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), NullHelper.notnull(this.getLocation(), "Invalid game state: TE location is missing"), filter, new NoFilter(false));
                }
            } else {
                instance = tankfluid != null ? FluidHelper.getInstance(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), NullHelper.notnull(this.getLocation(), "Invalid game state: TE location is missing"), new TankFilter(this.tank), filter) : FluidHelper.getInstance(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), NullHelper.notnull(this.getLocation(), "Invalid game state: TE location is missing"), new NoFilter(true), filter);
            }
            if (instance != null) {
                instance.setDrainingCallback(this);
                FluidHelper.ReturnObject pullFluid = instance.eatOrPullFluid();
                FluidStack resultFluid = pullFluid.result;
                if (resultFluid != null) {
                    this.fillInternal(resultFluid, true);
                    this.usePower(Config.drainPerBucketEnergyUseRF.getInt());
                } else if (pullFluid.inProgress) {
                    this.usePower(Config.drainPerSourceBlockMoveEnergyUseRF.getInt());
                }
                this.dryruncount = 0;
                return true;
            }
            if (Config.foodDrainCollectsMilkFromCows.getBoolean() && this.isFoodDrain() && (tankfluid == null || tankfluid.getFluid() == Fluids.MILK.getFluid())) {
                AxisAlignedBB bb = this.func_145838_q().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).func_72314_b((double)Config.foodDrainRange.getFloat(), 1.5, (double)Config.foodDrainRange.getFloat());
                List cowsInRange = this.field_145850_b.func_72872_a(EntityCow.class, bb);
                for (EntityCow cow : cowsInRange) {
                    if (cow.getClass() != EntityCow.class) continue;
                    this.fillInternal(new FluidStack(Fluids.MILK.getFluid(), 2), true);
                    return true;
                }
            }
            if (this.dryruncount++ > 60) {
                this.dryruncount = 0;
                this.nowater.clear();
                if (this.registered) {
                    InfiniteWaterSourceStopper.getInstance().unregister(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), this);
                    this.registered = false;
                }
            }
        }
        return false;
    }

    public int getComparatorOutput() {
        FluidTankInfo info = this.getTankInfo(null)[0];
        return info == null || info.fluid == null ? 0 : (int)((double)info.fluid.amount / (double)info.capacity * 15.0);
    }

    private boolean fillEmptyContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer((ItemStack)this.inventory[0], (FluidStack)this.getOutputTanks()[0].getFluid());
        if (fill.result.fluidStack == null) {
            return false;
        }
        if (this.inventory[1] != null) {
            if (this.inventory[1].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[1], (ItemStack)fill.result.itemStack) && this.inventory[1].field_77994_a < this.inventory[1].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[1].field_77994_a;
            } else {
                return false;
            }
        }
        this.getOutputTanks()[0].setFluid(fill.remainder.fluidStack);
        this.func_70299_a(0, fill.remainder.itemStack);
        this.func_70299_a(1, fill.result.itemStack);
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return new ContinuousTask((float)this.getPowerUsePerTick());
    }

    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return this.createTask(null);
    }

    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.drainContinuousEnergyUseRF.getInt() * 40, 250000, Config.drainContinuousEnergyUseRF.getInt()));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.drainContinuousEnergyUseRF.getInt() * 40, 500000, Config.drainContinuousEnergyUseRF.getInt()));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.drainContinuousEnergyUseRF.getInt() * 40, 1000000, Config.drainContinuousEnergyUseRF.getInt()));
            }
        }
        this.currentTask = this.createTask(null);
    }

    public void func_145834_a(@Nullable World p_145834_1_) {
        super.func_145834_a(p_145834_1_);
        if (!(this.field_145850_b.field_72995_K || this.nowater.isEmpty() || this.registered)) {
            InfiniteWaterSourceStopper.getInstance().register(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), this);
            this.registered = true;
        }
    }

    @Override
    public boolean preventInfiniteWaterForming(@Nonnull World world, @Nonnull BlockCoord bc) {
        return this.nowater.contains(bc);
    }

    @Override
    public void onWaterDrain(@Nonnull World world, @Nonnull BlockCoord bc) {
        if (!(this.field_145850_b.field_72995_K || this.registered || this.isFoodDrain())) {
            InfiniteWaterSourceStopper.getInstance().register(NullHelper.notnull(this.field_145850_b, "Invalid game state: World is missing"), this);
            this.registered = true;
        }
        this.nowater.add(bc);
    }

    @Override
    public void onWaterDrainNearby(@Nonnull World world, @Nonnull BlockCoord bc) {
        this.nowater.add(bc);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        this.tankDirty = true;
    }
}

