/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.flag;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.SideRestriction;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

@Storable
public class TileFlag
extends TileEntityEio {
    @Store
    private BlockCoord parent = null;
    @SideRestriction(value=Side.CLIENT)
    private long renderAge = -1L;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean isFreshlyPlaced = true;
    @Store
    private boolean isCharged = true;
    private static final String[] soundsIds = new String[]{"machine.flag", "machine.flag.fail"};
    private static final int[] soundDurations = new int[]{81, 3};
    private final long[] lastSoundTick = new long[soundsIds.length];

    public final void readCustomNBT(NBTTagCompound nbtRoot) {
        Reader.read(Store.StoreFor.SAVE, nbtRoot, this);
        this.isFreshlyPlaced = false;
    }

    public final void writeCustomNBT(NBTTagCompound nbtRoot) {
        Writer.write(Store.StoreFor.SAVE, nbtRoot, this);
    }

    public final Packet func_145844_m() {
        NBTTagCompound nbtRoot = new NBTTagCompound();
        Writer.write(Store.StoreFor.CLIENT, nbtRoot, this);
        this.isFreshlyPlaced = false;
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtRoot);
    }

    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbtRoot = pkt.func_148857_g();
        Reader.read(Store.StoreFor.CLIENT, nbtRoot, this);
        if (this.isFreshlyPlaced) {
            this.resetRenderAge(0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void resetRenderAge(int offset) {
        this.renderAge = EnderIO.proxy.getTickCount() - (long)offset;
    }

    public void writeItemStackNBT(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            itemstack.field_77990_d = new NBTTagCompound();
        }
        Writer.write(Store.StoreFor.ITEM, itemstack.field_77990_d, this);
        if (this.parent != null) {
            itemstack.func_151001_c(EnderIOAddons.lang.localizeExact(itemstack.func_77977_a() + ".name") + EnderIOAddons.lang.localize("flag.itemname.parent", new Object[]{this.parent.x, this.parent.y, this.parent.z}));
        } else if (!this.isCharged) {
            itemstack.func_151001_c(EnderIOAddons.lang.localizeExact(itemstack.func_77977_a() + ".name") + EnderIOAddons.lang.localize("flag.itemname.uncharged"));
        }
    }

    public void reparentItemstack(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            itemstack.field_77990_d = new NBTTagCompound();
        }
        BlockCoord tmp = this.parent;
        this.parent = this.getLocation();
        Writer.write(Store.StoreFor.ITEM, itemstack.field_77990_d, this);
        itemstack.func_151001_c(EnderIOAddons.lang.localizeExact(itemstack.func_77977_a() + ".name") + EnderIOAddons.lang.localize("flag.itemname.parent", new Object[]{this.parent.x, this.parent.y, this.parent.z}));
        this.parent = tmp;
    }

    public void readItemStackNBT(ItemStack itemstack) {
        if (itemstack.field_77990_d != null) {
            Reader.read(Store.StoreFor.ITEM, itemstack.field_77990_d, this);
        }
        this.isFreshlyPlaced = true;
    }

    protected boolean shouldUpdate() {
        return false;
    }

    @Nullable
    public BlockCoord getParent() {
        return this.parent;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderAge() {
        if (this.renderAge < 0L) {
            if (this.isFreshlyPlaced) {
                return 0;
            }
            return -1;
        }
        return (int)(EnderIO.proxy.getTickCount() - this.renderAge);
    }

    public void playSound(int id) {
        if (Config.machineSoundsEnabled && this.lastSoundTick[id] <= EnderIO.proxy.getTickCount()) {
            this.lastSoundTick[id] = EnderIO.proxy.getTickCount() + (long)soundDurations[id];
            this.func_145831_w().func_72980_b((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), EnderIOAddons.DOMAIN + ":" + soundsIds[id], Config.machineSoundVolume, 1.0f, false);
        }
    }

    public boolean isCharged() {
        return this.isCharged;
    }

    public void setCharged(boolean isCharged) {
        this.isCharged = isCharged;
        if (!isCharged) {
            this.parent = null;
        }
    }
}

