/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.framework;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.Capacitors;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.Log;
import java.lang.reflect.Field;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;

@Storable
public abstract class AbstractTileFramework
extends AbstractPowerConsumerEntity {
    private boolean noCommon = false;

    public static ResourceLocation getSoundFor(String sound) {
        return sound == null ? null : new ResourceLocation(EnderIOAddons.DOMAIN + ":" + sound);
    }

    public AbstractTileFramework(SlotDefinition slotDefinition) {
        super(slotDefinition);
        try {
            Field field = AbstractMachineEntity.class.getDeclaredField("soundRes");
            field.setAccessible(true);
            field.set((Object)this, AbstractTileFramework.getSoundFor(this.getSoundName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Log.warn("Failed to access sound filed inherited from Ender IO: " + e);
        }
    }

    public int[] func_94128_d(int var1) {
        if (this.isSideDisabled(var1)) {
            return new int[0];
        }
        int[] res = new int[this.inventory.length - this.slotDefinition.getNumUpgradeSlots()];
        int index = 0;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.slotDefinition.isUpgradeSlot(i)) continue;
            res[index] = i;
            ++index;
        }
        return res;
    }

    public void setCapacitor(Capacitors capacitorType) {
        if (this.getCapacitorType() != capacitorType || this.getCapacitor() == capacitorType.capacitor) {
            super.setCapacitor(capacitorType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readCustomNBT(NBTTagCompound nbtRoot) {
        try {
            this.noCommon = true;
            super.readCustomNBT(nbtRoot);
        }
        finally {
            this.noCommon = false;
        }
        Reader.read(Store.StoreFor.SAVE, nbtRoot, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeCustomNBT(NBTTagCompound nbtRoot) {
        try {
            this.noCommon = true;
            super.writeCustomNBT(nbtRoot);
        }
        finally {
            this.noCommon = false;
        }
        Writer.write(Store.StoreFor.SAVE, nbtRoot, this);
    }

    public final void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        if (!this.noCommon) {
            Reader.read(Store.StoreFor.ITEM, nbtRoot, this);
        }
    }

    public final void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        if (!this.noCommon) {
            Writer.write(Store.StoreFor.ITEM, nbtRoot, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Packet func_145844_m() {
        NBTTagCompound nbtRoot = new NBTTagCompound();
        try {
            this.noCommon = true;
            super.writeCustomNBT(nbtRoot);
        }
        finally {
            this.noCommon = false;
        }
        Writer.write(Store.StoreFor.CLIENT, nbtRoot, this);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbtRoot = pkt.func_148857_g();
        Reader.read(Store.StoreFor.CLIENT, nbtRoot, this);
        try {
            this.noCommon = true;
            super.readCustomNBT(nbtRoot);
        }
        finally {
            this.noCommon = false;
        }
    }
}

