/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.ihopper;

import com.enderio.core.client.render.BoundingBox;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.AbstractMachineEntity;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.machine.framework.GroupObjectWithIcon;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.framework.RendererFrameworkMachine;
import info.loenwind.enderioaddons.machine.ihopper.BlockIHopper;
import info.loenwind.enderioaddons.machine.ihopper.TileIHopper;
import info.loenwind.enderioaddons.render.FaceRenderer;
import info.loenwind.enderioaddons.render.OverlayRenderer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererIHopper
implements ISimpleBlockRenderingHandler {
    @Nonnull
    private final RendererFrameworkMachine frameRenderer;
    private static final double px = 0.0625;
    @Nonnull
    private static final ForgeDirection[] positions = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};

    public RendererIHopper(@Nonnull RendererFrameworkMachine frameRenderer) {
        this.frameRenderer = frameRenderer;
        GroupObjectWithIcon controllerActive = new GroupObjectWithIcon(frameRenderer.getControllerPart(5), BlockIHopper.getBlock());
        GroupObjectWithIcon controllerPassive = new GroupObjectWithIcon(frameRenderer.getControllerPart(6), BlockIHopper.getBlock());
        frameRenderer.registerController(BlockIHopper.getBlock().getControllerModelName(), controllerActive, controllerPassive);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.frameRenderer.renderInventoryBlock(block, metadata, modelId, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AbstractMachineEntity machineEntity;
        if (OverlayRenderer.renderOverlays(world, x, y, z, null, renderer.field_147840_d, BlockIHopper.blockIHopper, (TileIHopper)null, true)) {
            return true;
        }
        TileEntity te = world != null ? world.func_147438_o(x, y, z) : null;
        IFrameworkMachine frameworkMachine = te instanceof IFrameworkMachine ? (IFrameworkMachine)te : null;
        AbstractMachineEntity abstractMachineEntity = machineEntity = te instanceof AbstractMachineEntity ? (AbstractMachineEntity)te : null;
        if (frameworkMachine != null && machineEntity != null) {
            FaceRenderer.setLightingReference(world, (Block)BlockIHopper.blockIHopper, x, y, z);
            for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
                if ((tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]")) == IFrameworkMachine.TankSlot.FRONT_LEFT) continue;
                this.renderSubBlock(x, y, z, machineEntity, tankSlot);
            }
            FaceRenderer.clearLightingReference();
        }
        return this.frameRenderer.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockIHopper.blockIHopper.func_149645_b();
    }

    private void renderSubBlock(int x, int y, int z, @Nonnull AbstractMachineEntity te, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        int z1;
        int y1;
        int x1;
        int z0;
        int y0;
        int x0;
        IIcon icon_outside = BlockHopper.func_149916_e((String)"hopper_outside");
        IIcon icon_inside = BlockHopper.func_149916_e((String)"hopper_inside");
        IIcon icon_top = Blocks.field_150438_bZ.func_149691_a(1, 0);
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(NullHelper.notnull(te.getFacingDir(), "Internal state error: Block is not facing any direction"), tankSlot);
        BoundingBox bb1 = RendererIHopper.makePartialBBofSlot(0, 10, 0, 16, 16, 16, pos, x, y, z);
        FaceRenderer.renderSingleFace(bb1, ForgeDirection.UP, icon_top, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSkirt(bb1, icon_outside, 0.0, 16.0, 10.0, 16.0, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb1, ForgeDirection.DOWN, icon_outside, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightness, false);
        BoundingBox bb2 = RendererIHopper.makePartialBBofSlot(2, 10, 2, 14, 16, 14, pos, x, y, z);
        FaceRenderer.renderSkirt(bb2, icon_outside, 2.0, 14.0, 10.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb2, ForgeDirection.DOWN, icon_inside, 2.0, 14.0, 2.0, 14.0, null, FaceRenderer.stdBrightnessInside, true);
        BoundingBox bb3 = RendererIHopper.makePartialBBofSlot(4, 4, 4, 12, 10, 12, pos, x, y, z);
        FaceRenderer.renderSkirt(bb3, icon_outside, 4.0, 12.0, 4.0, 10.0, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb3, ForgeDirection.DOWN, icon_outside, 4.0, 12.0, 4.0, 12.0, null, FaceRenderer.stdBrightness, false);
        ForgeDirection cdir = RendererIHopper.getConnectorDirection(NullHelper.notnull(te.getFacingDir(), "Internal state error: Block is not facing any direction"), tankSlot);
        switch (cdir) {
            case NORTH: {
                x0 = 6;
                y0 = 4;
                z0 = 12;
                x1 = 10;
                y1 = 8;
                z1 = 16;
                break;
            }
            case SOUTH: {
                x0 = 6;
                y0 = 4;
                z0 = 0;
                x1 = 10;
                y1 = 8;
                z1 = 4;
                break;
            }
            case EAST: {
                x0 = 12;
                y0 = 4;
                z0 = 6;
                x1 = 16;
                y1 = 8;
                z1 = 10;
                break;
            }
            case WEST: {
                x0 = 0;
                y0 = 4;
                z0 = 6;
                x1 = 4;
                y1 = 8;
                z1 = 10;
                break;
            }
            case DOWN: {
                x0 = 6;
                y0 = 0;
                z0 = 6;
                x1 = 10;
                y1 = 4;
                z1 = 10;
                break;
            }
            default: {
                return;
            }
        }
        BoundingBox bb4 = RendererIHopper.makePartialBBofSlot(x0, y0, z0, x1, y1, z1, pos, x, y, z);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.UP, icon_outside, (double)x0, (double)x1, (double)z0, (double)z1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.NORTH, icon_outside, (double)x0, (double)x1, (double)y0, (double)y1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.SOUTH, icon_outside, (double)x0, (double)x1, (double)y0, (double)y1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.EAST, icon_outside, (double)z0, (double)z1, (double)y0, (double)y1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.WEST, icon_outside, (double)z0, (double)z1, (double)y0, (double)y1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.DOWN, icon_outside, (double)x0, (double)x1, (double)z0, (double)z1, null, FaceRenderer.stdBrightness, false);
    }

    private static BoundingBox makePartialBBofSlot(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int[] pos, int x, int y, int z) {
        BoundingBox bb = new BoundingBox(0.0625 * (double)minX, 0.0625 * (double)minY, 0.0625 * (double)minZ, 0.0625 * (double)maxX, 0.0625 * (double)maxY, 0.0625 * (double)maxZ);
        bb = RendererIHopper.centerscale(bb, 0.375, 0.375, 0.375);
        bb = bb.translate((float)pos[0] * 4.0f / 16.0f, 0.25f, (float)pos[1] * 4.0f / 16.0f);
        bb = bb.translate((float)x, (float)y, (float)z);
        return bb;
    }

    private static BoundingBox centerscale(BoundingBox bb, double x, double y, double z) {
        return new BoundingBox(((double)bb.minX - 0.5) * x + 0.5, ((double)bb.minY - 0.5) * y + 0.5, ((double)bb.minZ - 0.5) * z + 0.5, ((double)bb.maxX - 0.5) * x + 0.5, ((double)bb.maxY - 0.5) * y + 0.5, ((double)bb.maxZ - 0.5) * z + 0.5);
    }

    private static ForgeDirection getConnectorDirection(@Nonnull ForgeDirection dir, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        switch (dir) {
            case NORTH: {
                return positions[2 + tankSlot.ordinal() & 3];
            }
            case SOUTH: {
                return positions[0 + tankSlot.ordinal() & 3];
            }
            case WEST: {
                return positions[3 + tankSlot.ordinal() & 3];
            }
            case EAST: {
                return positions[1 + tankSlot.ordinal() & 3];
            }
        }
        return positions[0];
    }
}

