/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.ihopper;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.gui.AdvancedRedstoneMode;
import info.loenwind.enderioaddons.gui.IAdvancedRedstoneModeControlable;
import info.loenwind.enderioaddons.machine.framework.AbstractTileFramework;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.ihopper.BlockIHopper;
import info.loenwind.enderioaddons.machine.ihopper.GhostlySlotDefinition;
import info.loenwind.enderioaddons.machine.ihopper.RedstoneModeState;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;

@Storable
public class TileIHopper
extends AbstractTileFramework
implements IFrameworkMachine,
IAdvancedRedstoneModeControlable {
    static final int SLOTS = 6;
    @Store
    private RedstoneModeState redstoneModeState = new RedstoneModeState();
    private Field redstoneStateDirty = null;
    @Store(value={Store.StoreFor.SAVE})
    private boolean requiresResyncForChangedRSMode = false;
    @Store(value={Store.StoreFor.SAVE})
    private boolean hasBeenTriggered = false;
    @Store(value={Store.StoreFor.SAVE})
    private boolean recomputeState = false;

    public TileIHopper() {
        super(new GhostlySlotDefinition(6, 6, 1, 6));
    }

    public String getMachineName() {
        return BlockIHopper.ModObject_blockIHopper.unlocalisedName;
    }

    public void init() {
        super.init();
    }

    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (this.slotDefinition.isInputSlot(i)) {
            int ipos = i - this.slotDefinition.getMinInputSlot();
            int gpos = ((GhostlySlotDefinition)this.slotDefinition).getMinGhostSlot() + ipos;
            return ItemUtil.areStacksEqual((ItemStack)itemstack, (ItemStack)this.func_70301_a(gpos));
        }
        return false;
    }

    public boolean isActive() {
        return this.hasPower() && (this.redstoneCheckPassed || this.hasBeenTriggered);
    }

    public void doUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                if (this.redstoneStateDirty == null) {
                    this.redstoneStateDirty = AbstractMachineEntity.class.getDeclaredField("redstoneStateDirty");
                    this.redstoneStateDirty.setAccessible(true);
                }
                if (this.recomputeState || this.redstoneStateDirty.getBoolean(this)) {
                    this.recomputeState = false;
                    boolean prevRedCheck = this.redstoneCheckPassed;
                    this.redstoneCheckPassed = this.redstoneModeState.isConditionMet(this.func_145831_w(), this.getLocation());
                    this.hasBeenTriggered = this.hasBeenTriggered || this.redstoneCheckPassed;
                    this.redstoneStateDirty.set(this, Boolean.FALSE);
                    this.requiresResyncForChangedRSMode = prevRedCheck != this.redstoneCheckPassed;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Log.error(e.getMessage());
            }
        }
        super.doUpdate();
    }

    protected boolean processTasks(boolean rsCheckPassed) {
        if (this.hasBeenTriggered && this.shouldDoWorkThisTick(this.tickSpeedFromCap())) {
            boolean result = this.processTasksImpl() || this.requiresResyncForChangedRSMode;
            this.hasBeenTriggered = false;
            this.recomputeState = true;
            this.requiresResyncForChangedRSMode = false;
            return result;
        }
        if (this.requiresResyncForChangedRSMode) {
            this.requiresResyncForChangedRSMode = false;
            return true;
        }
        return false;
    }

    private void playSound() {
        if (crazypants.enderio.config.Config.machineSoundsEnabled) {
            this.func_145831_w().func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), EnderIOAddons.DOMAIN + ":machine.ihopper", this.getVolume(), this.getPitch());
        }
    }

    public boolean checkInputSlot(int slot) {
        ItemStack ghostSlot = this.ghostSlot(slot);
        ItemStack inputSlot = this.inputSlot(slot);
        return ghostSlot != null && inputSlot != null && ItemUtil.areStacksEqual((ItemStack)ghostSlot, (ItemStack)inputSlot) && ghostSlot.field_77994_a <= inputSlot.field_77994_a;
    }

    public boolean checkGhostSlot(int slot) {
        ItemStack ghostSlot = this.ghostSlot(slot);
        return ghostSlot != null;
    }

    public boolean checkOutputSlot(int slot) {
        ItemStack ghostSlot = this.ghostSlot(slot);
        ItemStack outputSlot = this.outputSlot(slot);
        return outputSlot == null || ghostSlot != null && ItemUtil.areStackMergable((ItemStack)ghostSlot, (ItemStack)outputSlot) && outputSlot.field_77994_a + ghostSlot.field_77994_a <= outputSlot.func_77976_d();
    }

    private float getPowerNeedForSlot(int slot) {
        ItemStack ghostSlot = this.ghostSlot(slot);
        return ghostSlot != null ? (float)ghostSlot.field_77994_a * Config.impulseHopperRFusePerItem.getFloat() : 0.0f;
    }

    private boolean processTasksImpl() {
        if (this.usePower(Config.impulseHopperRFusePerOperation.getInt())) {
            int slot;
            float neededPower = 0.0f;
            boolean doSomething = false;
            for (slot = 1; slot <= 6; ++slot) {
                if (!this.checkGhostSlot(slot)) continue;
                if (this.checkInputSlot(slot) && this.checkOutputSlot(slot)) {
                    doSomething = true;
                    neededPower += this.getPowerNeedForSlot(slot);
                    continue;
                }
                return false;
            }
            if (!doSomething || !this.usePower(Float.valueOf(neededPower))) {
                return false;
            }
            for (slot = 1; slot <= 6; ++slot) {
                ItemStack result;
                ItemStack ghostSlot = this.ghostSlot(slot);
                ItemStack inputSlot = this.inputSlot(slot);
                if (ghostSlot == null || inputSlot == null) continue;
                ItemStack outputSlot = this.outputSlot(slot);
                if (outputSlot != null) {
                    result = outputSlot.func_77946_l();
                    result.field_77994_a += ghostSlot.field_77994_a;
                    this.func_70299_a(this.outputSlotNo(slot), result);
                } else {
                    result = inputSlot.func_77946_l();
                    result.field_77994_a = ghostSlot.field_77994_a;
                    this.func_70299_a(this.outputSlotNo(slot), result);
                }
                if (ghostSlot.field_77994_a < inputSlot.field_77994_a) {
                    ItemStack remainder = inputSlot.func_77946_l();
                    remainder.field_77994_a -= ghostSlot.field_77994_a;
                    this.func_70299_a(this.inputSlotNo(slot), remainder);
                    continue;
                }
                this.func_70299_a(this.inputSlotNo(slot), null);
            }
            this.playSound();
            return true;
        }
        return false;
    }

    int ghostSlotNo(int no) {
        return no + ((GhostlySlotDefinition)this.slotDefinition).minGhostSlot - 1;
    }

    @Nullable
    ItemStack ghostSlot(int no) {
        return this.inventory[this.ghostSlotNo(no)];
    }

    int outputSlotNo(int no) {
        return no + this.slotDefinition.minOutputSlot - 1;
    }

    @Nullable
    ItemStack outputSlot(int no) {
        return this.inventory[this.outputSlotNo(no)];
    }

    int inputSlotNo(int no) {
        return no + this.slotDefinition.minInputSlot - 1;
    }

    @Nullable
    ItemStack inputSlot(int no) {
        return this.inventory[this.inputSlotNo(no)];
    }

    public boolean canUsePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return (w < 1 ? 1 : w) <= this.getEnergyStored();
    }

    public boolean canUsePower(int wantToUse) {
        return wantToUse <= this.getEnergyStored();
    }

    public boolean usePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return this.usePower(w < 1 ? 1 : w);
    }

    public boolean usePower(int wantToUse) {
        if (EnderIOAddons.mode24) {
            return true;
        }
        if (wantToUse > this.getEnergyStored()) {
            return false;
        }
        this.setEnergyStored(this.getEnergyStored() - wantToUse);
        return true;
    }

    public void onCapacitorTypeChange() {
        int powerPerOps = Config.impulseHopperRFusePerOperation.getInt() + (int)(Config.impulseHopperRFusePerItem.getFloat() * 64.0f * 6.0f);
        int powerPerTick = powerPerOps / this.tickSpeedFromCap();
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierOneRF, 100000, powerPerTick));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierTwoRF, 200000, powerPerTick));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(crazypants.enderio.config.Config.powerConduitTierThreeRF, 500000, powerPerTick));
            }
        }
    }

    private int tickSpeedFromCap() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return Config.impulseHopperWorkEveryTick1.getInt();
            }
            case ACTIVATED_CAPACITOR: {
                return Config.impulseHopperWorkEveryTick2.getInt();
            }
            case ENDER_CAPACITOR: {
                return Config.impulseHopperWorkEveryTick3.getInt();
            }
        }
        return 0;
    }

    public void setGhostSlotContents(int slot, ItemStack contents) {
        if (((GhostlySlotDefinition)this.getSlotDefinition()).isGhostSlot(slot)) {
            super.func_70299_a(slot, contents);
            this.forceClientUpdate = true;
        }
    }

    @Override
    public boolean hasTank(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return false;
    }

    @Override
    public Fluid getTankFluid(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        switch (tankSlot) {
            default: 
        }
        return null;
    }

    @Override
    public boolean hasController() {
        return true;
    }

    @Override
    public String getControllerModelName() {
        return BlockIHopper.blockIHopper.getControllerModelName();
    }

    @Override
    public boolean renderSlot(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return false;
    }

    @Override
    public IIcon getSlotIcon(@Nonnull IFrameworkMachine.TankSlot tankSlot, int side) {
        return null;
    }

    @Override
    public AdvancedRedstoneMode getAdvancedRedstoneControlMode() {
        return this.redstoneModeState.getMode();
    }

    @Override
    public void setAdvancedRedstoneControlMode(AdvancedRedstoneMode mode) {
        this.redstoneModeState.setMode(mode);
        this.setRedstoneControlMode(this.getRedstoneControlMode());
    }
}

