/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.niard;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.xp.XpUtil;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.fluid.FluidType;
import info.loenwind.enderioaddons.machine.niard.RadiusIterator;
import info.loenwind.enderioaddons.machine.niard.TileNiard;
import info.loenwind.enderioaddons.network.PacketParticles;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class EngineNiard {
    private final TileNiard owner;
    private Fluid fluid = null;
    private Block block;
    private FluidType type;
    private ForgeDirection downflowDirection;
    private int radius = -1;
    private RadiusIterator radiusItr;

    public EngineNiard(TileNiard owner) {
        this.owner = owner;
    }

    public EngineNiard setFluid(Fluid fluid) {
        if (fluid.canBePlacedInWorld()) {
            this.radiusItr = this.radius >= 0 ? new RadiusIterator(this.owner.getLocation(), this.radius) : null;
            this.fluid = fluid;
            this.downflowDirection = fluid.getDensity() > 0 ? ForgeDirection.DOWN : ForgeDirection.UP;
            this.block = fluid.getBlock();
            if (this.block instanceof BlockFluidClassic) {
                this.type = FluidType.CLASSIC;
            } else if (this.block instanceof BlockFluidFinite) {
                this.type = FluidType.FINITE;
            } else if (this.block instanceof BlockLiquid) {
                this.type = FluidType.VANILLA;
            } else {
                this.fluid = null;
            }
        } else {
            this.fluid = null;
        }
        return this;
    }

    public EngineNiard setRadius(int radius) {
        if (radius != this.radius) {
            this.radius = radius;
            this.radiusItr = new RadiusIterator(this.owner.getLocation(), radius);
        }
        return this;
    }

    public boolean work() {
        if (this.fluid == null || this.radius < 0) {
            return false;
        }
        for (int i = 0; i < this.radiusItr.size(); ++i) {
            ArrayList<BlockCoord> seen = new ArrayList<BlockCoord>();
            BlockCoord base = this.radiusItr.next();
            BlockCoord next = base.getLocation(this.downflowDirection);
            while (this.isInWorld(next) && (this.owner.func_145831_w().func_147437_c(next.x, next.y, next.z) || this.isSameLiquid(next) && this.isFlowingBlock(next))) {
                seen.add(next);
                next = next.getLocation(this.downflowDirection);
            }
            if (seen.isEmpty()) continue;
            this.setSourceBlock((BlockCoord)seen.remove(seen.size() - 1));
            if (!seen.isEmpty()) {
                for (BlockCoord bc : seen) {
                    this.setVerticalBlock(bc, false);
                }
            }
            this.owner.func_145831_w().func_147444_c(base.x, base.y, base.z, base.getBlock((IBlockAccess)this.owner.func_145831_w()));
            return true;
        }
        return false;
    }

    public int work(int xp_in_mb) {
        int remaining = XpUtil.liquidToExperience((int)xp_in_mb);
        if (this.radius >= 0) {
            for (int i = 0; i < this.radiusItr.size(); ++i) {
                BlockCoord next = this.radiusItr.next().getLocation(ForgeDirection.DOWN);
                if (!this.isInWorld(next) || !this.owner.func_145831_w().func_147437_c(next.x, next.y, next.z)) continue;
                int i1 = EntityXPOrb.func_70527_a((int)(remaining / (this.owner.func_145831_w().field_73012_v.nextInt(4) + 1)));
                remaining -= i1;
                EntityXPOrb xpOrb = new EntityXPOrb(this.owner.func_145831_w(), (double)next.x + 0.5, (double)next.y + 0.7, (double)next.z + 0.5, i1);
                xpOrb.field_70159_w /= 4.0;
                xpOrb.field_70181_x = 0.0;
                xpOrb.field_70179_y /= 4.0;
                this.owner.func_145831_w().func_72838_d((Entity)xpOrb);
                if (remaining > 0) continue;
                return 0;
            }
        }
        return XpUtil.experienceToLiquid((int)remaining);
    }

    private boolean isInWorld(BlockCoord bc) {
        return this.owner.func_145831_w().func_72899_e(bc.x, bc.y, bc.z);
    }

    private boolean isSameLiquid(@Nonnull BlockCoord bc) {
        Block wblock = bc.getBlock((IBlockAccess)this.owner.func_145831_w());
        return wblock == this.block || this.block == Blocks.field_150355_j && wblock == Blocks.field_150358_i || this.block == Blocks.field_150353_l && wblock == Blocks.field_150356_k;
    }

    private boolean isFlowingBlock(@Nonnull BlockCoord bc) {
        switch (this.type) {
            case CLASSIC: {
                return !((BlockFluidClassic)this.block).isSourceBlock((IBlockAccess)this.owner.func_145831_w(), bc.x, bc.y, bc.z);
            }
            case FINITE: {
                return false;
            }
            case VANILLA: {
                return this.owner.func_145831_w().func_72805_g(bc.x, bc.y, bc.z) != 0;
            }
        }
        throw new IllegalStateException("unreachable code");
    }

    private void setSourceBlock(BlockCoord bc) {
        Block blockToSet = this.block;
        int metaToSet = 0;
        World world = this.owner.func_145831_w();
        switch (this.type) {
            case CLASSIC: {
                metaToSet = ((BlockFluidClassic)this.block).getMaxRenderHeightMeta();
                break;
            }
            case FINITE: {
                metaToSet = ((BlockFluidFinite)this.block).getMaxRenderHeightMeta();
                break;
            }
            case VANILLA: {
                if (world.field_73011_w.field_76575_d && this.fluid == FluidRegistry.WATER && !Config.niardAllowWaterInHell.getBoolean()) {
                    world.func_72908_a((double)((float)bc.x + 0.5f), (double)((float)bc.y + 0.1f), (double)((float)bc.z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int l = 0; l < 8; ++l) {
                        PacketParticles.spawnParticle(world, "largesmoke", (double)(bc.x - 1) + 3.0 * Math.random(), (double)bc.y + Math.random(), (double)(bc.z - 1) + 3.0 * Math.random(), 0.0, 0.0, 0.0);
                    }
                    this.setVerticalBlock(bc, false);
                    return;
                }
                metaToSet = 0;
            }
        }
        world.func_147465_d(bc.x, bc.y, bc.z, blockToSet, metaToSet, 3);
    }

    private void setVerticalBlock(BlockCoord bc, boolean blockUpdate) {
        Block blockToSet = this.block;
        int metaToSet = 0;
        switch (this.type) {
            case CLASSIC: {
                metaToSet = 1;
                break;
            }
            case FINITE: {
                return;
            }
            case VANILLA: {
                metaToSet = 8;
            }
        }
        this.owner.func_145831_w().func_147465_d(bc.x, bc.y, bc.z, blockToSet, metaToSet, blockUpdate ? 3 : 2);
    }
}

