/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.pmon;

public class StatArray {
    public static final int MAX_VALUES = 100;
    public static final int BITS = 6;
    public static final int BYTES;
    public static final int MAX_VALUE;
    private final byte[] b = new byte[BYTES];

    public int getBit(int bit, int pos) {
        assert (bit >= 0);
        assert (bit < 6);
        assert (pos >= 0);
        assert (pos < 100);
        int posr = bit * 100 + pos;
        int idx1 = posr >> 3;
        int idx2 = 1 << (posr & 7);
        return (this.b[idx1] & idx2) == 0 ? 0 : 1 << bit;
    }

    public int getValue(int pos) {
        assert (pos >= 0);
        assert (pos < 100);
        int result = 0;
        for (int i = 0; i < 6; ++i) {
            result += this.getBit(i, pos);
        }
        return result;
    }

    public void setBit(int bit, int pos, int value) {
        assert (bit >= 0);
        assert (bit < 6);
        assert (pos >= 0);
        assert (pos < 100);
        int posr = bit * 100 + pos;
        int idx1 = posr >> 3;
        int idx2 = 1 << (posr & 7);
        if ((value & 1 << bit) == 0) {
            int n = idx1;
            this.b[n] = (byte)(this.b[n] & ~idx2);
        } else {
            int n = idx1;
            this.b[n] = (byte)(this.b[n] | idx2);
        }
    }

    public void setValue(int pos, int value) {
        assert (pos >= 0);
        assert (pos < 100);
        assert (value >= 0);
        assert (value <= MAX_VALUE) : value + " > " + MAX_VALUE;
        for (int i = 0; i < 6; ++i) {
            this.setBit(i, pos, value);
        }
    }

    public void store(byte[] data, int offset) {
        for (int i = 0; i < BYTES; ++i) {
            data[i + offset] = this.b[i];
        }
    }

    public void read(byte[] data, int offset) {
        for (int i = 0; i < BYTES; ++i) {
            this.b[i] = data[i + offset];
        }
    }

    static {
        int i;
        int b = 0;
        int v = 0;
        for (i = 600; i > 0; i -= 8) {
            ++b;
        }
        for (i = 0; i < 6; ++i) {
            v = v << 1 | 1;
        }
        BYTES = b;
        MAX_VALUE = v;
    }
}

