/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.pmon;

import info.loenwind.enderioaddons.machine.pmon.StatArray;

public class StatCollector {
    public static final int MAX_VALUES = 100;
    private final int max_values;
    private final StatArray mins = new StatArray();
    private final StatArray maxs = new StatArray();
    private final int collectTarget;
    private int collectCount;
    private int pos;

    public StatCollector(int collectTarget, int max_values) {
        this.collectTarget = collectTarget;
        this.collectCount = collectTarget;
        this.pos = -1;
        this.max_values = max_values;
    }

    public StatCollector(int collectTarget) {
        this.collectTarget = collectTarget;
        this.collectCount = collectTarget;
        this.pos = -1;
        this.max_values = 100;
    }

    public void addValue(int value) {
        assert (this.collectCount <= this.collectTarget);
        assert (this.collectCount > 0);
        assert (this.pos < this.max_values);
        if (this.collectCount == this.collectTarget) {
            ++this.pos;
            assert (this.pos >= 0);
            if (this.pos >= this.max_values) {
                this.pos = 0;
            }
            this.mins.setValue(this.pos, value);
            this.maxs.setValue(this.pos, value);
            this.collectCount = 1;
        } else {
            assert (this.pos >= 0);
            if (value < this.mins.getValue(this.pos)) {
                this.mins.setValue(this.pos, value);
            }
            if (value > this.maxs.getValue(this.pos)) {
                this.maxs.setValue(this.pos, value);
            }
            ++this.collectCount;
        }
    }

    public int[][] getValues() {
        int[][] result = new int[][]{new int[100], new int[100]};
        for (int i = 0; i < this.max_values; ++i) {
            int j = i + this.pos + 1;
            if (j >= this.max_values) {
                j -= this.max_values;
            }
            assert (j >= 0);
            assert (j < this.max_values);
            result[0][i] = this.mins.getValue(j);
            result[1][i] = this.maxs.getValue(j);
        }
        return result;
    }

    public byte[] getData() {
        byte[] data = new byte[StatArray.BYTES * 2];
        this.mins.store(data, 0);
        this.maxs.store(data, StatArray.BYTES);
        return data;
    }

    public void setData(byte[] data) {
        if (data != null && data.length == StatArray.BYTES * 2) {
            this.mins.read(data, 0);
            this.maxs.read(data, StatArray.BYTES);
        }
    }

    public int getCollectCount() {
        return this.collectCount;
    }

    public void setCollectCount(int collectCount) {
        this.collectCount = collectCount;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }
}

