/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.tcom;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.SideRestriction;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.machine.framework.AbstractTileFramework;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.tcom.BlockTcom;
import info.loenwind.enderioaddons.machine.tcom.ContainerTcom;
import info.loenwind.enderioaddons.machine.tcom.PacketTcomUpdate;
import info.loenwind.enderioaddons.machine.tcom.engine.EngineTcom;
import info.loenwind.enderioaddons.machine.tcom.engine.Mats;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.Fluid;

@Storable
public class TileTcom
extends AbstractTileFramework
implements IFrameworkMachine,
IProgressTile {
    @Store
    protected EngineTcom engine = new EngineTcom(Config.tcomRecyclingLossFix.getFloat(), Config.tcomRecyclingLossChanced.getFloat());
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected int progress_in = 0;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected ItemStack buffer_in = null;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected int progress_enchant = 0;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected ItemStack buffer_enchant_result = null;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected ItemStack buffer_enchant_original = null;
    protected EntityPlayerMP buffer_enchant_player = null;
    private static final String[] soundsIds = new String[]{"machine.tcom.in", "machine.tcom.enchant", "machine.tcom.fail", "machine.tcom.enchant.fail"};
    private static final int[] soundDurations = new int[]{45, 36, 5, 41};
    private final long[] lastSoundTick = new long[soundsIds.length];
    @SideRestriction(value=Side.CLIENT)
    public final int[] renderData = new int[]{160, 1, 15, 0};
    @SideRestriction(value=Side.CLIENT)
    public long lastRenderTick = 0L;

    public TileTcom() {
        super(new SlotDefinition(2, 2, 0));
    }

    public String getMachineName() {
        return BlockTcom.ModObject_blockTcom.unlocalisedName;
    }

    public void init() {
        super.init();
    }

    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (this.slotDefinition.isInputSlot(i)) {
            if (i == this.slotDefinition.getMinInputSlot()) {
                return this.engine.addable(itemstack);
            }
            return this.engine.isValidTarget(itemstack);
        }
        return false;
    }

    public boolean isActive() {
        return false;
    }

    protected boolean processTasks(boolean rsCheckPassed) {
        if (rsCheckPassed) {
            if (!this.process_in_progress() && this.progress_in == 0 && this.inventory[this.slotDefinition.getMinInputSlot()] != null) {
                this.takeCareOfStrayItem(this.buffer_in);
                this.buffer_in = this.inventory[this.slotDefinition.getMinInputSlot()].func_77946_l();
                if (this.buffer_in.field_77994_a == 1) {
                    this.inventory[this.slotDefinition.getMinInputSlot()] = null;
                } else {
                    --this.inventory[this.slotDefinition.getMinInputSlot()].field_77994_a;
                    this.buffer_in.field_77994_a = 1;
                }
                this.progress_in = 1;
                this.func_70296_d();
                this.playSound_in();
                this.updateClients();
            }
            this.process_enchant_progress();
        }
        return false;
    }

    private void takeCareOfStrayItem(@Nullable ItemStack item) {
        if (item != null) {
            if (this.inventory[this.slotDefinition.getMinOutputSlot()] == null) {
                this.inventory[this.slotDefinition.getMinOutputSlot()] = item;
                this.func_70296_d();
            } else if (this.inventory[this.slotDefinition.getMinOutputSlot() + 1] == null) {
                this.inventory[this.slotDefinition.getMinOutputSlot() + 1] = item;
                this.func_70296_d();
            } else {
                ItemUtil.spawnItemInWorldWithRandomMotion((World)this.func_145831_w(), (ItemStack)this.buffer_in, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            }
        }
    }

    private boolean process_in_progress() {
        if (this.progress_in > 0 && this.usePower(Config.tcomRecyclingPowerPerTick.getInt())) {
            ++this.progress_in;
            if (this.progress_in > Config.tcomRecyclingTicksPerItem.getInt()) {
                if (this.buffer_in != null && this.engine.add(this.buffer_in)) {
                    this.updateClients();
                } else {
                    this.takeCareOfStrayItem(this.buffer_in);
                }
                this.func_70296_d();
                this.buffer_in = null;
                this.progress_in = 0;
            }
            return true;
        }
        return false;
    }

    public void extractItems(Mats mat, EntityPlayerMP player) {
        ItemStack target;
        if (!this.engine.canGet(mat)) {
            this.playSound_fail();
            return;
        }
        if (this.inventory[this.slotDefinition.getMinOutputSlot()] == null) {
            target = mat.getItemStack().func_77946_l();
            target.field_77994_a = 0;
        } else if (mat.isSame(this.inventory[this.slotDefinition.getMinOutputSlot()])) {
            target = this.inventory[this.slotDefinition.getMinOutputSlot()];
            if (target.field_77994_a >= target.func_77976_d()) {
                this.playSound_fail();
                return;
            }
        } else {
            this.playSound_fail();
            return;
        }
        while (target.field_77994_a < target.func_77976_d()) {
            if (this.canUsePower(Config.tcomExtractingPowerPerItem.getInt())) {
                if (!this.engine.get(mat)) break;
                ++target.field_77994_a;
                this.usePower(Config.tcomExtractingPowerPerItem.getInt());
                continue;
            }
            this.playSound_fail();
            break;
        }
        this.inventory[this.slotDefinition.getMinOutputSlot()] = target.field_77994_a > 0 ? target : null;
        this.func_70296_d();
        this.updateClient(player);
    }

    public void extractEnchantment(int id, EntityPlayerMP player) {
        if (this.progress_enchant > 0 || this.inventory[this.slotDefinition.getMinOutputSlot() + 1] != null || this.inventory[this.slotDefinition.getMinInputSlot() + 1] == null) {
            this.playSound_fail();
            return;
        }
        if (this.engine.canAddEnchantment(this.inventory[this.slotDefinition.getMinInputSlot() + 1], id)) {
            this.buffer_enchant_original = this.inventory[this.slotDefinition.getMinInputSlot() + 1].func_77946_l();
            this.buffer_enchant_original.field_77994_a = 1;
            this.buffer_enchant_result = this.buffer_enchant_original.func_77946_l();
            if (this.engine.addEnchantment(this.buffer_enchant_result, id, (int)this.getEnchantPower() + this.buffer_enchant_result.func_77973_b().getItemEnchantability(this.buffer_enchant_result) / 2)) {
                if (this.inventory[this.slotDefinition.getMinInputSlot() + 1].field_77994_a == 1) {
                    this.inventory[this.slotDefinition.getMinInputSlot() + 1] = null;
                } else {
                    --this.inventory[this.slotDefinition.getMinInputSlot() + 1].field_77994_a;
                }
                this.progress_enchant = 1;
                this.buffer_enchant_player = player;
                this.func_70296_d();
                this.updateClient(player);
            } else {
                this.buffer_enchant_original = null;
                this.buffer_enchant_result = null;
                this.playSound_fail();
            }
        } else {
            this.playSound_fail();
        }
    }

    private void process_enchant_progress() {
        if (this.progress_enchant > 0 && this.usePower(Config.tcomEnchantingPowerPerTick.getInt())) {
            ++this.progress_enchant;
            if (this.progress_enchant > Config.tcomEnchantingTicksPerItem.getInt()) {
                if (this.buffer_enchant_result != null && this.buffer_enchant_original != null) {
                    int levels = TileTcom.countEnchantmentLevels(this.buffer_enchant_result);
                    if (levels > this.func_145831_w().field_73012_v.nextInt(levels + 10 + (int)this.getEnchantPower() + this.buffer_enchant_result.func_77973_b().getItemEnchantability(this.buffer_enchant_result))) {
                        this.buffer_enchant_result = this.buffer_enchant_original;
                        this.usePower(Config.tcomEnchantingPowerPerFailure.getInt());
                        this.playSound_enchant_fail();
                    } else {
                        this.playSound_enchant();
                    }
                    if (this.inventory[this.slotDefinition.getMinOutputSlot() + 1] == null) {
                        this.inventory[this.slotDefinition.getMinOutputSlot() + 1] = this.buffer_enchant_result;
                    } else {
                        this.takeCareOfStrayItem(this.buffer_enchant_result);
                    }
                    this.updateClient(this.buffer_enchant_player);
                } else {
                    this.takeCareOfStrayItem(this.buffer_enchant_original);
                }
                this.func_70296_d();
                this.buffer_enchant_original = null;
                this.buffer_enchant_result = null;
                this.buffer_enchant_player = null;
                this.progress_enchant = 0;
            }
        }
    }

    private static int countEnchantmentLevels(ItemStack itemStack) {
        int result = 0;
        Map enchantmentsOnItemStack = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        for (Integer level : enchantmentsOnItemStack.values()) {
            result += level.intValue();
        }
        return result;
    }

    private float getEnchantPower() {
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !this.func_145831_w().func_147437_c(this.field_145851_c + k, this.field_145848_d, this.field_145849_e + j) || !this.func_145831_w().func_147437_c(this.field_145851_c + k, this.field_145848_d + 1, this.field_145849_e + j)) continue;
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k * 2), (int)this.field_145848_d, (int)(this.field_145849_e + j * 2));
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k * 2), (int)(this.field_145848_d + 1), (int)(this.field_145849_e + j * 2));
                if (k == 0 || j == 0) continue;
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k * 2), (int)this.field_145848_d, (int)(this.field_145849_e + j));
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k * 2), (int)(this.field_145848_d + 1), (int)(this.field_145849_e + j));
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k), (int)this.field_145848_d, (int)(this.field_145849_e + j * 2));
                power += ForgeHooks.getEnchantPower((World)this.func_145831_w(), (int)(this.field_145851_c + k), (int)(this.field_145848_d + 1), (int)(this.field_145849_e + j * 2));
            }
        }
        return power;
    }

    public void updateClient(EntityPlayerMP player) {
        try {
            if (player != null && player.field_71070_bA instanceof ContainerTcom) {
                PacketHandler.sendTo((IMessage)new PacketTcomUpdate(this, true), (EntityPlayerMP)player);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateClients() {
        PacketHandler.sendToAllAround((IMessage)new PacketTcomUpdate(this, false), (TileEntity)this);
    }

    private void playSound(int id) {
        if (crazypants.enderio.config.Config.machineSoundsEnabled && this.lastSoundTick[id] <= EnderIO.proxy.getTickCount()) {
            this.lastSoundTick[id] = EnderIO.proxy.getTickCount() + (long)soundDurations[id];
            this.func_145831_w().func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), EnderIOAddons.DOMAIN + ":" + soundsIds[id], this.getVolume(), 1.0f);
        }
    }

    private void playSound_in() {
        this.playSound(0);
    }

    private void playSound_enchant() {
        this.playSound(1);
    }

    private void playSound_fail() {
        this.playSound(2);
    }

    private void playSound_enchant_fail() {
        this.playSound(3);
    }

    public boolean canUsePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return EnderIOAddons.mode24 || (w < 1 ? 1 : w) <= this.getEnergyStored();
    }

    public boolean canUsePower(int wantToUse) {
        return EnderIOAddons.mode24 || wantToUse <= this.getEnergyStored();
    }

    public boolean usePower(Float wantToUse) {
        int w = wantToUse.intValue();
        return EnderIOAddons.mode24 || this.usePower(w < 1 ? 1 : w);
    }

    public boolean usePower(int wantToUse) {
        if (EnderIOAddons.mode24) {
            return true;
        }
        if (wantToUse > this.getEnergyStored()) {
            return false;
        }
        this.setEnergyStored(this.getEnergyStored() - wantToUse);
        return true;
    }

    public void onCapacitorTypeChange() {
        this.setCapacitor((ICapacitor)new BasicCapacitor(Config.tcomPowerIntakePerTick.getInt(), 10000, Config.tcomEnchantingPowerPerTick.getInt() + Config.tcomRecyclingPowerPerTick.getInt()));
    }

    @Override
    public boolean hasTank(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return tankSlot == IFrameworkMachine.TankSlot.FRONT_RIGHT;
    }

    @Override
    public Fluid getTankFluid(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return null;
    }

    @Override
    public boolean hasController() {
        return true;
    }

    @Override
    public String getControllerModelName() {
        return BlockTcom.blockTcom.getControllerModelName();
    }

    @Override
    public boolean renderSlot(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return false;
    }

    @Override
    public IIcon getSlotIcon(@Nonnull IFrameworkMachine.TankSlot tankSlot, int side) {
        return null;
    }

    public float getProgress() {
        return this.progress_in * 1000 + this.progress_enchant;
    }

    @SideOnly(value=Side.CLIENT)
    public float getWorkProgress_in() {
        return (float)this.progress_in / Config.tcomRecyclingTicksPerItem.getFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public float getWorkProgress_enchant() {
        return (float)this.progress_enchant / Config.tcomEnchantingTicksPerItem.getFloat();
    }

    public void setProgress(float progress) {
        if (progress > 0.0f) {
            int p = (int)progress;
            this.progress_in = p / 1000;
            this.progress_enchant = p - this.progress_in * 1000;
        } else {
            this.progress_in = 0;
            this.progress_enchant = 0;
        }
    }

    public TileEntity getTileEntity() {
        return this;
    }
}

