/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks;

import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.gui.GuiEIOABase;
import info.loenwind.enderioaddons.machine.waterworks.ContainerWaterworks;
import info.loenwind.enderioaddons.machine.waterworks.TileWaterworks;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiWaterworks
extends GuiEIOABase<TileWaterworks> {
    @Nonnull
    private static final String GUI_TEXTURE = EnderIOAddons.DOMAIN + ":textures/gui/waterworks.png";

    public GuiWaterworks(InventoryPlayer par1InventoryPlayer, @Nonnull TileWaterworks te) {
        super(te, (Container)new ContainerWaterworks(par1InventoryPlayer, te));
        this.addToolTip(new GuiToolTip(new Rectangle(30, 9, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("tank.tank");
                if (((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).inputTank.getFluid() != null) {
                    heading = heading + ": " + ((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).inputTank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).inputTank));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(79, 9, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("tank.tank");
                if (((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).outputTank.getFluid() != null) {
                    heading = heading + ": " + ((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).outputTank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).outputTank));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(29, 77, 66, 3), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("waterworks.stashprogress");
                heading = heading + ": ";
                heading = heading + (((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).stashProgress > 0.0f ? Integer.valueOf(MathHelper.func_76125_a((int)((int)(((TileWaterworks)((GuiWaterworks)GuiWaterworks.this).getTileEntity()).stashProgress * 100.0f)), (int)1, (int)99)) : "0");
                heading = heading + "%";
                this.text.add(heading);
            }
        });
    }

    protected int getPowerHeight() {
        return 47;
    }

    protected int getPowerY() {
        return 9;
    }

    protected boolean showRecipeButton() {
        return false;
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        Fluid progress_in;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.func_73729_b(this.field_147003_i + 55, this.field_147009_r + 61 + 14 - scaled, 176, 14 - scaled, 14, scaled);
        }
        if (((TileWaterworks)this.getTileEntity()).inputTank.getFluid() != null) {
            RenderUtil.renderGuiTank((FluidTank)((TileWaterworks)this.getTileEntity()).inputTank, (double)(this.field_147003_i + 29), (double)(this.field_147009_r + 9), (double)this.field_73735_i, (double)16.0, (double)47.0);
        }
        if (((TileWaterworks)this.getTileEntity()).outputTank.getFluid() != null) {
            RenderUtil.renderGuiTank((FluidTank)((TileWaterworks)this.getTileEntity()).outputTank, (double)(this.field_147003_i + 78), (double)(this.field_147009_r + 9), (double)this.field_73735_i, (double)16.0, (double)47.0);
        }
        if ((progress_in = ((TileWaterworks)this.getTileEntity()).progress_in) != null) {
            RenderUtil.bindBlockTexture();
            GL11.glEnable((int)3042);
            float progress0 = ((TileWaterworks)this.getTileEntity()).getProgress();
            if (progress0 >= 0.0f) {
                float progress = MathHelper.func_76131_a((float)(progress0 * 1.3f - 0.15f), (float)0.0f, (float)1.0f);
                Fluid progress_out = ((TileWaterworks)this.getTileEntity()).progress_out;
                int cfactor = progress_out != null ? Config.waterWorksWaterReductionPercentage.getInt() : 0;
                int hmin = 26 * cfactor / 100;
                int h = (int)((float)hmin + (1.0f - progress) * (float)(26 - hmin));
                int offset = 26 - h;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * (1.0f - progress0)));
                this.func_94065_a(this.field_147003_i + 50, this.field_147009_r + 32 + offset, progress_in.getStillIcon(), 24, h);
                if (progress_out != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * progress0));
                    this.func_94065_a(this.field_147003_i + 50, this.field_147009_r + 32 + offset, progress_out.getStillIcon(), 24, h);
                }
                GL11.glDisable((int)3042);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)GUI_TEXTURE);
        if ((double)((TileWaterworks)this.getTileEntity()).stashProgress > 0.0) {
            int size = MathHelper.func_76125_a((int)((int)(64.0f * ((TileWaterworks)this.getTileEntity()).stashProgress)), (int)1, (int)64);
            this.func_73729_b(this.field_147003_i + 30, this.field_147009_r + 78, 188, 94, size, 1);
        }
        this.func_73729_b(this.field_147003_i + 50, this.field_147009_r + 32, 208, 6, 24, 26);
        this.func_73729_b(this.field_147003_i + 29, this.field_147009_r + 9, 196, 41, 16, 47);
        this.func_73729_b(this.field_147003_i + 78, this.field_147009_r + 9, 214, 41, 16, 47);
        super.func_146976_a(par1, par2, par3);
        RenderUtil.bindBlockTexture();
    }
}

