/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.enderioaddons.machine.waterworks.TileWaterworks;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketWaterworksProgress
extends MessageTileEntity<TileWaterworks>
implements IMessageHandler<PacketWaterworksProgress, IMessage> {
    private float progress = 0.0f;
    private int inputTankId = -1;
    private int inputTankAmount = -1;
    private int outputTankId = -1;
    private int outputTankAmount = -1;
    private int progress_inId = -1;
    private int progress_outId = -1;
    private float stashProgress = 0.0f;

    public PacketWaterworksProgress() {
    }

    public PacketWaterworksProgress(@Nonnull TileWaterworks te) {
        super((TileEntity)te);
        Fluid progress_out;
        Fluid progress_in;
        this.progress = te.getProgress();
        this.inputTankAmount = te.inputTank.getFluidAmount();
        if (this.inputTankAmount > 0) {
            this.inputTankId = te.inputTank.getFluid().getFluidID();
        }
        this.outputTankAmount = te.outputTank.getFluidAmount();
        if (this.outputTankAmount > 0) {
            this.outputTankId = te.outputTank.getFluid().getFluidID();
        }
        if ((progress_in = te.progress_in) != null) {
            this.progress_inId = progress_in.getID();
        }
        if ((progress_out = te.progress_out) != null) {
            this.progress_outId = progress_out.getID();
        }
        this.stashProgress = te.stashProgress;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
        buf.writeInt(this.inputTankId);
        buf.writeInt(this.inputTankAmount);
        buf.writeInt(this.outputTankId);
        buf.writeInt(this.outputTankAmount);
        buf.writeInt(this.progress_inId);
        buf.writeInt(this.progress_outId);
        buf.writeFloat(this.stashProgress);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
        this.inputTankId = buf.readInt();
        this.inputTankAmount = buf.readInt();
        this.outputTankId = buf.readInt();
        this.outputTankAmount = buf.readInt();
        this.progress_inId = buf.readInt();
        this.progress_outId = buf.readInt();
        this.stashProgress = buf.readFloat();
    }

    public IMessage onMessage(PacketWaterworksProgress message, MessageContext ctx) {
        TileWaterworks te = (TileWaterworks)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (te != null) {
            te.setProgress(message.progress);
            PacketWaterworksProgress.setTank(te.inputTank, message.inputTankAmount, message.inputTankId);
            PacketWaterworksProgress.setTank(te.outputTank, message.outputTankAmount, message.outputTankId);
            if (message.progress_inId >= 0) {
                te.progress_in = FluidRegistry.getFluid((int)message.progress_inId);
            }
            te.progress_out = message.progress_outId >= 0 ? FluidRegistry.getFluid((int)message.progress_outId) : null;
            te.stashProgress = message.stashProgress;
        }
        return null;
    }

    private static void setTank(@Nonnull SmartTank tank, int amount, int flid) {
        if (amount > 0) {
            if (tank.getFluid() != null && flid == tank.getFluid().getFluidID()) {
                tank.setFluidAmount(amount);
            } else {
                tank.setFluid(new FluidStack(FluidRegistry.getFluid((int)flid), amount));
            }
        } else {
            tank.setFluid(null);
        }
    }
}

