/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.plant;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import crazypants.enderio.power.IPowerStorage;
import info.loenwind.enderioaddons.common.Log;
import info.loenwind.enderioaddons.common.WorldHelper;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.config.ItemHelper;
import info.loenwind.enderioaddons.recipe.Recipes;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EioaGrowthRequirement
implements IGrowthRequirement {
    private BlockWithMeta capBank;
    private BlockWithMeta bedrock;
    private BlockWithMeta darkBar;
    private final int[] brightness = new int[]{13, 15, 0, 0};

    public EioaGrowthRequirement() {
        this.capBank = new BlockWithMeta(Block.func_149634_a((Item)Recipes.capBankCreative.func_77973_b()), 1, true);
        this.bedrock = new BlockWithMeta(Blocks.field_150357_h, Short.MAX_VALUE, true);
        this.darkBar = new BlockWithMeta(Block.func_149634_a((Item)Recipes.darkSteelBars.func_77973_b()), Short.MAX_VALUE, true);
        List<ItemStack> list = ItemHelper.readList(Config.plantRequiredBlocks);
        if (list != null) {
            if (list.size() == 3) {
                ItemStack itemStackCapBank = list.get(0);
                Block blockCapBank = Block.func_149634_a((Item)itemStackCapBank.func_77973_b());
                if (blockCapBank != null) {
                    if (itemStackCapBank.func_77960_j() <= 15 || itemStackCapBank.func_77960_j() == Short.MAX_VALUE) {
                        this.capBank = new BlockWithMeta(blockCapBank, itemStackCapBank.func_77960_j(), true);
                    } else {
                        Log.warn("Config value 'plantRequiredBlocks' is invalid (first element has invalid meta) and will be (partially) ignored.");
                    }
                } else {
                    Log.warn("Config value 'plantRequiredBlocks' is invalid (first element has no block) and will be (partially) ignored.");
                }
                ItemStack itemStackBedrock = list.get(1);
                Block blockBedrock = Block.func_149634_a((Item)itemStackBedrock.func_77973_b());
                if (blockBedrock != null) {
                    if (itemStackBedrock.func_77960_j() <= 15 || itemStackBedrock.func_77960_j() == Short.MAX_VALUE) {
                        this.bedrock = new BlockWithMeta(blockBedrock, itemStackBedrock.func_77960_j(), true);
                    } else {
                        Log.warn("Config value 'plantRequiredBlocks' is invalid (second element has invalid meta) and will be (partially) ignored.");
                    }
                } else {
                    Log.warn("Config value 'plantRequiredBlocks' is invalid (second element has no block) and will be (partially) ignored.");
                }
                ItemStack itemStackDarkBar = list.get(2);
                Block blockDarkBar = Block.func_149634_a((Item)itemStackDarkBar.func_77973_b());
                if (blockDarkBar != null) {
                    if (itemStackDarkBar.func_77960_j() <= 15 || itemStackDarkBar.func_77960_j() == Short.MAX_VALUE) {
                        this.darkBar = new BlockWithMeta(blockDarkBar, itemStackDarkBar.func_77960_j(), true);
                    } else {
                        Log.warn("Config value 'plantRequiredBlocks' is invalid (third element has invalid meta) and will be (partially) ignored.");
                    }
                } else {
                    Log.warn("Config value 'plantRequiredBlocks' is invalid (third element has no block) and will be (partially) ignored.");
                }
            } else {
                Log.warn("Config value 'plantRequiredBlocks' is invalid (wrong number of items) and will be ignored.");
            }
        }
        try {
            Class<?> newGrowthRequirementHandler = Class.forName("com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler");
            if (newGrowthRequirementHandler != null) {
                Log.debug("An newer version of AgriCraft is in use, our soil will be registered automatically.");
                return;
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            Log.debug("An older version of AgriCraft is in use, manually registering our soil.");
        }
        try {
            Method addSoil;
            Class<?> growthRequirementHandler = Class.forName("com.InfinityRaider.AgriCraft.farming.GrowthRequirementHandler");
            if (growthRequirementHandler != null && (addSoil = growthRequirementHandler.getMethod("addSoil", BlockWithMeta.class)) != null) {
                addSoil.invoke(null, this.capBank);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Log.warn("Failed to register soil with AgriCraft. Error:");
            e.printStackTrace();
        }
    }

    public boolean canGrow(World world, int x, int y, int z) {
        if (Config.growthRequirementDebuggingEnabled.getBoolean()) {
            String txt = "Plant at " + x + "/" + y + "/" + z + ": ";
            txt = this.isValidSoil(world, x, y - 1, z) ? txt + "Soil (" + this.capBank + ") is valid. " : txt + "Soil (" + this.capBank + ") is NOT valid, it is " + WorldHelper.getBlock(world, x, y, z) + ":" + WorldHelper.getMeta(world, x, y, z) + ". ";
            txt = this.isBaseBlockPresent(world, x, y, z) ? txt + "Base block (" + this.bedrock + ") is valid directly below soil. " : (this.isBaseBlockPresent(world, x, y - 1, z) ? txt + "Base block (" + this.bedrock + ") is valid one below soil. " : txt + "Base block (" + this.bedrock + ") is MISSING. Block directly below soil is " + WorldHelper.getBlock(world, x, y - 1, z) + ":" + WorldHelper.getMeta(world, x, y - 1, z) + ", block below that is " + WorldHelper.getBlock(world, x, y - 2, z) + ":" + WorldHelper.getMeta(world, x, y - 2, z) + ". ");
            txt = this.areBarsPresent(world, x, y, z) ? txt + "Bars (" + this.darkBar + ") are valid. " : txt + "Bars (" + this.darkBar + ") are NOT valid. ";
            txt = this.isBrightnessOk(world, x, y, z) ? txt + "Light levels (sky light " + this.brightness[2] + "..." + this.brightness[3] + " and block light " + this.brightness[0] + "..." + this.brightness[1] + ") are ok. " : txt + "Light levels (sky light " + this.brightness[2] + "..." + this.brightness[3] + " and block light " + this.brightness[0] + "..." + this.brightness[1] + ") are NOT ok, sky light is " + world.func_72972_b(EnumSkyBlock.Sky, x, y, z) + ", block light is " + world.func_72972_b(EnumSkyBlock.Block, x, y, z) + ". ";
            txt = world.field_72995_K ? txt + "Power level in the capacitor bank can only be checked server-side. " : (EioaGrowthRequirement.hasPower(world, x, y, z) ? txt + "Power level in the capacitor bank is ok. " : txt + "Power level in the capacitor bank is too low. ");
            Log.info(txt);
        }
        return this.isValidSoil(world, x, y - 1, z) && (this.isBaseBlockPresent(world, x, y, z) || this.isBaseBlockPresent(world, x, y - 1, z)) && this.areBarsPresent(world, x, y, z) && this.isBrightnessOk(world, x, y, z) && EioaGrowthRequirement.hasPower(world, x, y, z);
    }

    public static boolean hasPower(World world, int x, int y, int z) {
        IPowerStorage te;
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_147438_o(x, y - 1, z);
        return tileEntity instanceof IPowerStorage && (te = (IPowerStorage)tileEntity).getEnergyStoredL() >= (long)Config.seedsRFperGrowthTick.getInt();
    }

    public static boolean usePower(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y - 1, z);
        if (tileEntity instanceof IPowerStorage) {
            IPowerStorage te = (IPowerStorage)tileEntity;
            if (te.getEnergyStoredL() >= (long)Config.seedsRFperGrowthTick.getInt()) {
                te.addEnergy(-Config.seedsRFperGrowthTick.getInt());
                return true;
            }
            te.addEnergy((int)(-te.getEnergyStoredL()));
            return false;
        }
        return false;
    }

    public boolean areBarsPresent(World world, int x, int y, int z) {
        int count = 0;
        for (int x1 = x - 1; x1 <= x + 1; ++x1) {
            for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                if (x1 == x && z1 == z || !EioaGrowthRequirement.isBlock(world, x1, y, z1, this.darkBar) && !EioaGrowthRequirement.isBlock(world, x1, y, z1, this.bedrock) || ++count < 6) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBaseBlockPresent(World world, int x, int y, int z) {
        if (this.bedrock == null) {
            return true;
        }
        return EioaGrowthRequirement.isBlock(world, x, y - 2, z, this.bedrock);
    }

    private static boolean isBlock(World world, int x, int y, int z, BlockWithMeta bwm) {
        return WorldHelper.getBlock(world, x, y, z) == bwm.getBlock() && (bwm.ignoreMeta() || WorldHelper.getMeta(world, x, y, z) == bwm.getMeta());
    }

    public boolean isValidSoil(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block != this.capBank.getBlock()) {
            return false;
        }
        if (this.capBank.ignoreMeta()) {
            return true;
        }
        return world.func_72805_g(x, y, z) == this.capBank.getMeta();
    }

    public boolean isBrightnessOk(World world, int x, int y, int z) {
        int skyLight = world.func_72972_b(EnumSkyBlock.Sky, x, y, z);
        int blockLight = world.func_72972_b(EnumSkyBlock.Block, x, y, z);
        return skyLight >= this.brightness[2] && skyLight <= this.brightness[3] && blockLight >= this.brightness[0] && blockLight <= this.brightness[1];
    }

    public boolean isValidSoil(BlockWithMeta soil) {
        return this.capBank.equals((Object)soil);
    }

    public ItemStack requiredBlockAsItemStack() {
        return this.bedrock != null ? this.bedrock.toStack() : null;
    }

    public RequirementType getRequiredType() {
        return RequirementType.BELOW;
    }

    public BlockWithMeta getSoil() {
        return this.capBank;
    }

    public void setSoil(BlockWithMeta soil) {
        this.capBank = soil;
    }

    public int[] getBrightnessRange() {
        return this.brightness;
    }

    public void setBrightnessRange(int min, int max) {
        this.brightness[0] = min & 0xF;
        this.brightness[1] = max & 0xF;
        this.brightness[2] = min >> 4;
        this.brightness[3] = max >> 4;
    }

    public void setRequiredBlock(BlockWithMeta requiredBlock, RequirementType requirementType, boolean oreDict) {
        this.bedrock = requiredBlock;
    }

    public BlockWithMeta getRequiredBlock() {
        return this.bedrock;
    }

    public boolean isOreDict() {
        return true;
    }
}

