/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api.internal;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import net.minecraft.nbt.NBTTagCompound;

public class EntrySet {
    public BookletPage page;
    public IBookletChapter chapter;
    public IBookletEntry entry;
    public int pageInIndex;

    public EntrySet(IBookletEntry entry) {
        this(null, null, entry, 1);
    }

    public EntrySet(BookletPage page, IBookletChapter chapter, IBookletEntry entry, int pageInIndex) {
        this.setEntry(page, chapter, entry, pageInIndex);
    }

    public void setEntry(BookletPage page, IBookletChapter chapter, IBookletEntry entry, int pageInIndex) {
        this.page = page;
        this.chapter = chapter;
        this.entry = entry;
        this.pageInIndex = pageInIndex;
    }

    public static EntrySet readFromNBT(NBTTagCompound compound) {
        if (compound != null && compound.func_74764_b("Entry")) {
            int entry = compound.func_74762_e("Entry");
            int chapter = compound.func_74762_e("Chapter");
            int page = compound.func_74762_e("Page");
            IBookletEntry currentEntry = entry == -1 ? null : ActuallyAdditionsAPI.bookletEntries.get(entry);
            IBookletChapter currentChapter = chapter == -1 || entry == -1 || currentEntry.getChapters().size() <= chapter ? null : currentEntry.getChapters().get(chapter);
            BookletPage currentPage = chapter == -1 || currentChapter == null || currentChapter.getPages().length <= page - 1 ? null : currentChapter.getPages()[page - 1];
            int pageInIndex = compound.func_74762_e("PageInIndex");
            return new EntrySet(currentPage, currentChapter, currentEntry, pageInIndex);
        }
        return new EntrySet(null);
    }

    public void removeEntry() {
        this.setEntry(null, null, null, 1);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Entry", this.entry == null ? -1 : ActuallyAdditionsAPI.bookletEntries.indexOf(this.entry));
        compound.func_74768_a("Chapter", this.entry == null || this.chapter == null ? -1 : this.entry.getChapters().indexOf(this.chapter));
        compound.func_74768_a("Page", this.page == null ? -1 : this.page.getID());
        compound.func_74768_a("PageInIndex", this.pageInIndex);
        return compound;
    }
}

