/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.api.recipe.coffee;

import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeIngredient;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;

public class CoffeeBrewing {
    public static boolean addEffectToStack(ItemStack stack, CoffeeIngredient ingredient) {
        PotionEffect[] effects;
        boolean worked = false;
        if (ingredient != null && (effects = ingredient.getEffects()) != null && effects.length > 0) {
            for (PotionEffect effect : effects) {
                PotionEffect effectHas = CoffeeBrewing.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.func_76458_c() >= ingredient.maxAmplifier - 1) continue;
                    CoffeeBrewing.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                CoffeeBrewing.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    public static PotionEffect getSameEffectFromStack(ItemStack stack, PotionEffect effect) {
        PotionEffect[] effectsStack = CoffeeBrewing.getEffectsFromStack(stack);
        if (effectsStack != null && effectsStack.length > 0) {
            for (PotionEffect effectStack : effectsStack) {
                if (effect.func_76456_a() != effectStack.func_76456_a()) continue;
                return effectStack;
            }
        }
        return null;
    }

    public static void addEffectProperties(ItemStack stack, PotionEffect effect, boolean addDur, boolean addAmp) {
        PotionEffect[] effects = CoffeeBrewing.getEffectsFromStack(stack);
        stack.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < effects.length; ++i) {
            if (effects[i].func_76456_a() == effect.func_76456_a()) {
                effects[i] = new PotionEffect(effects[i].func_76456_a(), effects[i].func_76459_b() + (addDur ? effect.func_76459_b() : 0), effects[i].func_76458_c() + (addAmp ? (effect.func_76458_c() > 0 ? effect.func_76458_c() : 1) : 0));
            }
            CoffeeBrewing.addEffectToStack(stack, effects[i]);
        }
    }

    public static void addEffectToStack(ItemStack stack, PotionEffect effect) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        int prevCounter = tag.func_74762_e("Counter");
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", effect.func_76456_a());
        compound.func_74768_a("Duration", effect.func_76459_b());
        compound.func_74768_a("Amplifier", effect.func_76458_c());
        int counter = prevCounter + 1;
        tag.func_74782_a(counter + "", (NBTBase)compound);
        tag.func_74768_a("Counter", counter);
        stack.func_77982_d(tag);
    }

    public static PotionEffect[] getEffectsFromStack(ItemStack stack) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            for (int counter = tag.func_74762_e("Counter"); counter > 0; --counter) {
                NBTTagCompound compound = (NBTTagCompound)tag.func_74781_a(counter + "");
                PotionEffect effect = new PotionEffect(compound.func_74762_e("ID"), compound.func_74762_e("Duration"), (int)compound.func_74771_c("Amplifier"));
                if (effect.func_76456_a() <= 0) continue;
                effects.add(effect);
            }
        }
        return effects.size() > 0 ? effects.toArray(new PotionEffect[effects.size()]) : null;
    }
}

