/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheColoredLampColors;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockColoredLamp
extends BlockBase {
    public static TheColoredLampColors[] allLampTypes = TheColoredLampColors.values();
    public boolean isOn;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;

    public BlockColoredLamp(boolean isOn, String name) {
        super(Material.field_151591_t, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(3.0f);
        this.isOn = isOn;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta >= allLampTypes.length ? null : this.textures[meta];
    }

    public Item func_149650_a(int par1, Random rand, int par3) {
        return Item.func_150898_a((Block)InitBlocks.blockColoredLamp);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                world.func_147465_d(x, y, z, this.isOn ? InitBlocks.blockColoredLamp : InitBlocks.blockColoredLampOn, world.func_72805_g(x, y, z), 2);
            }
            return true;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)player.func_71045_bC());
        if (oreIDs.length > 0) {
            for (int oreID : oreIDs) {
                String name = OreDictionary.getOreName((int)oreID);
                TheColoredLampColors color = TheColoredLampColors.getColorFromDyeName(name);
                if (color == null || world.func_72805_g(x, y, z) == color.ordinal()) continue;
                if (!world.field_72995_K) {
                    world.func_72921_c(x, y, z, color.ordinal(), 2);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack func_149644_j(int meta) {
        return new ItemStack(InitBlocks.blockColoredLamp, 1, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)InitBlocks.blockColoredLamp);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < allLampTypes.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.textures = new IIcon[allLampTypes.length];
        for (int i = 0; i < allLampTypes.length; ++i) {
            this.textures[i] = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + BlockColoredLamp.allLampTypes[i].name);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.isOn ? 15 : 0;
    }

    @Override
    public Class<? extends ItemBlockBase> getItemBlock() {
        return TheItemBlock.class;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.rare;
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77653_i(ItemStack stack) {
            if (stack.func_77960_j() >= allLampTypes.length) {
                return null;
            }
            return StringUtil.localize(this.func_77667_c(stack) + ".name") + (((BlockColoredLamp)this.field_150939_a).isOn ? " (" + StringUtil.localize("tooltip." + ModUtil.MOD_ID_LOWER + ".onSuffix.desc") + ")" : "");
        }

        @Override
        public String func_77667_c(ItemStack stack) {
            return InitBlocks.blockColoredLamp.func_149739_a() + BlockColoredLamp.allLampTypes[stack.func_77960_j()].name;
        }
    }
}

